/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.fd;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.utils.XmlUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GenerateInstantRunAppInfoTask
extends BaseTask {
    private File outputFile;
    private FileCollection mergedManifests;
    private InstantRunBuildContext buildcontext;
    private SplitScope splitScope;

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    @InputFiles
    public FileCollection getMergedManifests() {
        return this.mergedManifests;
    }

    @Input
    public long getSecretToken() {
        return this.buildcontext.getSecretToken();
    }

    @TaskAction
    public void generateInfoTask() throws IOException {
        BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, this.mergedManifests);
        Optional<BuildOutput> mainSplitOutput = this.splitScope.getOutputs(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS).stream().filter(splitOutput -> splitOutput.getApkInfo().getType() == VariantOutput.OutputType.FULL_SPLIT || splitOutput.getApkInfo().getType() == VariantOutput.OutputType.MAIN).findFirst();
        if (!mainSplitOutput.isPresent()) {
            throw new RuntimeException("Cannot find main merged manifest.");
        }
        File manifestFile = mainSplitOutput.get().getOutputFile();
        if (manifestFile.exists()) {
            try {
                String applicationId;
                Document document = XmlUtils.parseUtfXmlFile((File)manifestFile, (boolean)true);
                Element root = document.getDocumentElement();
                if (root != null && !(applicationId = root.getAttribute("package")).isEmpty()) {
                    this.writeAppInfoClass(applicationId, this.getSecretToken());
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new BuildException("Failed to inject bootstrapping application", (Throwable)e);
            }
        }
    }

    void writeAppInfoClass(String applicationId, long token) throws IOException {
        ClassWriter cw = new ClassWriter(0);
        String appInfoOwner = "com/android/tools/fd/runtime/AppInfo";
        cw.visit(50, 33, appInfoOwner, null, "java/lang/Object", null);
        FieldVisitor fv = cw.visitField(9, "applicationId", "Ljava/lang/String;", null, null);
        fv.visitEnd();
        fv = cw.visitField(9, "token", "J", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + appInfoOwner + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)applicationId);
        mv.visitFieldInsn(179, appInfoOwner, "applicationId", "Ljava/lang/String;");
        if (token != 0L) {
            mv.visitLdcInsn((Object)token);
        } else {
            mv.visitInsn(9);
        }
        mv.visitFieldInsn(179, appInfoOwner, "token", "J");
        mv.visitInsn(177);
        mv.visitMaxs(2, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        try (JarOutputStream outputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.getOutputFile())));){
            outputStream.putNextEntry(new ZipEntry("com/android/tools/fd/runtime/AppInfo.class"));
            outputStream.write(bytes);
            outputStream.closeEntry();
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateInstantRunAppInfoTask> {
        private final InstantRunVariantScope variantScope;
        private final TransformVariantScope transformVariantScope;
        private final FileCollection manifests;

        public ConfigAction(TransformVariantScope transformVariantScope, InstantRunVariantScope variantScope, FileCollection manifests) {
            this.transformVariantScope = transformVariantScope;
            this.variantScope = variantScope;
            this.manifests = manifests;
        }

        @Override
        public String getName() {
            return this.transformVariantScope.getTaskName("generate", "InstantRunAppInfo");
        }

        @Override
        public Class<GenerateInstantRunAppInfoTask> getType() {
            return GenerateInstantRunAppInfoTask.class;
        }

        @Override
        public void execute(GenerateInstantRunAppInfoTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.splitScope = this.transformVariantScope.getSplitScope();
            task.buildcontext = this.variantScope.getInstantRunBuildContext();
            task.outputFile = new File(this.variantScope.getIncrementalApplicationSupportDir(), "instant-run-bootstrap.jar");
            task.mergedManifests = this.manifests;
        }
    }
}

