/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.dsl.StringToEnumConverters;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PostprocessingOptions {
    private static final String AUTO = "auto";
    private boolean removeUnusedCode;
    private boolean removeUnusedResources;
    private boolean obfuscate;
    private boolean optimizeCode;
    private List<File> proguardFiles = new ArrayList<File>();
    private List<File> testProguardFiles = new ArrayList<File>();
    private List<File> consumerProguardFiles = new ArrayList<File>();
    private CodeShrinker codeShrinker;

    public void initWith(PostprocessingOptions that) {
        this.removeUnusedCode = that.isRemoveUnusedCode();
        this.removeUnusedResources = that.isRemoveUnusedResources();
        this.obfuscate = that.isObfuscate();
        this.optimizeCode = that.isOptimizeCode();
        this.proguardFiles = Lists.newArrayList(that.getProguardFiles());
        this.testProguardFiles = Lists.newArrayList(that.getTestProguardFiles());
        this.consumerProguardFiles = Lists.newArrayList(that.getConsumerProguardFiles());
        this.codeShrinker = that.getCodeShrinkerEnum();
    }

    public boolean isRemoveUnusedCode() {
        return this.removeUnusedCode;
    }

    public void setRemoveUnusedCode(boolean removeUnusedCode) {
        this.removeUnusedCode = removeUnusedCode;
    }

    public boolean isRemoveUnusedResources() {
        return this.removeUnusedResources;
    }

    public void setRemoveUnusedResources(boolean removeUnusedResources) {
        this.removeUnusedResources = removeUnusedResources;
    }

    public boolean isObfuscate() {
        return this.obfuscate;
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public boolean isOptimizeCode() {
        return this.optimizeCode;
    }

    public void setOptimizeCode(boolean optimizeCode) {
        this.optimizeCode = optimizeCode;
    }

    public List<File> getProguardFiles() {
        return this.proguardFiles;
    }

    public void setProguardFiles(List<File> proguardFiles) {
        this.proguardFiles = proguardFiles;
    }

    public List<File> getTestProguardFiles() {
        return this.testProguardFiles;
    }

    public void setTestProguardFiles(List<File> testProguardFiles) {
        this.testProguardFiles = testProguardFiles;
    }

    public List<File> getConsumerProguardFiles() {
        return this.consumerProguardFiles;
    }

    public void setConsumerProguardFiles(List<File> consumerProguardFiles) {
        this.consumerProguardFiles = consumerProguardFiles;
    }

    public String getCodeShrinker() {
        if (this.codeShrinker == null) {
            return AUTO;
        }
        return (String)Verify.verifyNotNull((Object)StringToEnumConverters.forClass(CodeShrinker.class).reverse().convert((Object)this.codeShrinker));
    }

    public void setCodeShrinker(String name) {
        this.codeShrinker = name.equals(AUTO) ? null : (CodeShrinker)((Object)StringToEnumConverters.forClass(CodeShrinker.class).convert((Object)name));
    }

    public CodeShrinker getCodeShrinkerEnum() {
        return this.codeShrinker;
    }
}

