/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.DexPackagingPolicy;
import com.android.sdklib.AndroidVersion;

public enum InstantRunPatchingPolicy {
    PRE_LOLLIPOP(DexPackagingPolicy.STANDARD, false),
    MULTI_APK(DexPackagingPolicy.INSTANT_RUN_MULTI_APK, true);

    private final DexPackagingPolicy dexPatchingPolicy;
    private final boolean useMultiDex;

    private InstantRunPatchingPolicy(DexPackagingPolicy dexPatchingPolicy, boolean useMultiDex) {
        this.dexPatchingPolicy = dexPatchingPolicy;
        this.useMultiDex = useMultiDex;
    }

    public boolean useMultiDex() {
        return this.useMultiDex;
    }

    public DexPackagingPolicy getDexPatchingPolicy() {
        return this.dexPatchingPolicy;
    }

    public static InstantRunPatchingPolicy getPatchingPolicy(AndroidVersion androidVersion) {
        if (androidVersion.getFeatureLevel() < AndroidVersion.ART_RUNTIME.getFeatureLevel()) {
            return PRE_LOLLIPOP;
        }
        return MULTI_APK;
    }
}

