/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.apkzlib.zfile.ApkCreatorFactory;
import com.android.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.api.Project;

public class IncrementalPackagerBuilder {
    private PrivateKey key;
    private X509Certificate certificate;
    private boolean v1SigningEnabled;
    private boolean v2SigningEnabled;
    private File outputFile;
    private int minSdk = 1;
    private NativeLibrariesPackagingMode nativeLibrariesPackagingMode;
    private Predicate<String> noCompressPredicate;
    private Project project;
    private File intermediateDir;
    private String createdBy;
    private boolean debuggableBuild;
    private boolean jniDebuggableBuild;
    private Set<String> abiFilters = new HashSet<String>();
    private File manifest;
    private AaptOptions aaptOptions;

    public IncrementalPackagerBuilder withSigning(SigningConfig signingConfig) {
        try {
            if (signingConfig != null && signingConfig.isSigningReady()) {
                CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyAlias())));
                this.key = certificateInfo.getKey();
                this.certificate = certificateInfo.getCertificate();
                this.v1SigningEnabled = signingConfig.isV1SigningEnabled();
                this.v2SigningEnabled = signingConfig.isV2SigningEnabled();
            }
        }
        catch (KeytoolException | FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public IncrementalPackagerBuilder withOutputFile(File f) {
        this.outputFile = f;
        return this;
    }

    public IncrementalPackagerBuilder withMinSdk(int minSdk) {
        this.minSdk = minSdk;
        return this;
    }

    public IncrementalPackagerBuilder withNativeLibraryPackagingMode(NativeLibrariesPackagingMode packagingMode) {
        this.nativeLibrariesPackagingMode = packagingMode;
        return this;
    }

    public IncrementalPackagerBuilder withManifest(File manifest) {
        this.manifest = manifest;
        return this;
    }

    public IncrementalPackagerBuilder withNoCompressPredicate(Predicate<String> noCompressPredicate) {
        this.noCompressPredicate = noCompressPredicate;
        return this;
    }

    public IncrementalPackagerBuilder withAaptOptions(AaptOptions options) {
        this.aaptOptions = options;
        return this;
    }

    public IncrementalPackagerBuilder withProject(Project project) {
        this.project = project;
        return this;
    }

    public IncrementalPackagerBuilder withIntermediateDir(File intermediateDir) {
        this.intermediateDir = intermediateDir;
        return this;
    }

    public IncrementalPackagerBuilder withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public IncrementalPackagerBuilder withDebuggableBuild(boolean debuggableBuild) {
        this.debuggableBuild = debuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withJniDebuggableBuild(boolean jniDebuggableBuild) {
        this.jniDebuggableBuild = jniDebuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withAcceptedAbis(Set<String> acceptedAbis) {
        this.abiFilters = ImmutableSet.copyOf(acceptedAbis);
        return this;
    }

    public IncrementalPackager build() {
        Preconditions.checkState((this.outputFile != null ? 1 : 0) != 0, (Object)"outputFile == null");
        Preconditions.checkState((this.project != null ? 1 : 0) != 0, (Object)"project == null");
        Preconditions.checkState((this.intermediateDir != null ? 1 : 0) != 0, (Object)"intermediateDir == null");
        if (this.noCompressPredicate == null) {
            this.noCompressPredicate = this.manifest != null && this.aaptOptions != null ? PackagingUtils.getNoCompressPredicate((AaptOptions)this.aaptOptions, (File)this.manifest) : path -> false;
        }
        if (this.nativeLibrariesPackagingMode == null) {
            this.nativeLibrariesPackagingMode = this.manifest != null ? PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)this.manifest) : NativeLibrariesPackagingMode.COMPRESSED;
        }
        ApkCreatorFactory.CreationData creationData = new ApkCreatorFactory.CreationData(this.outputFile, this.key, this.certificate, this.v1SigningEnabled, this.v2SigningEnabled, null, this.createdBy, this.minSdk, this.nativeLibrariesPackagingMode, this.noCompressPredicate);
        try {
            return new IncrementalPackager(creationData, this.intermediateDir, ApkCreatorFactories.fromProjectProperties(this.project, this.debuggableBuild), this.abiFilters, this.jniDebuggableBuild);
        }
        catch (PackagerException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

