/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class TestPreBuildTask
extends DefaultAndroidTask {
    private ArtifactCollection testedRuntimeClasspath;
    private ArtifactCollection testRuntimeClasspath;
    private File fakeOutputDirectory;

    @Classpath
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getTestedRuntimeClasspath() {
        return this.testedRuntimeClasspath.getArtifactFiles();
    }

    @Classpath
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getTestRuntimeClasspath() {
        return this.testRuntimeClasspath.getArtifactFiles();
    }

    @OutputDirectory
    public File getFakeOutputDirectory() {
        return this.fakeOutputDirectory;
    }

    @TaskAction
    void run() {
        Map subMap;
        ModuleComponentIdentifier moduleId;
        ComponentIdentifier componentIdentifier;
        Set testedArtifacts = this.testedRuntimeClasspath.getArtifacts();
        Set testArtifacts = this.testRuntimeClasspath.getArtifacts();
        HashMap testedIds = Maps.newHashMapWithExpectedSize((int)testedArtifacts.size());
        for (ResolvedArtifactResult artifact : testedArtifacts) {
            componentIdentifier = artifact.getId().getComponentIdentifier();
            if (!(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
            moduleId = (ModuleComponentIdentifier)componentIdentifier;
            subMap = testedIds.computeIfAbsent(moduleId.getGroup(), s -> new HashMap());
            subMap.put(moduleId.getModule(), moduleId.getVersion());
        }
        for (ResolvedArtifactResult artifact : testArtifacts) {
            String testedVersion;
            componentIdentifier = artifact.getId().getComponentIdentifier();
            if (!(componentIdentifier instanceof ModuleComponentIdentifier) || (subMap = (Map)testedIds.get((moduleId = (ModuleComponentIdentifier)componentIdentifier).getGroup())) == null || (testedVersion = (String)subMap.get(moduleId.getModule())) == null || testedVersion.equals(moduleId.getVersion())) continue;
            throw new GradleException(String.format("Conflict with dependency '%s:%s' in project '%s'. Resolved versions for app (%s) and test app (%s) differ. See http://g.co/androidstudio/app-test-app-conflict for details.", moduleId.getGroup(), moduleId.getModule(), this.getProject().getPath(), testedVersion, moduleId.getVersion()));
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<TestPreBuildTask> {
        private final VariantScope variantScope;

        public ConfigAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("pre", "Build");
        }

        @Override
        public Class<TestPreBuildTask> getType() {
            return TestPreBuildTask.class;
        }

        @Override
        public void execute(TestPreBuildTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.testedRuntimeClasspath = this.variantScope.getTestedVariantData().getScope().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES);
            task.testRuntimeClasspath = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES);
            task.fakeOutputDirectory = new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "prebuild/" + this.variantScope.getVariantConfiguration().getDirName());
            this.variantScope.getVariantData().preBuildTask = task;
        }
    }
}

