/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransformCallable;
import com.android.build.gradle.internal.transforms.PreDexTransform;
import com.android.builder.core.DexOptions;
import com.android.builder.core.ErrorReporter;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;

public class DexArchiveBuilderTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexArchiveBuilderTransform.class);
    private final DexOptions dexOptions;
    private final ErrorReporter errorReporter;
    private final FileCache userLevelCache;
    private final FileCache projectLevelCache;
    private final WaitableExecutor executor;
    private final int minSdkVersion;

    public DexArchiveBuilderTransform(DexOptions dexOptions, ErrorReporter errorReporter, FileCache userLevelCache, FileCache projectLevelCache, int minSdkVersion) {
        this.dexOptions = dexOptions;
        this.errorReporter = errorReporter;
        this.userLevelCache = userLevelCache;
        this.projectLevelCache = projectLevelCache;
        this.minSdkVersion = minSdkVersion;
        this.executor = WaitableExecutor.useGlobalSharedThreadPool();
    }

    public String getName() {
        return "dexBuilder";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING;
    }

    public Map<String, Object> getParameterInputs() {
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)4);
            params.put("optimize", !this.dexOptions.getAdditionalParameters().contains("--no-optimize"));
            params.put("jumbo", this.dexOptions.getJumboMode());
            params.put("dx-version", "1.13");
            params.put("min-sdk-version", this.minSdkVersion);
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)"Missing output provider.");
        if (this.dexOptions.getAdditionalParameters().contains("--no-optimize")) {
            logger.warning("Disabling dex optimization produces wrong local debug info, b.android.com/82031.", new Object[0]);
        }
        logger.verbose("Task is incremental : %b ", transformInvocation.isIncremental());
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.errorReporter});
        if (!transformInvocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        ProcessOutput processOutput = null;
        try (ProcessOutput ignored = processOutput = outputHandler.createOutput();){
            HashSet hashes = Sets.newHashSet();
            for (TransformInput input : transformInvocation.getInputs()) {
                for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                    logger.verbose("Dir input %s", dirInput.getFile().toString());
                    File preDexOutputFile = this.getPreDexFile(outputProvider, (QualifiedContent)dirInput);
                    this.processDirectoryInput(preDexOutputFile, processOutput, hashes, dirInput, transformInvocation.isIncremental());
                }
                for (JarInput jarInput : input.getJarInputs()) {
                    logger.verbose("Jar input %s", jarInput.getFile().toString());
                    File preDexFile = this.getPreDexFile(outputProvider, (QualifiedContent)jarInput);
                    this.processJarInput(preDexFile, processOutput, hashes, jarInput, transformInvocation.isIncremental());
                }
            }
            this.executor.waitForTasksWithQuickFail(true);
            logger.verbose("Done with all dex archive conversions", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransformException((Throwable)e);
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
        finally {
            if (processOutput != null) {
                try {
                    outputHandler.handleOutput(processOutput);
                }
                catch (ProcessException processException) {}
            }
        }
    }

    private void processJarInput(File preDexFile, ProcessOutput processOutput, Set<String> hashes, JarInput jarInput, boolean isIncremental) throws Exception {
        if (!isIncremental) {
            if (jarInput.getFile().exists()) {
                this.convertToDexArchive((QualifiedContent)jarInput, p -> true, p -> false, preDexFile, hashes, processOutput);
            } else {
                this.deleteDexArchive(jarInput.getFile());
            }
        } else if (jarInput.getStatus() == Status.REMOVED) {
            this.deleteDexArchive(preDexFile);
        } else if (jarInput.getStatus() == Status.ADDED || jarInput.getStatus() == Status.CHANGED) {
            this.convertToDexArchive((QualifiedContent)jarInput, p -> true, p -> false, preDexFile, hashes, processOutput);
        }
    }

    private static boolean isExternalLib(QualifiedContent content) {
        return content.getFile().isFile() && content.getScopes().equals(Collections.singleton(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) && content.getContentTypes().equals(Collections.singleton(QualifiedContent.DefaultContentType.CLASSES)) && !content.getName().startsWith("android.local.jars:");
    }

    private void processDirectoryInput(File preDexFile, ProcessOutput processOutput, Set<String> hashes, DirectoryInput directoryInput, boolean isIncremental) throws Exception {
        Path rootFolder = directoryInput.getFile().toPath();
        if (!Files.isDirectory(rootFolder, new LinkOption[0])) {
            this.deleteDexArchive(preDexFile);
        } else if (!isIncremental) {
            this.convertToDexArchive((QualifiedContent)directoryInput, p -> true, p -> false, preDexFile, hashes, processOutput);
        } else {
            Predicate<Path> toRemove = path -> {
                File resolved = rootFolder.resolve((Path)path).toFile();
                return directoryInput.getChangedFiles().get(resolved) == Status.REMOVED;
            };
            Predicate<Path> toProcess = path -> {
                File resolved = rootFolder.resolve((Path)path).toFile();
                Status status = (Status)directoryInput.getChangedFiles().get(resolved);
                return status == Status.ADDED || status == Status.CHANGED;
            };
            this.convertToDexArchive((QualifiedContent)directoryInput, toProcess, toRemove, preDexFile, hashes, processOutput);
        }
    }

    private void convertToDexArchive(QualifiedContent input, Predicate<Path> toProcess, Predicate<Path> toRemove, File preDexFile, Set<String> hashes, ProcessOutput processOutput) throws Exception {
        FileCache userCache = PreDexTransform.getBuildCache(input.getFile(), DexArchiveBuilderTransform.isExternalLib(input), this.userLevelCache);
        FileCache projectCache = input.getFile().isFile() ? this.projectLevelCache : null;
        DexArchiveBuilderTransformCallable converter = new DexArchiveBuilderTransformCallable(input.getFile().toPath(), toProcess, toRemove, preDexFile, hashes, processOutput, userCache, projectCache, this.dexOptions, this.minSdkVersion);
        this.executor.execute((Callable)converter);
    }

    private void deleteDexArchive(File toDelete) throws IOException {
        this.executor.execute(() -> {
            FileUtils.deleteIfExists((File)toDelete);
            return null;
        });
    }

    private File getPreDexFile(TransformOutputProvider output, QualifiedContent qualifiedContent) {
        Format outputFormat = qualifiedContent.getFile().isDirectory() ? Format.DIRECTORY : Format.JAR;
        File contentLocation = output.getContentLocation(qualifiedContent.getName(), (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), qualifiedContent.getScopes(), outputFormat);
        if (outputFormat == Format.DIRECTORY) {
            FileUtils.mkdirs((File)contentLocation);
        } else {
            FileUtils.mkdirs((File)contentLocation.getParentFile());
        }
        return contentLocation;
    }
}

