/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexMergerConfig;
import com.android.builder.dexing.DexingType;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.process.ProcessOutput;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;

class DexMergerTransformCallable
implements Callable<Void> {
    private final DexingType dexingType;
    private final ProcessOutput processOutput;
    private final File dexOutputDir;
    private final Collection<Path> dexArchives;
    private final Set<String> mainDexList;
    private final ForkJoinPool forkJoinPool;

    public DexMergerTransformCallable(DexingType dexingType, ProcessOutput processOutput, File dexOutputDir, Collection<Path> dexArchives, Set<String> mainDexList, ForkJoinPool forkJoinPool) {
        this.dexingType = dexingType;
        this.processOutput = processOutput;
        this.dexOutputDir = dexOutputDir;
        this.dexArchives = dexArchives;
        this.mainDexList = mainDexList;
        this.forkJoinPool = forkJoinPool;
    }

    @Override
    public Void call() throws Exception {
        DxContext dxContext = new DxContext(this.processOutput.getStandardOutput(), this.processOutput.getErrorOutput());
        DexMergerConfig config = new DexMergerConfig(this.dexingType, dxContext);
        DexArchiveMerger merger = new DexArchiveMerger(config, this.forkJoinPool);
        merger.merge(this.dexArchives, this.dexOutputDir.toPath(), this.mainDexList);
        return null;
    }
}

