/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.packaging.PackagingFileAction;
import com.android.build.gradle.internal.packaging.ParsedPackagingOptions;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.IncrementalFileMergerTransformUtils;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.merge.DelegateIncrementalFileMergerOutput;
import com.android.builder.merge.FilterIncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMerger;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerOutput;
import com.android.builder.merge.IncrementalFileMergerOutputs;
import com.android.builder.merge.IncrementalFileMergerState;
import com.android.builder.merge.MergeOutputWriter;
import com.android.builder.merge.MergeOutputWriters;
import com.android.builder.merge.RenameIncrementalFileMergerInput;
import com.android.builder.merge.StreamMergeAlgorithm;
import com.android.builder.merge.StreamMergeAlgorithms;
import com.android.utils.FileUtils;
import com.android.utils.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MergeJavaResourcesTransform
extends Transform {
    private static final Pattern JAR_ABI_PATTERN = Pattern.compile("lib/([^/]+)/[^/]+");
    private static final Pattern ABI_FILENAME_PATTERN = Pattern.compile(".*\\.so");
    private final ParsedPackagingOptions packagingOptions;
    private final String name;
    private final Set<? super QualifiedContent.Scope> mergeScopes;
    private final Set<QualifiedContent.ContentType> mergedType;
    private final File intermediateDir;
    private final FileCacheByPath zipCache;
    private final Predicate<String> acceptedPathsPredicate;

    public MergeJavaResourcesTransform(PackagingOptions packagingOptions, Set<? super QualifiedContent.Scope> mergeScopes, QualifiedContent.ContentType mergedType, String name, VariantScope variantScope) {
        this.packagingOptions = new ParsedPackagingOptions(packagingOptions);
        this.name = name;
        this.mergeScopes = ImmutableSet.copyOf(mergeScopes);
        this.mergedType = ImmutableSet.of((Object)mergedType);
        this.intermediateDir = variantScope.getIncrementalDir(variantScope.getFullVariantName() + "-" + name);
        File cacheDir = new File(this.intermediateDir, "zip-cache");
        FileUtils.mkdirs((File)cacheDir);
        this.zipCache = new FileCacheByPath(cacheDir);
        if (mergedType == QualifiedContent.DefaultContentType.RESOURCES) {
            this.acceptedPathsPredicate = path -> !path.endsWith(".class") && !path.endsWith(".so");
        } else if (mergedType == ExtendedContentType.NATIVE_LIBS) {
            this.acceptedPathsPredicate = path -> {
                Matcher m = JAR_ABI_PATTERN.matcher((CharSequence)path);
                if (m.matches()) {
                    String filename = path.substring(5 + m.group(1).length());
                    return ABI_FILENAME_PATTERN.matcher(filename).matches() || "gdbserver".equals(filename) || "gdb.setup".equals(filename);
                }
                return false;
            };
        } else {
            throw new UnsupportedOperationException("mergedType param must be RESOURCES or NATIVE_LIBS");
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.mergedType;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return this.mergeScopes;
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of((Object)"exclude", this.packagingOptions.getExcludePatterns(), (Object)"pickFirst", this.packagingOptions.getPickFirstPatterns(), (Object)"merge", this.packagingOptions.getMergePatterns());
    }

    public boolean isIncremental() {
        return true;
    }

    private File incrementalStateFile() {
        return new File(this.intermediateDir, "merge-state");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IncrementalFileMergerState loadMergeState() throws IOException {
        File incrementalFile = this.incrementalStateFile();
        if (!incrementalFile.isFile()) {
            return null;
        }
        try (ObjectInputStream i = new ObjectInputStream(new FileInputStream(incrementalFile));){
            IncrementalFileMergerState incrementalFileMergerState = (IncrementalFileMergerState)i.readObject();
            return incrementalFileMergerState;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private void saveMergeState(IncrementalFileMergerState state) throws IOException {
        File incrementalFile = this.incrementalStateFile();
        FileUtils.mkdirs((File)incrementalFile.getParentFile());
        try (ObjectOutputStream o = new ObjectOutputStream(new FileOutputStream(incrementalFile));){
            o.writeObject(state);
        }
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException {
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        boolean full = false;
        IncrementalFileMergerState state = this.loadMergeState();
        if (state == null || !invocation.isIncremental()) {
            state = new IncrementalFileMergerState();
            outputProvider.deleteAll();
            full = true;
        }
        ArrayList<Runnable> cacheUpdates = new ArrayList<Runnable>();
        HashMap<IncrementalFileMergerInput, QualifiedContent> contentMap = new HashMap<IncrementalFileMergerInput, QualifiedContent>();
        List<Object> inputs = new ArrayList<IncrementalFileMergerInput>((Collection<IncrementalFileMergerInput>)IncrementalFileMergerTransformUtils.toInput(invocation, this.zipCache, cacheUpdates, full, contentMap));
        inputs.sort((i0, i1) -> {
            int v0 = ((QualifiedContent)contentMap.get(i0)).getScopes().contains(QualifiedContent.Scope.PROJECT) ? 0 : 1;
            int v1 = ((QualifiedContent)contentMap.get(i1)).getScopes().contains(QualifiedContent.Scope.PROJECT) ? 0 : 1;
            return v0 - v1;
        });
        assert (this.mergedType.size() == 1);
        if (this.mergedType.iterator().next() == ExtendedContentType.NATIVE_LIBS) {
            inputs = inputs.stream().map(i -> {
                QualifiedContent qc = (QualifiedContent)contentMap.get(i);
                if (!qc.getScopes().contains(QualifiedContent.Scope.SUB_PROJECTS) && qc.getFile().isDirectory()) {
                    i = new RenameIncrementalFileMergerInput(i, s -> "lib/" + s, s -> s.substring("lib/".length()));
                    contentMap.put((IncrementalFileMergerInput)i, qc);
                }
                return i;
            }).collect(Collectors.toList());
        }
        Predicate<String> inputFilter = this.acceptedPathsPredicate.and(path -> this.packagingOptions.getAction((String)path) != PackagingFileAction.EXCLUDE);
        inputs = inputs.stream().map(i -> {
            FilterIncrementalFileMergerInput i2 = new FilterIncrementalFileMergerInput(i, inputFilter);
            contentMap.put((IncrementalFileMergerInput)i2, (QualifiedContent)contentMap.get(i));
            return i2;
        }).collect(Collectors.toList());
        File outputDir = outputProvider.getContentLocation("resources", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
        StreamMergeAlgorithm mergeTransformAlgorithm = StreamMergeAlgorithms.select(path -> {
            PackagingFileAction packagingAction = this.packagingOptions.getAction((String)path);
            switch (packagingAction) {
                case EXCLUDE: {
                    throw new AssertionError();
                }
                case PICK_FIRST: {
                    return StreamMergeAlgorithms.pickFirst();
                }
                case MERGE: {
                    return StreamMergeAlgorithms.concat();
                }
                case NONE: {
                    return StreamMergeAlgorithms.acceptOnlyOne();
                }
            }
            throw new AssertionError();
        });
        IncrementalFileMergerOutput baseOutput = IncrementalFileMergerOutputs.fromAlgorithmAndWriter((StreamMergeAlgorithm)mergeTransformAlgorithm, (MergeOutputWriter)MergeOutputWriters.toDirectory((File)outputDir));
        final Set projectInputs = contentMap.keySet().stream().filter(i -> ((QualifiedContent)contentMap.get(i)).getScopes().contains(QualifiedContent.Scope.PROJECT)).collect(Collectors.toSet());
        DelegateIncrementalFileMergerOutput output = new DelegateIncrementalFileMergerOutput(baseOutput){

            public void create(String path, List<IncrementalFileMergerInput> inputs) {
                super.create(path, this.filter(path, inputs));
            }

            public void update(String path, List<String> prevInputNames, List<IncrementalFileMergerInput> inputs) {
                super.update(path, prevInputNames, this.filter(path, inputs));
            }

            public void remove(String path) {
                super.remove(path);
            }

            private ImmutableList<IncrementalFileMergerInput> filter(String path, List<IncrementalFileMergerInput> inputs) {
                PackagingFileAction packagingAction = MergeJavaResourcesTransform.this.packagingOptions.getAction(path);
                if (packagingAction == PackagingFileAction.NONE) {
                    if (inputs.stream().anyMatch(projectInputs::contains)) {
                        inputs = (List)inputs.stream().filter(projectInputs::contains).collect(ImmutableCollectors.toImmutableList());
                    }
                }
                return ImmutableList.copyOf(inputs);
            }
        };
        state = IncrementalFileMerger.merge((List)ImmutableList.copyOf(inputs), (IncrementalFileMergerOutput)output, (IncrementalFileMergerState)state);
        this.saveMergeState(state);
        cacheUpdates.forEach(Runnable::run);
    }
}

