/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.core.VariantType;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;

public abstract class ProguardConfigurable
extends Transform {
    private final ConfigurableFileCollection configurationFiles;
    private final VariantType variantType;

    ProguardConfigurable(VariantScope scope) {
        this.configurationFiles = scope.getGlobalScope().getProject().files(new Object[0]);
        this.variantType = scope.getVariantData().getType();
    }

    public void setConfigurationFiles(FileCollection configFiles) {
        this.configurationFiles.from(new Object[]{configFiles});
    }

    FileCollection getAllConfigurationFiles() {
        return this.configurationFiles;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        if (this.variantType == VariantType.LIBRARY) {
            return TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS;
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)5);
        if (this.variantType == VariantType.LIBRARY) {
            set.add(QualifiedContent.Scope.SUB_PROJECTS);
            set.add(QualifiedContent.Scope.EXTERNAL_LIBRARIES);
        }
        if (this.variantType.isForTesting()) {
            set.add(QualifiedContent.Scope.TESTED_CODE);
        }
        set.add(QualifiedContent.Scope.PROVIDED_ONLY);
        return Sets.immutableEnumSet((Iterable)set);
    }

    public abstract void keep(String var1);

    public abstract void dontwarn(String var1);
}

