/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.Option;
import com.android.builder.model.AaptOptions;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;

public final class EnumOptions {
    private final AaptOptions.Namespacing namespacing;

    EnumOptions(AaptOptions.Namespacing namespacing) {
        this.namespacing = namespacing;
    }

    public AaptOptions.Namespacing getNamespacing() {
        return this.namespacing;
    }

    private static <T extends Enum<T>> T get(ImmutableMap<EnumOption, String> options, EnumOption option, Class<T> enumClass) {
        String optionValue = (String)options.get((Object)option);
        if (optionValue == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, optionValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Project property " + option.getPropertyName() + " is set to invalid value '" + optionValue + "'. Possible values are: " + Joiner.on((String)", ").join((Object[])enumClass.getEnumConstants()) + ".");
        }
    }

    static EnumOptions load(ImmutableMap<EnumOption, String> options) {
        AaptOptions.Namespacing namespacing = (AaptOptions.Namespacing)MoreObjects.firstNonNull((Object)EnumOptions.get(options, EnumOption.AAPT_OPTIONS_NAMESPACING, AaptOptions.Namespacing.class), (Object)AaptOptions.Namespacing.DISABLED);
        return new EnumOptions(namespacing);
    }

    static enum EnumOption implements Option<String>
    {
        AAPT_OPTIONS_NAMESPACING("android.aaptNamespacing");

        private final String propertyName;

        private EnumOption(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public String getDefaultValue() {
            return null;
        }

        @Override
        public String parse(Object value) {
            if (value instanceof CharSequence || value instanceof Number) {
                return value.toString();
            }
            throw new IllegalArgumentException("Cannot parse project property " + this.getPropertyName() + "='" + value + "' of type '" + value.getClass() + "' as string to be interpreted as an enum constant.");
        }
    }
}

