/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.KeepRules;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.build.gradle.shrinker.TypeHierarchyTraverser;
import com.android.build.gradle.shrinker.parser.AnnotationSpecification;
import com.android.build.gradle.shrinker.parser.ClassSpecification;
import com.android.build.gradle.shrinker.parser.FieldSpecification;
import com.android.build.gradle.shrinker.parser.Flags;
import com.android.build.gradle.shrinker.parser.InheritanceSpecification;
import com.android.build.gradle.shrinker.parser.Matcher;
import com.android.build.gradle.shrinker.parser.MethodSpecification;
import com.android.build.gradle.shrinker.parser.ModifierSpecification;
import com.android.build.gradle.shrinker.parser.NameSpecification;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProguardParserKeepRules
implements KeepRules {
    private final List<ClassSpecification> keepClassSpecs;
    private final List<ClassSpecification> keepClassMembersSpecs;
    private final List<ClassSpecification> keepClassesWithMembersSpecs;
    private final ShrinkerLogger shrinkerLogger;

    private ProguardParserKeepRules(List<ClassSpecification> keepClassSpecs, List<ClassSpecification> keepClassMembersSpecs, List<ClassSpecification> keepClassesWithMembersSpecs, ShrinkerLogger shrinkerLogger) {
        this.keepClassSpecs = keepClassSpecs;
        this.keepClassMembersSpecs = keepClassMembersSpecs;
        this.keepClassesWithMembersSpecs = keepClassesWithMembersSpecs;
        this.shrinkerLogger = shrinkerLogger;
    }

    public static ProguardParserKeepRules keepRules(Flags flags, ShrinkerLogger shrinkerLogger) {
        return new ProguardParserKeepRules(flags.getKeepClassSpecs(), flags.getKeepClassMembersSpecs(), flags.getKeepClassesWithMembersSpecs(), shrinkerLogger);
    }

    public static ProguardParserKeepRules whyAreYouKeepingRules(Flags flags, ShrinkerLogger shrinkerLogger) {
        if (flags.getWhyAreYouKeepingSpecs().isEmpty()) {
            return null;
        }
        return new ProguardParserKeepRules(flags.getWhyAreYouKeepingSpecs(), Collections.emptyList(), Collections.emptyList(), shrinkerLogger);
    }

    @Override
    public <T> Map<T, DependencyType> getSymbolsToKeep(T klass, ShrinkerGraph<T> graph) {
        HashMap result = Maps.newHashMap();
        for (ClassSpecification spec : this.keepClassSpecs) {
            if (!this.matchesClass(klass, spec, graph)) continue;
            result.put(klass, DependencyType.REQUIRED_KEEP_RULES);
            result.put(graph.getMemberReference(graph.getClassName(klass), "<init>", "()V"), DependencyType.REQUIRED_CLASS_STRUCTURE);
            for (T member : ProguardParserKeepRules.findMatchingMembers(klass, spec, graph)) {
                result.put(member, DependencyType.REQUIRED_KEEP_RULES);
            }
        }
        for (ClassSpecification spec : this.keepClassMembersSpecs) {
            if (!this.matchesClass(klass, spec, graph)) continue;
            for (T member : ProguardParserKeepRules.findMatchingMembers(klass, spec, graph)) {
                result.put(member, DependencyType.IF_CLASS_KEPT);
                graph.addDependency(klass, member, DependencyType.CLASS_IS_KEPT);
            }
        }
        for (ClassSpecification spec : this.keepClassesWithMembersSpecs) {
            if (!this.matchesClass(klass, spec, graph)) continue;
            for (T t : ProguardParserKeepRules.handleKeepClassesWithMembers(spec, klass, graph)) {
                result.put(t, DependencyType.REQUIRED_KEEP_RULES);
            }
        }
        return result;
    }

    private static <T> List<T> handleKeepClassesWithMembers(ClassSpecification classSpec, T klass, ShrinkerGraph<T> graph) {
        boolean found;
        ArrayList result = Lists.newArrayList();
        for (MethodSpecification methodSpec : classSpec.getMethodSpecifications()) {
            found = false;
            for (T method : graph.getMethods(klass)) {
                if (!ProguardParserKeepRules.matchesMethod(method, methodSpec, graph)) continue;
                found = true;
                result.add(method);
            }
            if (found) continue;
            return Collections.emptyList();
        }
        for (FieldSpecification fieldSpec : classSpec.getFieldSpecifications()) {
            found = false;
            for (T field : graph.getFields(klass)) {
                if (!ProguardParserKeepRules.matchesField(field, fieldSpec, graph)) continue;
                found = true;
                result.add(field);
            }
            if (found) continue;
            return Collections.emptyList();
        }
        result.add(klass);
        return result;
    }

    private static <T> List<T> findMatchingMembers(T klass, ClassSpecification spec, ShrinkerGraph<T> graph) {
        ArrayList result = Lists.newArrayList();
        for (T method : graph.getMethods(klass)) {
            for (MethodSpecification methodSpec : spec.getMethodSpecifications()) {
                if (!ProguardParserKeepRules.matchesMethod(method, methodSpec, graph)) continue;
                result.add(method);
            }
        }
        for (T field : graph.getFields(klass)) {
            for (FieldSpecification fieldSpecification : spec.getFieldSpecifications()) {
                if (!ProguardParserKeepRules.matchesField(field, fieldSpecification, graph)) continue;
                result.add(field);
            }
        }
        return result;
    }

    private static <T> boolean matchesField(T field, FieldSpecification spec, ShrinkerGraph<T> graph) {
        return ProguardParserKeepRules.matches(spec.getName(), graph.getMemberName(field)) && ProguardParserKeepRules.matches(spec.getModifier(), graph.getModifiers(field), ModifierSpecification.ModifierTarget.FIELD) && ProguardParserKeepRules.matches(spec.getTypeSignature(), graph.getMemberDescriptor(field)) && ProguardParserKeepRules.matchesAnnotations(field, spec.getAnnotations(), graph);
    }

    private static <T> boolean matchesMethod(T method, MethodSpecification spec, ShrinkerGraph<T> graph) {
        String nameAndDescriptor = graph.getMemberName(method) + ":" + graph.getMemberDescriptor(method);
        return ProguardParserKeepRules.matches(spec.getName(), nameAndDescriptor) && ProguardParserKeepRules.matches(spec.getModifiers(), graph.getModifiers(method), ModifierSpecification.ModifierTarget.METHOD) && ProguardParserKeepRules.matchesAnnotations(method, spec.getAnnotations(), graph);
    }

    private <T> boolean matchesClass(T klass, ClassSpecification spec, ShrinkerGraph<T> graph) {
        int classModifiers = graph.getModifiers(klass);
        return ProguardParserKeepRules.matchesClassName(spec.getNames(), graph.getClassName(klass)) && ProguardParserKeepRules.matches(spec.getClassType(), classModifiers) && ProguardParserKeepRules.matches(spec.getModifier(), classModifiers, ModifierSpecification.ModifierTarget.CLASS) && ProguardParserKeepRules.matchesAnnotations(klass, spec.getAnnotation(), graph) && this.matchesInheritance(klass, spec.getInheritance(), graph);
    }

    private static boolean matchesClassName(List<NameSpecification> specs, String className) {
        return specs.stream().anyMatch(s -> s.matches(className));
    }

    private static boolean matches(ModifierSpecification spec, int modifiers, ModifierSpecification.ModifierTarget target) {
        return spec == null || spec.matches(new ModifierSpecification.MemberModifier(target, modifiers));
    }

    private static <U> boolean matches(Matcher<U> matcher, U value) {
        return matcher == null || matcher.matches(value);
    }

    private static <T> boolean matchesAnnotations(T classOrMember, AnnotationSpecification annotation, ShrinkerGraph<T> graph) {
        if (annotation == null) {
            return true;
        }
        for (String annotationName : graph.getAnnotations(classOrMember)) {
            if (!annotation.getName().matches(annotationName)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean matchesInheritance(T klass, InheritanceSpecification spec, ShrinkerGraph<T> graph) {
        if (spec == null) {
            return true;
        }
        FluentIterable superTypes = TypeHierarchyTraverser.superclassesAndInterfaces(graph, this.shrinkerLogger).preOrderTraversal(klass).skip(1);
        for (Object superType : superTypes) {
            String name = graph.getClassName(superType);
            if (!spec.getNameSpec().matches(name)) continue;
            return true;
        }
        return false;
    }
}

