/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.compiling.BuildConfigGenerator;
import com.android.builder.model.ClassField;
import com.android.utils.FileUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
@CacheableTask
public class GenerateBuildConfig
extends BaseTask {
    private File sourceOutputDir;
    private Supplier<String> buildConfigPackageName;
    private Supplier<String> appPackageName;
    private Supplier<Boolean> debuggable;
    private Supplier<String> flavorName;
    private Supplier<List<String>> flavorNamesWithDimensionNames;
    private String buildTypeName;
    private Supplier<String> versionName;
    private Supplier<Integer> versionCode;
    private Supplier<List<Object>> items;

    @OutputDirectory
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @Input
    public String getBuildConfigPackageName() {
        return this.buildConfigPackageName.get();
    }

    @Input
    public String getAppPackageName() {
        return this.appPackageName.get();
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable.get();
    }

    @Input
    public String getFlavorName() {
        return this.flavorName.get();
    }

    @Input
    public List<String> getFlavorNamesWithDimensionNames() {
        return this.flavorNamesWithDimensionNames.get();
    }

    @Input
    public String getBuildTypeName() {
        return this.buildTypeName;
    }

    public void setBuildTypeName(String buildTypeName) {
        this.buildTypeName = buildTypeName;
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName.get();
    }

    @Input
    public int getVersionCode() {
        return this.versionCode.get();
    }

    @Internal
    public List<Object> getItems() {
        return this.items.get();
    }

    @Input
    public List<String> getItemValues() {
        List<Object> resolvedItems = this.getItems();
        ArrayList list = Lists.newArrayListWithCapacity((int)(resolvedItems.size() * 3));
        for (Object object : resolvedItems) {
            if (object instanceof String) {
                list.add((String)object);
                continue;
            }
            if (!(object instanceof ClassField)) continue;
            ClassField field = (ClassField)object;
            list.add(field.getType());
            list.add(field.getName());
            list.add(field.getValue());
        }
        return list;
    }

    @TaskAction
    void generate() throws IOException {
        File destinationDir = this.getSourceOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        BuildConfigGenerator generator = new BuildConfigGenerator(this.getSourceOutputDir(), this.getBuildConfigPackageName());
        generator.addField("boolean", "DEBUG", this.isDebuggable() ? "Boolean.parseBoolean(\"true\")" : "false").addField("String", "APPLICATION_ID", '\"' + this.appPackageName.get() + '\"').addField("String", "BUILD_TYPE", '\"' + this.getBuildTypeName() + '\"').addField("String", "FLAVOR", '\"' + this.getFlavorName() + '\"').addField("int", "VERSION_CODE", Integer.toString(this.getVersionCode())).addField("String", "VERSION_NAME", '\"' + Strings.nullToEmpty((String)this.getVersionName()) + '\"').addItems(this.getItems());
        List<String> flavors = this.getFlavorNamesWithDimensionNames();
        int count = flavors.size();
        if (count > 1) {
            for (int i = 0; i < count; i += 2) {
                generator.addField("String", "FLAVOR_" + flavors.get(i + 1), '\"' + flavors.get(i) + '\"');
            }
        }
        generator.generate();
    }

    public static final class ConfigAction
    implements TaskConfigAction<GenerateBuildConfig> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "BuildConfig");
        }

        @Override
        public Class<GenerateBuildConfig> getType() {
            return GenerateBuildConfig.class;
        }

        @Override
        public void execute(GenerateBuildConfig generateBuildConfigTask) {
            BaseVariantData variantData = this.scope.getVariantData();
            variantData.generateBuildConfigTask = generateBuildConfigTask;
            GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
            generateBuildConfigTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            generateBuildConfigTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            generateBuildConfigTask.buildConfigPackageName = TaskInputHelper.memoize(() -> ((GradleVariantConfiguration)variantConfiguration).getOriginalApplicationId());
            generateBuildConfigTask.appPackageName = TaskInputHelper.memoize(() -> ((GradleVariantConfiguration)variantConfiguration).getApplicationId());
            generateBuildConfigTask.versionName = TaskInputHelper.memoize(variantConfiguration::getVersionName);
            generateBuildConfigTask.versionCode = TaskInputHelper.memoize(variantConfiguration::getVersionCode);
            generateBuildConfigTask.debuggable = TaskInputHelper.memoize(() -> ((CoreBuildType)variantConfiguration.getBuildType()).isDebuggable());
            generateBuildConfigTask.buildTypeName = ((CoreBuildType)variantConfiguration.getBuildType()).getName();
            generateBuildConfigTask.flavorName = () -> ((GradleVariantConfiguration)variantConfiguration).getFlavorName();
            generateBuildConfigTask.flavorNamesWithDimensionNames = TaskInputHelper.memoize(() -> ((GradleVariantConfiguration)variantConfiguration).getFlavorNamesWithDimensionNames());
            generateBuildConfigTask.items = TaskInputHelper.memoize(() -> ((GradleVariantConfiguration)variantConfiguration).getBuildConfigItems());
            generateBuildConfigTask.setSourceOutputDir(this.scope.getBuildConfigSourceOutputDir());
        }
    }
}

