/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import android.databinding.tool.store.LayoutFileParser;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.ResourceException;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.GeneratedResourceSet;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedResourceWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NoOpResourcePreprocessor;
import com.android.ide.common.res2.QueueableResourceCompiler;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.res2.ResourceSet;
import com.android.ide.common.res2.SingleFileProcessor;
import com.android.ide.common.vectordrawable.ResourcesNotSupportedException;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
@ParallelizableTask
public class MergeResources
extends IncrementalTask {
    private File outputDir;
    private File generatedPngsOutputDir;
    private File publicFile;
    private boolean processResources;
    private boolean crunchPng;
    private boolean validateEnabled;
    private File blameLogFolder;
    private Supplier<List<ResourceSet>> sourceFolderInputs;
    private List<ResourceSet> processedInputs;
    private ArtifactCollection libraries;
    private FileCollection renderscriptResOutputDir;
    private FileCollection generatedResOutputDir;
    private FileCollection microApkResDirectory;
    private FileCollection extraGeneratedResFolders;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();
    private boolean disableVectorDrawables;
    private Collection<String> generatedDensities;
    private int minSdk;
    private VariantScope variantScope;
    private AaptGeneration aaptGeneration;
    private SingleFileProcessor dataBindingExpressionRemover;
    private File dataBindingLayoutOutputFolder;
    private File resourceShrinkerOutputFolder;
    private boolean pseudoLocalesEnabled;

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            for (ResourceSet resourceSet : resourceSets) {
                resourceSet.loadFromFiles(this.getILogger());
                merger.addDataSet(resourceSet);
            }
            Object resourceCompiler = this.processResources ? AaptGradleFactory.make(this.aaptGeneration, this.getBuilder(), this.crunchPng, this.variantScope, this.getAaptTempDir()) : QueueableResourceCompiler.NONE;
            MergedResourceWriter writer = new MergedResourceWriter(destinationDir, this.getPublicFile(), this.getBlameLogFolder(), preprocessor, resourceCompiler, this.getIncrementalFolder(), this.dataBindingExpressionRemover, this.dataBindingLayoutOutputFolder, this.resourceShrinkerOutputFolder, this.pseudoLocalesEnabled, this.getCrunchPng());
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            System.out.println(e.getMessage());
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            for (Object resourceSet : merger.getDataSets()) {
                resourceSet.setPreprocessor(preprocessor);
            }
            List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry entry : changedInputs.entrySet()) {
                File changedFile = (File)entry.getKey();
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, (FileStatus)entry.getValue(), this.getILogger())) continue;
                this.getLogger().info(String.format("Failed to process %s event! Full task run", entry.getValue()));
                this.doFullTaskAction();
                return;
            }
            Object resourceCompiler = this.processResources ? AaptGradleFactory.make(this.aaptGeneration, this.getBuilder(), this.crunchPng, this.variantScope, this.getAaptTempDir()) : QueueableResourceCompiler.NONE;
            MergedResourceWriter mergedResourceWriter = new MergedResourceWriter(this.getOutputDir(), this.getPublicFile(), this.getBlameLogFolder(), preprocessor, resourceCompiler, this.getIncrementalFolder(), this.dataBindingExpressionRemover, this.dataBindingLayoutOutputFolder, this.resourceShrinkerOutputFolder, this.pseudoLocalesEnabled, this.getCrunchPng());
            merger.mergeData((MergeConsumer)mergedResourceWriter, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)mergedResourceWriter, false);
        }
        catch (MergingException e) {
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.fileValidity.clear();
        }
    }

    private ResourcePreprocessor getPreprocessor() {
        if (this.isDisableVectorDrawables()) {
            return NoOpResourcePreprocessor.INSTANCE;
        }
        Collection densities = this.getGeneratedDensities().stream().map(Density::getEnum).collect(Collectors.toList());
        return new VectorDrawableRenderer(this.getMinSdk(), this.getGeneratedPngsOutputDir(), densities, this.getILogger()){

            public void generateFile(File toBeGenerated, File original) throws IOException {
                try {
                    super.generateFile(toBeGenerated, original);
                }
                catch (ResourcesNotSupportedException e) {
                    throw new GradleException(String.format("Can't process attribute %1$s=\"%2$s\": references to other resources are not supported by build-time PNG generation. See http://developer.android.com/tools/help/vector-asset-studio.html for details.", e.getName(), e.getValue()));
                }
            }
        };
    }

    private List<ResourceSet> getConfiguredResourceSets(ResourcePreprocessor preprocessor) {
        if (this.processedInputs == null) {
            this.processedInputs = this.computeResourceSetList();
            ArrayList generatedSets = Lists.newArrayListWithCapacity((int)this.processedInputs.size());
            for (ResourceSet resourceSet : this.processedInputs) {
                resourceSet.setPreprocessor(preprocessor);
                GeneratedResourceSet generatedSet = new GeneratedResourceSet(resourceSet);
                resourceSet.setGeneratedSet((ResourceSet)generatedSet);
                generatedSets.add(generatedSet);
            }
            this.processedInputs.addAll(0, generatedSets);
        }
        return this.processedInputs;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getRenderscriptResOutputDir() {
        return this.renderscriptResOutputDir;
    }

    @VisibleForTesting
    void setRenderscriptResOutputDir(FileCollection renderscriptResOutputDir) {
        this.renderscriptResOutputDir = renderscriptResOutputDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getGeneratedResOutputDir() {
        return this.generatedResOutputDir;
    }

    @VisibleForTesting
    void setGeneratedResOutputDir(FileCollection generatedResOutputDir) {
        this.generatedResOutputDir = generatedResOutputDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getMicroApkResDirectory() {
        return this.microApkResDirectory;
    }

    @VisibleForTesting
    void setMicroApkResDirectory(FileCollection microApkResDirectory) {
        this.microApkResDirectory = microApkResDirectory;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getExtraGeneratedResFolders() {
        return this.extraGeneratedResFolders;
    }

    @VisibleForTesting
    void setExtraGeneratedResFolders(FileCollection extraGeneratedResFolders) {
        this.extraGeneratedResFolders = extraGeneratedResFolders;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getLibraries() {
        if (this.libraries != null) {
            return this.libraries.getArtifactFiles();
        }
        return null;
    }

    @VisibleForTesting
    void setLibraries(ArtifactCollection libraries) {
        this.libraries = libraries;
    }

    @VisibleForTesting
    void setSourceFolderInputs(Supplier<List<ResourceSet>> sourceFolderInputs) {
        this.sourceFolderInputs = sourceFolderInputs;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Set<File> getSourceFolderInputs() {
        List<ResourceSet> inputs = this.sourceFolderInputs.get();
        HashSet files = Sets.newHashSetWithExpectedSize((int)inputs.size());
        for (ResourceSet resourceSet : inputs) {
            files.addAll(resourceSet.getSourceFiles());
        }
        return files;
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    @Input
    public boolean getProcessResources() {
        return this.processResources;
    }

    @Optional
    @OutputFile
    public File getPublicFile() {
        return this.publicFile;
    }

    public void setPublicFile(File publicFile) {
        this.publicFile = publicFile;
    }

    @Input
    public boolean isValidateEnabled() {
        return this.validateEnabled;
    }

    public void setValidateEnabled(boolean validateEnabled) {
        this.validateEnabled = validateEnabled;
    }

    @OutputDirectory
    @Optional
    public File getBlameLogFolder() {
        return this.blameLogFolder;
    }

    public void setBlameLogFolder(File blameLogFolder) {
        this.blameLogFolder = blameLogFolder;
    }

    @OutputDirectory
    public File getGeneratedPngsOutputDir() {
        return this.generatedPngsOutputDir;
    }

    public void setGeneratedPngsOutputDir(File generatedPngsOutputDir) {
        this.generatedPngsOutputDir = generatedPngsOutputDir;
    }

    @Input
    public Collection<String> getGeneratedDensities() {
        return this.generatedDensities;
    }

    @Input
    public int getMinSdk() {
        return this.minSdk;
    }

    public void setMinSdk(int minSdk) {
        this.minSdk = minSdk;
    }

    public void setGeneratedDensities(Collection<String> generatedDensities) {
        this.generatedDensities = generatedDensities;
    }

    @Input
    public boolean isDisableVectorDrawables() {
        return this.disableVectorDrawables;
    }

    public void setDisableVectorDrawables(boolean disableVectorDrawables) {
        this.disableVectorDrawables = disableVectorDrawables;
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @OutputDirectory
    @Optional
    public File getDataBindingLayoutOutputFolder() {
        return this.dataBindingLayoutOutputFolder;
    }

    @OutputDirectory
    @Optional
    public File getResourceShrinkerOutputFolder() {
        return this.resourceShrinkerOutputFolder;
    }

    @Input
    public boolean isPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    @VisibleForTesting
    List<ResourceSet> computeResourceSetList() {
        List<ResourceSet> sourceFolderSets = this.sourceFolderInputs.get();
        int size = sourceFolderSets.size() + 4;
        if (this.libraries != null) {
            size += this.libraries.getArtifacts().size();
        }
        ArrayList resourceSetList = Lists.newArrayListWithExpectedSize((int)size);
        if (this.libraries != null) {
            Set libArtifacts = this.libraries.getArtifacts();
            for (ResolvedArtifactResult artifact : libArtifacts) {
                ResourceSet resourceSet = new ResourceSet(MergeManifests.getArtifactName(artifact), null, null, this.validateEnabled);
                resourceSet.setFromDependency(true);
                resourceSet.addSource(artifact.getFile());
                resourceSetList.add(0, resourceSet);
            }
        }
        resourceSetList.addAll(sourceFolderSets);
        ArrayList generatedResFolders = Lists.newArrayList();
        generatedResFolders.addAll(this.renderscriptResOutputDir.getFiles());
        generatedResFolders.addAll(this.generatedResOutputDir.getFiles());
        FileCollection extraFolders = this.getExtraGeneratedResFolders();
        if (extraFolders != null) {
            generatedResFolders.addAll(extraFolders.getFiles());
        }
        if (this.microApkResDirectory != null) {
            generatedResFolders.addAll(this.microApkResDirectory.getFiles());
        }
        ResourceSet mainResourceSet = sourceFolderSets.get(0);
        assert (mainResourceSet.getConfigName().equals("main"));
        mainResourceSet.addSources((Collection)generatedResFolders);
        return resourceSetList;
    }

    private File getAaptTempDir() {
        return FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp"));
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeResources> {
        private final VariantScope scope;
        private final String taskNamePrefix;
        private final File outputLocation;
        private final boolean includeDependencies;
        private final boolean processResources;

        public ConfigAction(VariantScope scope, String taskNamePrefix, File outputLocation, boolean includeDependencies, boolean processResources) {
            this.scope = scope;
            this.taskNamePrefix = taskNamePrefix;
            this.outputLocation = outputLocation;
            this.includeDependencies = includeDependencies;
            this.processResources = processResources;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(this.taskNamePrefix, "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        @Override
        public void execute(MergeResources mergeResourcesTask) {
            BaseVariantData variantData = this.scope.getVariantData();
            AndroidConfig extension = this.scope.getGlobalScope().getExtension();
            Project project = this.scope.getGlobalScope().getProject();
            mergeResourcesTask.setMinSdk(variantData.getVariantConfiguration().getMinSdkVersion().getApiLevel());
            mergeResourcesTask.aaptGeneration = AaptGeneration.fromProjectOptions(this.scope.getGlobalScope().getProjectOptions());
            mergeResourcesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeResourcesTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            mergeResourcesTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
            mergeResourcesTask.variantScope = this.scope;
            if (this.includeDependencies) {
                mergeResourcesTask.setBlameLogFolder(this.scope.getResourceBlameLogDir());
            }
            mergeResourcesTask.processResources = this.processResources;
            mergeResourcesTask.crunchPng = extension.getAaptOptions().getCruncherEnabled();
            VectorDrawablesOptions vectorDrawablesOptions = variantData.getVariantConfiguration().getMergedFlavor().getVectorDrawables();
            Set generatedDensities = vectorDrawablesOptions.getGeneratedDensities();
            mergeResourcesTask.setGeneratedDensities((Collection)Objects.firstNonNull((Object)generatedDensities, Collections.emptySet()));
            mergeResourcesTask.setDisableVectorDrawables(vectorDrawablesOptions.getUseSupportLibrary() != false || mergeResourcesTask.getGeneratedDensities().isEmpty());
            boolean validateEnabled = !this.scope.getGlobalScope().getProjectOptions().get(BooleanOption.DISABLE_RESOURCE_VALIDATION);
            mergeResourcesTask.setValidateEnabled(validateEnabled);
            if (this.includeDependencies) {
                mergeResourcesTask.libraries = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_RES);
            }
            mergeResourcesTask.sourceFolderInputs = TaskInputHelper.memoize(() -> variantData.getVariantConfiguration().getResourceSets(validateEnabled));
            mergeResourcesTask.extraGeneratedResFolders = variantData.getExtraGeneratedResFolders();
            mergeResourcesTask.renderscriptResOutputDir = (FileCollection)project.files(new Object[]{this.scope.getRenderscriptResOutputDir()});
            mergeResourcesTask.generatedResOutputDir = (FileCollection)project.files(new Object[]{this.scope.getGeneratedResOutputDir()});
            if (this.scope.getMicroApkTask() != null && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
                mergeResourcesTask.microApkResDirectory = (FileCollection)project.files(new Object[]{this.scope.getMicroApkResDirectory()});
            }
            mergeResourcesTask.setOutputDir(this.outputLocation);
            mergeResourcesTask.setGeneratedPngsOutputDir(this.scope.getGeneratedPngsOutputDir());
            variantData.mergeResourcesTask = mergeResourcesTask;
            if (this.scope.getGlobalScope().getExtension().getDataBinding().isEnabled()) {
                mergeResourcesTask.dataBindingExpressionRemover = (file, out) -> LayoutFileParser.stripSingleLayoutFile((File)file, (File)out);
                mergeResourcesTask.dataBindingLayoutOutputFolder = this.scope.getLayoutInputFolderForDataBinding();
            }
            mergeResourcesTask.resourceShrinkerOutputFolder = this.scope.getResourceShrinkerInputFolder();
            mergeResourcesTask.pseudoLocalesEnabled = ((CoreBuildType)this.scope.getVariantData().getVariantConfiguration().getBuildType()).isPseudoLocalesEnabled();
        }
    }
}

