/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.SplitFactory;
import com.android.build.gradle.internal.scope.SplitList;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitPackageIds;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.symbols.IdProvider;
import com.android.builder.symbols.ResourceDirectoryParser;
import com.android.builder.symbols.SymbolTable;
import com.android.builder.symbols.SymbolUtils;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.tooling.BuildException;

@ParallelizableTask
@CacheableTask
public class ProcessAndroidResources
extends IncrementalTask {
    private static final Logger LOG = Logging.getLogger(ProcessAndroidResources.class);
    private String buildTargetAbi;
    private Set<String> supportedAbis;
    private File sourceOutputDir;
    private Supplier<File> textSymbolOutputDir = () -> null;
    private File proguardOutputFile;
    private File mainDexListProguardOutputFile;
    private ArtifactCollection manifests;
    private ArtifactCollection symbolFiles;
    private ArtifactCollection packageIdsFiles;
    private Supplier<String> packageForR;
    private SplitHandlingPolicy splitHandlingPolicy;
    private boolean enforceUniquePackageName;
    private VariantType type;
    private AaptGeneration aaptGeneration;
    private boolean debuggable;
    private boolean pseudoLocalesEnabled;
    private AaptOptions aaptOptions;
    private File mergeBlameLogFolder;
    private InstantRunBuildContext buildContext;
    private FileCollection featureResourcePackages;
    private List<AaptPackageConfig.LibraryInfo> computedLibraryInfo;
    private String originalApplicationId;
    private String buildTargetDensity;
    private File resPackageOutputFolder;
    private String projectBaseName;
    private TaskOutputHolder.TaskOutputType taskInputType;
    private VariantScope variantScope;
    FileCollection splitListInput;
    private SplitScope splitScope;
    private SplitFactory splitFactory;
    private boolean enableNewResourceProcessing;
    private boolean enableAapt2;
    FileCollection manifestFiles;
    private FileCollection inputResourcesDir;

    @Input
    public TaskOutputHolder.TaskOutputType getTaskInputType() {
        return this.taskInputType;
    }

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Input
    @Optional
    public String getBuildTargetAbi() {
        return this.buildTargetAbi;
    }

    @Input
    @Optional
    Set<String> getSupportedAbis() {
        return this.supportedAbis;
    }

    @Internal
    private Set<String> getSplits(SplitList splitList) throws IOException {
        return SplitList.getSplits(splitList, this.splitHandlingPolicy);
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        List splitsToGenerate;
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        if (this.buildTargetAbi != null && this.supportedAbis != null && !this.supportedAbis.isEmpty() && !this.supportedAbis.contains(this.buildTargetAbi)) {
            this.getLogger().debug("Cannot build for " + this.buildTargetAbi + " when supportedAbis are " + Joiner.on((String)",").join(this.supportedAbis));
            return;
        }
        Density density = Density.getEnum((String)this.buildTargetDensity);
        List list = this.buildTargetAbi == null ? this.splitScope.getApkDatas() : (splitsToGenerate = SplitOutputMatcher.computeBestOutput(this.splitScope.getApkDatas(), this.supportedAbis, (int)(density == null ? -1 : density.getDpiValue()), Arrays.asList(Strings.nullToEmpty((String)this.buildTargetAbi).split(","))));
        if (splitsToGenerate.isEmpty()) {
            throw new RuntimeException("Cannot build for ABI '" + this.buildTargetAbi + "', no suitable splits configured : " + Joiner.on((String)", ").join((Iterable)this.splitScope.getApkDatas().stream().map(ApkData::getFilterName).collect(Collectors.toList())));
        }
        for (ApkData apkData : this.splitScope.getApkDatas()) {
            if (splitsToGenerate.contains(apkData)) continue;
            this.getLogger().log(LogLevel.DEBUG, "With ABI " + this.buildTargetAbi + ", disabled " + apkData);
            apkData.disable();
        }
        Collection<BuildOutput> manifestsOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)this.taskInputType, this.manifestFiles);
        this.getLibraryInfoList();
        Set packageIdFileSet = this.packageIdsFiles != null ? this.packageIdsFiles.getArtifactFiles().getAsFileTree().getFiles() : null;
        Set featureResourcePackages = this.featureResourcePackages.getFiles();
        SplitList splitList = SplitList.load(this.splitListInput);
        ArrayList apkDataList = new ArrayList(splitsToGenerate);
        for (ApkData apkData : splitsToGenerate) {
            boolean codeGen;
            if (!apkData.requiresAapt() || !(codeGen = apkData.getType() == VariantOutput.OutputType.MAIN || apkData.getFilter(VariantOutput.FilterType.DENSITY) == null)) continue;
            apkDataList.remove(apkData);
            this.invokeAaptForSplit(manifestsOutputs, packageIdFileSet, splitList, featureResourcePackages, apkData, codeGen);
            break;
        }
        for (ApkData apkData : apkDataList) {
            if (!apkData.requiresAapt()) continue;
            executor.execute(() -> {
                this.invokeAaptForSplit(manifestsOutputs, packageIdFileSet, splitList, featureResourcePackages, apkData, false);
                return null;
            });
        }
        try {
            List taskResults = executor.waitForAllTasks();
            taskResults.forEach(taskResult -> {
                if (taskResult.getException() != null) {
                    throw new BuildException(taskResult.getException().getMessage(), taskResult.getException());
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (this.splitHandlingPolicy == SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY) {
            this.splitScope.deleteAllEntries(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES);
            splitList.forEach((filterType, filterValues) -> {
                if (filterType != VariantOutput.FilterType.DENSITY && filterType != VariantOutput.FilterType.LANGUAGE) {
                    return;
                }
                filterValues.forEach(filterValue -> {
                    ApkData configurationApkData = this.splitFactory.addConfigurationSplit(filterType, (String)filterValue, "");
                    configurationApkData.setVersionCode(this.variantScope.getVariantConfiguration().getVersionCode());
                    configurationApkData.setVersionName(this.variantScope.getVariantConfiguration().getVersionName());
                    this.variantScope.getVariantData().variantOutputFactory.create(configurationApkData);
                    File packagedResForSplit = ProcessAndroidResources.findPackagedResForSplit(this.resPackageOutputFolder, configurationApkData);
                    if (packagedResForSplit != null) {
                        configurationApkData.setOutputFileName(packagedResForSplit.getName());
                        this.splitScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, configurationApkData, packagedResForSplit);
                    } else {
                        this.getLogger().warn("Cannot find output for " + configurationApkData);
                    }
                });
            });
        }
        this.splitScope.save((ImmutableList<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, (Object)TaskOutputHolder.TaskOutputType.PROCESSED_RES), this.resPackageOutputFolder);
    }

    void invokeAaptForSplit(Collection<BuildOutput> manifestsOutputs, Set<File> packageIdFileSet, SplitList splitList, Set<File> featureResourcePackages, ApkData apkData, boolean generateCode) throws IOException {
        String splitFilter;
        AndroidBuilder builder = this.getBuilder();
        MergingLog mergingLog = new MergingLog(this.getMergeBlameLogFolder());
        MergingLogRewriter mergingLogRewriter = new MergingLogRewriter(arg_0 -> ((MergingLog)mergingLog).find(arg_0), (MessageReceiver)builder.getErrorReporter());
        ParsingProcessOutputHandler processOutputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new AaptOutputParser(), this.getILogger()), new MessageReceiver[]{mergingLogRewriter});
        ImmutableList.Builder featurePackagesBuilder = ImmutableList.builder();
        for (File featurePackage : featureResourcePackages) {
            Collection<BuildOutput> splitOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.PROCESSED_RES, featurePackage);
            if (splitOutputs.isEmpty()) continue;
            featurePackagesBuilder.add((Object)((BuildOutput)Iterables.getOnlyElement(splitOutputs)).getOutputFile());
        }
        File resOutBaseNameFile = new File(this.resPackageOutputFolder, "resources-" + apkData.getFullName() + ".ap_");
        BuildOutput manifestOutput = SplitScope.getOutput(manifestsOutputs, (TaskOutputHolder.OutputType)this.taskInputType, (ApkInfo)apkData);
        if (manifestOutput == null) {
            throw new RuntimeException("Cannot find merged manifest file");
        }
        File manifestFile = manifestOutput.getOutputFile();
        String packageForR = null;
        File srcOut = null;
        File symbolOutputDir = null;
        File proguardOutputFile = null;
        File mainDexListProguardOutputFile = null;
        if (generateCode) {
            packageForR = this.originalApplicationId;
            srcOut = this.getSourceOutputDir();
            if (srcOut != null) {
                FileUtils.cleanOutputDir((File)srcOut);
            }
            symbolOutputDir = this.getTextSymbolOutputDir();
            proguardOutputFile = this.getProguardOutputFile();
            mainDexListProguardOutputFile = this.getMainDexListProguardOutputFile();
        }
        String preferredDensity = (splitFilter = apkData.getFilter(VariantOutput.FilterType.DENSITY)) != null ? splitFilter : (splitList.getFilters("ResConfigs").isEmpty() ? this.buildTargetDensity : null);
        Integer packageId = null;
        if (packageIdFileSet != null && FeatureSplitPackageIds.getOutputFile(packageIdFileSet) != null) {
            FeatureSplitPackageIds featurePackageIds = FeatureSplitPackageIds.load(packageIdFileSet);
            packageId = featurePackageIds.getIdFor(this.getProject().getPath());
        }
        try {
            if (this.enableNewResourceProcessing && this.type.equals((Object)VariantType.LIBRARY)) {
                SymbolTable symbolTable = ResourceDirectoryParser.parseDirectory((File)this.getInputResourcesDir().getSingleFile(), (IdProvider)IdProvider.sequential());
                SymbolUtils.processLibraryMainSymbolTable((SymbolTable)symbolTable, (List)(generateCode ? this.getLibraryInfoList() : ImmutableList.of()), (generateCode && this.getEnforceUniquePackageName() ? 1 : 0) != 0, (String)packageForR, (File)manifestFile, (File)srcOut, (File)symbolOutputDir, (File)proguardOutputFile, (File)this.getInputResourcesDir().getSingleFile());
            } else {
                Aapt aapt = AaptGradleFactory.make(this.aaptGeneration, builder, (ProcessOutputHandler)processOutputHandler, true, FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp")), this.aaptOptions.getCruncherProcesses());
                AaptPackageConfig.Builder config = new AaptPackageConfig.Builder().setManifestFile(manifestFile).setOptions((com.android.builder.model.AaptOptions)this.getAaptOptions()).setResourceDir(this.getInputResourcesDir().getSingleFile()).setLibraries((List)(generateCode ? this.getLibraryInfoList() : ImmutableList.of())).setCustomPackageForR(packageForR).setSymbolOutputDir(symbolOutputDir).setSourceOutputDir(srcOut).setResourceOutputApk(resOutBaseNameFile).setProguardOutputFile(proguardOutputFile).setMainDexListProguardOutputFile(mainDexListProguardOutputFile).setVariantType(this.getType()).setDebuggable(this.getDebuggable()).setPseudoLocalize(this.getPseudoLocalesEnabled()).setResourceConfigs(splitList.getFilters("ResConfigs")).setSplits(this.getSplits(splitList)).setPreferredDensity(preferredDensity).setPackageId(packageId).setDependentFeatures((Collection)featurePackagesBuilder.build()).setListResourceFiles(this.aaptGeneration == AaptGeneration.AAPT_V2);
                builder.processResources(aapt, config, generateCode && this.getEnforceUniquePackageName());
                if (LOG.isInfoEnabled()) {
                    LOG.info("Aapt output file {}", (Object)resOutBaseNameFile.getAbsolutePath());
                }
            }
            this.splitScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.PROCESSED_RES, apkData, resOutBaseNameFile, manifestOutput.getProperties());
        }
        catch (ProcessException | InterruptedException e) {
            this.getLogger().error(e.getMessage(), e);
            throw new BuildException(e.getMessage(), e);
        }
    }

    private static File findPackagedResForSplit(File outputFolder, ApkData apkData) {
        Pattern resourcePattern = Pattern.compile("resources-" + apkData.getFullName() + ".ap__(.*)");
        if (outputFolder == null) {
            return null;
        }
        File[] files = outputFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                Matcher match = resourcePattern.matcher(file.getName());
                if (!match.matches() || match.group(1).isEmpty() || !ProcessAndroidResources.isValidSplit(apkData, match.group(1))) continue;
                return file;
            }
        }
        return null;
    }

    private static boolean isValidSplit(ApkData apkData, String splitWithOptionalSuffix) {
        String splitFilter = apkData.getFilter(VariantOutput.FilterType.DENSITY);
        if (splitFilter != null && splitWithOptionalSuffix.startsWith(splitFilter)) {
            return true;
        }
        String mangledName = ProcessAndroidResources.unMangleSplitName(splitWithOptionalSuffix);
        return mangledName.equals(splitFilter = apkData.getFilter(VariantOutput.FilterType.LANGUAGE));
    }

    public static String unMangleSplitName(String splitWithOptionalSuffix) {
        String mangledName = splitWithOptionalSuffix.replaceAll("_", ",");
        return mangledName.contains("-r") ? mangledName : mangledName.replace("-", "-r");
    }

    @Internal
    private List<AaptPackageConfig.LibraryInfo> getLibraryInfoList() {
        if (this.computedLibraryInfo == null) {
            this.computedLibraryInfo = this.symbolFiles != null && this.manifests != null ? ProcessAndroidResources.computeLibraryInfoList(this.symbolFiles, this.manifests) : ImmutableList.of();
        }
        return this.computedLibraryInfo;
    }

    public static List<AaptPackageConfig.LibraryInfo> computeLibraryInfoList(VariantScope variantScope) {
        return ProcessAndroidResources.computeLibraryInfoList(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SYMBOL_LIST), variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST));
    }

    private static List<AaptPackageConfig.LibraryInfo> computeLibraryInfoList(ArtifactCollection symbolFiles, ArtifactCollection manifests) {
        HashMap<ComponentIdentifier, File> symbolMap = new HashMap<ComponentIdentifier, File>();
        for (ResolvedArtifactResult artifactResult : symbolFiles.getArtifacts()) {
            symbolMap.put(artifactResult.getId().getComponentIdentifier(), artifactResult.getFile());
        }
        Set manifestArtifacts = manifests.getArtifacts();
        ArrayList<AaptPackageConfig.LibraryInfo> libraryInfoList = new ArrayList<AaptPackageConfig.LibraryInfo>(manifestArtifacts.size());
        for (ResolvedArtifactResult artifactResult : manifestArtifacts) {
            libraryInfoList.add(new AaptPackageConfig.LibraryInfo(artifactResult.getFile(), (File)symbolMap.get(artifactResult.getId().getComponentIdentifier())));
        }
        return libraryInfoList;
    }

    public File getManifestFile() {
        File manifestDirectory = (File)Iterables.getFirst((Iterable)this.manifestFiles.getFiles(), null);
        Preconditions.checkNotNull((Object)manifestDirectory);
        Preconditions.checkNotNull((Object)this.splitScope.getMainSplit());
        return FileUtils.join((File)manifestDirectory, (String[])new String[]{this.splitScope.getMainSplit().getDirName(), "AndroidManifest.xml"});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifestFiles() {
        return this.manifestFiles;
    }

    public void setManifestFiles(FileCollection manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getPackageIdsFiles() {
        return this.packageIdsFiles != null ? this.packageIdsFiles.getArtifactFiles() : null;
    }

    @Input
    public boolean isInstantRunMode() {
        return this.buildContext.isInInstantRunMode();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getInputResourcesDir() {
        return this.inputResourcesDir;
    }

    @OutputDirectory
    @Optional
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputDirectory
    @Optional
    public File getTextSymbolOutputDir() {
        return this.textSymbolOutputDir.get();
    }

    public void setTextSymbolOutputDir(Supplier<File> textSymbolOutputDir) {
        this.textSymbolOutputDir = textSymbolOutputDir;
    }

    @OutputFile
    @Optional
    public File getProguardOutputFile() {
        return this.proguardOutputFile;
    }

    public void setProguardOutputFile(File proguardOutputFile) {
        this.proguardOutputFile = proguardOutputFile;
    }

    @OutputFile
    @Optional
    public File getMainDexListProguardOutputFile() {
        return this.mainDexListProguardOutputFile;
    }

    public void setAaptMainDexListProguardOutputFile(File mainDexListProguardOutputFile) {
        this.mainDexListProguardOutputFile = mainDexListProguardOutputFile;
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifests() {
        return this.manifests == null ? null : this.manifests.getArtifactFiles();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSymbolFiles() {
        return this.symbolFiles == null ? null : this.symbolFiles.getArtifactFiles();
    }

    @Input
    @Optional
    public String getPackageForR() {
        return this.packageForR != null ? this.packageForR.get() : null;
    }

    @Input
    public boolean getEnforceUniquePackageName() {
        return this.enforceUniquePackageName;
    }

    public void setEnforceUniquePackageName(boolean enforceUniquePackageName) {
        this.enforceUniquePackageName = enforceUniquePackageName;
    }

    @Input
    public String getTypeAsString() {
        return this.type.name();
    }

    @Internal
    public VariantType getType() {
        return this.type;
    }

    public void setType(VariantType type) {
        this.type = type;
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @Input
    public boolean getDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Input
    public boolean getPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    public void setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.pseudoLocalesEnabled = pseudoLocalesEnabled;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    @Input
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public void setMergeBlameLogFolder(File mergeBlameLogFolder) {
        this.mergeBlameLogFolder = mergeBlameLogFolder;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFeatureResourcePackages() {
        return this.featureResourcePackages;
    }

    @Input
    public SplitHandlingPolicy getSplitHandlingPolicy() {
        return this.splitHandlingPolicy;
    }

    @Input
    public String getOriginalApplicationId() {
        return this.originalApplicationId;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    FileCollection getSplitListInput() {
        return this.splitListInput;
    }

    @Input
    @Optional
    String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @OutputDirectory
    File getResPackageOutputFolder() {
        return this.resPackageOutputFolder;
    }

    @Input
    public boolean isEnabledNewResourceProcessing() {
        return this.enableNewResourceProcessing;
    }

    public void setEnableNewResourceProcessing(boolean enableNewResourceProcessing) {
        this.enableNewResourceProcessing = enableNewResourceProcessing;
    }

    @Input
    public boolean isAapt2Enabled() {
        return this.enableAapt2;
    }

    public void setEnableAapt2(boolean enableAapt2) {
        this.enableAapt2 = enableAapt2;
    }

    public static class FeatureSplitConfigAction
    extends ConfigAction {
        public FeatureSplitConfigAction(VariantScope scope, Supplier<File> symbolLocation, File resPackageOutputFolder, boolean generateLegacyMultidexMainDexProguardRules, TaskManager.MergeType mergeType, String baseName) {
            super(scope, symbolLocation, resPackageOutputFolder, generateLegacyMultidexMainDexProguardRules, mergeType, baseName);
        }

        @Override
        public void execute(ProcessAndroidResources processResources) {
            super.execute(processResources);
            processResources.packageIdsFiles = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_IDS_DECLARATION);
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessAndroidResources> {
        protected final VariantScope variantScope;
        protected final Supplier<File> symbolLocation;
        private final File resPackageOutputFolder;
        private final boolean generateLegacyMultidexMainDexProguardRules;
        private final TaskManager.MergeType sourceTaskOutputType;
        private final String baseName;

        public ConfigAction(VariantScope scope, Supplier<File> symbolLocation, File resPackageOutputFolder, boolean generateLegacyMultidexMainDexProguardRules, TaskManager.MergeType sourceTaskOutputType, String baseName) {
            this.variantScope = scope;
            this.symbolLocation = symbolLocation;
            this.resPackageOutputFolder = resPackageOutputFolder;
            this.generateLegacyMultidexMainDexProguardRules = generateLegacyMultidexMainDexProguardRules;
            this.baseName = baseName;
            this.sourceTaskOutputType = sourceTaskOutputType;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("process", "Resources");
        }

        @Override
        public Class<ProcessAndroidResources> getType() {
            return ProcessAndroidResources.class;
        }

        @Override
        public void execute(ProcessAndroidResources processResources) {
            BaseVariantData variantData = this.variantScope.getVariantData();
            variantData.addTask(TaskContainer.TaskKind.PROCESS_ANDROID_RESOURCES, (Task)processResources);
            GradleVariantConfiguration config = variantData.getVariantConfiguration();
            processResources.setAndroidBuilder(this.variantScope.getGlobalScope().getAndroidBuilder());
            processResources.setVariantName(config.getFullName());
            processResources.resPackageOutputFolder = this.resPackageOutputFolder;
            processResources.aaptGeneration = AaptGeneration.fromProjectOptions(this.variantScope.getGlobalScope().getProjectOptions());
            processResources.setEnableNewResourceProcessing(this.variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_NEW_RESOURCE_PROCESSING));
            processResources.setEnableAapt2(this.variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_AAPT2));
            processResources.setIncrementalFolder(this.variantScope.getIncrementalDir(this.getName()));
            processResources.splitListInput = this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.SPLIT_LIST);
            processResources.splitHandlingPolicy = variantData.getSplitScope().getSplitHandlingPolicy();
            processResources.enforceUniquePackageName = this.variantScope.getGlobalScope().getExtension().getEnforceUniquePackageName();
            processResources.manifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            processResources.symbolFiles = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SYMBOL_LIST);
            processResources.packageForR = TaskInputHelper.memoize(() -> {
                String splitName = config.getSplitFromManifest();
                if (splitName == null) {
                    return config.getOriginalApplicationId();
                }
                return config.getOriginalApplicationId() + "." + splitName;
            });
            processResources.setSourceOutputDir(this.variantScope.getRClassSourceOutputDir());
            processResources.setTextSymbolOutputDir(this.symbolLocation);
            if (this.variantScope.getCodeShrinker() != null) {
                processResources.setProguardOutputFile(this.variantScope.getProcessAndroidResourcesProguardOutputFile());
            }
            if (this.generateLegacyMultidexMainDexProguardRules) {
                processResources.setAaptMainDexListProguardOutputFile(this.variantScope.getManifestKeepListProguardFile());
            }
            processResources.variantScope = this.variantScope;
            processResources.splitScope = variantData.getSplitScope();
            processResources.splitFactory = variantData.getSplitFactory();
            processResources.originalApplicationId = this.variantScope.getVariantConfiguration().getOriginalApplicationId();
            boolean aaptFriendlyManifestsFilePresent = this.variantScope.hasOutput(TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS);
            processResources.taskInputType = aaptFriendlyManifestsFilePresent ? TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS : (this.variantScope.getInstantRunBuildContext().isInInstantRunMode() ? TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS : TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS);
            processResources.setManifestFiles(this.variantScope.getOutput(processResources.taskInputType));
            Preconditions.checkState((this.sourceTaskOutputType == TaskManager.MergeType.MERGE ? 1 : 0) != 0, (Object)"Support for not merging resources in libraries not implemented yet.");
            processResources.inputResourcesDir = this.variantScope.getOutput(this.sourceTaskOutputType.getOutputType());
            processResources.setType(config.getType());
            processResources.setDebuggable(((CoreBuildType)config.getBuildType()).isDebuggable());
            processResources.setAaptOptions(this.variantScope.getGlobalScope().getExtension().getAaptOptions());
            processResources.setPseudoLocalesEnabled(((CoreBuildType)config.getBuildType()).isPseudoLocalesEnabled());
            ProjectOptions projectOptions = this.variantScope.getGlobalScope().getProjectOptions();
            processResources.buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
            processResources.setMergeBlameLogFolder(this.variantScope.getResourceBlameLogDir());
            processResources.buildContext = this.variantScope.getInstantRunBuildContext();
            processResources.featureResourcePackages = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_RESOURCE_PKG);
            processResources.projectBaseName = this.baseName;
            processResources.buildTargetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) || this.variantScope.getGlobalScope().getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
            processResources.supportedAbis = config.getSupportedAbis();
        }
    }
}

