/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import java.io.File;
import org.gradle.api.JavaVersion;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

@CacheableTask
public class AndroidJavaCompile
extends JavaCompile {
    String compileSdkVersion;
    InstantRunBuildContext mInstantRunBuildContext;
    File annotationProcessorOutputFolder;

    @OutputDirectory
    public File getAnnotationProcessorOutputFolder() {
        return this.annotationProcessorOutputFolder;
    }

    protected void compile(IncrementalTaskInputs inputs) {
        this.getLogger().info("Compiling with source level {} and target level {}.", (Object)this.getSourceCompatibility(), (Object)this.getTargetCompatibility());
        if (this.isPostN() && !JavaVersion.current().isJava8Compatible()) {
            throw new RuntimeException("compileSdkVersion '" + this.compileSdkVersion + "' requires JDK 1.8 or later to compile.");
        }
        FileUtils.mkdirs((File)this.annotationProcessorOutputFolder);
        this.mInstantRunBuildContext.startRecording(InstantRunBuildContext.TaskType.JAVAC);
        super.compile(inputs);
        this.mInstantRunBuildContext.stopRecording(InstantRunBuildContext.TaskType.JAVAC);
    }

    private boolean isPostN() {
        AndroidVersion hash = AndroidTargetHash.getVersionFromHash((String)this.compileSdkVersion);
        return hash != null && hash.getApiLevel() >= 24;
    }
}

