/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.builder.core.VariantType;
import com.google.common.base.Preconditions;
import java.io.File;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;

public class AndroidUnitTest
extends Test {
    private FileCollection resCollection;
    private FileCollection assetsCollection;
    private FileCollection testClasses;

    public FileTree getCandidateClassFiles() {
        return this.testClasses.getAsFileTree();
    }

    @InputFiles
    @Optional
    public FileCollection getResCollection() {
        return this.resCollection;
    }

    @InputFiles
    @Optional
    public FileCollection getAssetsCollection() {
        return this.assetsCollection;
    }

    public static class ConfigAction
    implements TaskConfigAction<AndroidUnitTest> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = (VariantScope)Preconditions.checkNotNull((Object)scope);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(VariantType.UNIT_TEST.getPrefix());
        }

        @Override
        public Class<AndroidUnitTest> getType() {
            return AndroidUnitTest.class;
        }

        @Override
        public void execute(AndroidUnitTest runTestsTask) {
            TestVariantData variantData = (TestVariantData)this.scope.getVariantData();
            BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
            runTestsTask.systemProperty("java.awt.headless", "true");
            runTestsTask.setGroup("verification");
            runTestsTask.setDescription("Run unit tests for the " + testedVariantData.getVariantConfiguration().getFullName() + " build.");
            runTestsTask.testClasses = this.scope.getOutput(TaskOutputHolder.AnchorOutputType.CLASSES_FOR_UNIT_TESTS);
            runTestsTask.setClasspath((FileCollection)this.computeClasspath());
            if (this.scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources()) {
                VariantScope testedScope = testedVariantData.getScope();
                runTestsTask.assetsCollection = testedScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_ASSETS);
                runTestsTask.resCollection = testedScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_RES);
            }
            TestTaskReports testTaskReports = runTestsTask.getReports();
            JUnitXmlReport xmlReport = testTaskReports.getJunitXml();
            xmlReport.setDestination(new File(this.scope.getGlobalScope().getTestResultsFolder(), runTestsTask.getName()));
            DirectoryReport htmlReport = testTaskReports.getHtml();
            htmlReport.setDestination(new File(this.scope.getGlobalScope().getTestReportFolder(), runTestsTask.getName()));
            this.scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().applyConfiguration(runTestsTask);
        }

        private ConfigurableFileCollection computeClasspath() {
            ConfigurableFileCollection collection = this.scope.getGlobalScope().getProject().files(new Object[0]);
            collection.from(new Object[]{this.scope.getOutput(TaskOutputHolder.AnchorOutputType.CLASSES_FOR_UNIT_TESTS)});
            collection.from(new Object[]{this.scope.getOutput(TaskOutputHolder.TaskOutputType.JAVA_RES)});
            collection.from(new Object[]{this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)});
            collection.from(new Object[]{this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAVA_RES)});
            collection.from(new Object[]{this.scope.getGlobalScope().getOutput(TaskOutputHolder.TaskOutputType.MOCKABLE_JAR)});
            return collection;
        }
    }
}

