/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;

public class JacocoPlugin
implements Plugin<Project> {
    public static final String ANT_CONFIGURATION_NAME = "androidJacocoAnt";
    public static final String AGENT_CONFIGURATION_NAME = "androidJacocoAgent";
    private static final String DEFAULT_JACOCO_VERSION = "0.7.4.201502262128";
    private Project project;
    private String jacocoVersion;

    public void apply(Project project) {
        this.project = project;
        this.addJacocoConfigurations();
    }

    private void addJacocoConfigurations() {
        Configuration config = (Configuration)this.project.getConfigurations().create(AGENT_CONFIGURATION_NAME);
        config.setVisible(false);
        config.setTransitive(true);
        config.setCanBeConsumed(false);
        config.setDescription("The Jacoco agent to use to get coverage data.");
        this.project.getDependencies().add(AGENT_CONFIGURATION_NAME, (Object)("org.jacoco:org.jacoco.agent:" + this.getJacocoVersion() + ":runtime"));
        config = (Configuration)this.project.getConfigurations().create(ANT_CONFIGURATION_NAME);
        config.setVisible(false);
        config.setTransitive(true);
        config.setCanBeConsumed(false);
        config.setDescription("The Jacoco ant tasks to use to get execute Gradle tasks.");
        this.project.getDependencies().add(ANT_CONFIGURATION_NAME, (Object)("org.jacoco:org.jacoco.ant:" + this.getJacocoVersion()));
    }

    private String getJacocoVersion() {
        if (this.jacocoVersion != null) {
            return this.jacocoVersion;
        }
        boolean shouldFailWithException = false;
        for (Project candidateProject = this.project; candidateProject != null; candidateProject = candidateProject.getParent()) {
            Set resolvedArtifacts = candidateProject.getBuildscript().getConfigurations().getByName("classpath").getResolvedConfiguration().getResolvedArtifacts();
            for (ResolvedArtifact artifact : resolvedArtifacts) {
                ModuleVersionIdentifier moduleVersion = artifact.getModuleVersion().getId();
                if (!"org.jacoco.core".equals(moduleVersion.getName())) continue;
                this.jacocoVersion = moduleVersion.getVersion();
                return this.jacocoVersion;
            }
            if (resolvedArtifacts.isEmpty()) continue;
            shouldFailWithException = true;
        }
        if (shouldFailWithException) {
            throw new IllegalStateException("Could not find project build script dependency on org.jacoco.core");
        }
        this.project.getLogger().error("No resolved dependencies found when searching for the jacoco version.");
        this.jacocoVersion = DEFAULT_JACOCO_VERSION;
        return this.jacocoVersion;
    }
}

