/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.dsl.CoreExternalNativeBuildOptions;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.CoreShaderOptions;
import com.android.build.gradle.internal.dsl.ExternalNativeBuildOptions;
import com.android.build.gradle.internal.dsl.JackOptions;
import com.android.build.gradle.internal.dsl.JavaCompileOptions;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.dsl.ShaderOptions;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.VectorDrawablesOptions;
import com.android.builder.core.DefaultApiVersion;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.core.DefaultVectorDrawablesOptions;
import com.android.builder.core.ErrorReporter;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ClassField;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.internal.reflect.Instantiator;

public class ProductFlavor
extends DefaultProductFlavor
implements CoreProductFlavor {
    protected final Project project;
    protected final Logger logger;
    private final NdkOptions ndkConfig;
    private final ExternalNativeBuildOptions externalNativeBuildOptions;
    private final ErrorReporter errorReporter;
    private final JackOptions jackOptions;
    private final JavaCompileOptions javaCompileOptions;
    private final ShaderOptions shaderOptions;

    public ProductFlavor(String name, Project project, Instantiator instantiator, Logger logger, ErrorReporter errorReporter) {
        super(name, (DefaultVectorDrawablesOptions)instantiator.newInstance(VectorDrawablesOptions.class, new Object[0]));
        this.project = project;
        this.logger = logger;
        this.errorReporter = errorReporter;
        this.ndkConfig = (NdkOptions)instantiator.newInstance(NdkOptions.class, new Object[0]);
        this.externalNativeBuildOptions = (ExternalNativeBuildOptions)instantiator.newInstance(ExternalNativeBuildOptions.class, new Object[]{instantiator});
        this.jackOptions = (JackOptions)instantiator.newInstance(JackOptions.class, new Object[]{errorReporter});
        this.javaCompileOptions = (JavaCompileOptions)instantiator.newInstance(JavaCompileOptions.class, new Object[]{instantiator});
        this.shaderOptions = (ShaderOptions)instantiator.newInstance(ShaderOptions.class, new Object[0]);
    }

    public NdkOptions getNdk() {
        return this.ndkConfig;
    }

    @Override
    public CoreNdkOptions getNdkConfig() {
        return this.ndkConfig;
    }

    public ExternalNativeBuildOptions getExternalNativeBuild() {
        return this.externalNativeBuildOptions;
    }

    @Override
    public CoreExternalNativeBuildOptions getExternalNativeBuildOptions() {
        return this.externalNativeBuildOptions;
    }

    public void setMinSdkVersion(int minSdkVersion) {
        this.setMinSdkVersion((ApiVersion)new DefaultApiVersion(minSdkVersion));
    }

    public void minSdkVersion(int minSdkVersion) {
        this.setMinSdkVersion(minSdkVersion);
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.setMinSdkVersion(ProductFlavor.getApiVersion(minSdkVersion));
    }

    public void minSdkVersion(String minSdkVersion) {
        this.setMinSdkVersion(minSdkVersion);
    }

    public com.android.builder.model.ProductFlavor setTargetSdkVersion(int targetSdkVersion) {
        this.setTargetSdkVersion((ApiVersion)new DefaultApiVersion(targetSdkVersion));
        return this;
    }

    public void targetSdkVersion(int targetSdkVersion) {
        this.setTargetSdkVersion(targetSdkVersion);
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.setTargetSdkVersion(ProductFlavor.getApiVersion(targetSdkVersion));
    }

    public void targetSdkVersion(String targetSdkVersion) {
        this.setTargetSdkVersion(targetSdkVersion);
    }

    public void maxSdkVersion(int maxSdkVersion) {
        this.setMaxSdkVersion(maxSdkVersion);
    }

    private static ApiVersion getApiVersion(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            if (Character.isDigit(value.charAt(0))) {
                try {
                    int apiLevel = Integer.valueOf(value);
                    return new DefaultApiVersion(apiLevel);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("'" + value + "' is not a valid API level. ", e);
                }
            }
            return new DefaultApiVersion(value);
        }
        return null;
    }

    public void testInstrumentationRunnerArgument(String key, String value) {
        this.getTestInstrumentationRunnerArguments().put(key, value);
    }

    public void testInstrumentationRunnerArguments(Map<String, String> args) {
        this.getTestInstrumentationRunnerArguments().putAll(args);
    }

    public SigningConfig getSigningConfig() {
        return (SigningConfig)super.getSigningConfig();
    }

    public void buildConfigField(String type, String name, String value) {
        ClassField alreadyPresent = (ClassField)this.getBuildConfigFields().get(name);
        if (alreadyPresent != null) {
            String flavorName = this.getName();
            if ("main".equals(flavorName)) {
                this.logger.info("DefaultConfig: buildConfigField '{}' value is being replaced: {} -> {}", new Object[]{name, alreadyPresent.getValue(), value});
            } else {
                this.logger.info("ProductFlavor({}): buildConfigField '{}' value is being replaced: {} -> {}", new Object[]{flavorName, name, alreadyPresent.getValue(), value});
            }
        }
        this.addBuildConfigField((ClassField)new ClassFieldImpl(type, name, value));
    }

    public void resValue(String type, String name, String value) {
        ClassField alreadyPresent = (ClassField)this.getResValues().get(name);
        if (alreadyPresent != null) {
            String flavorName = this.getName();
            if ("main".equals(flavorName)) {
                this.logger.info("DefaultConfig: resValue '{}' value is being replaced: {} -> {}", new Object[]{name, alreadyPresent.getValue(), value});
            } else {
                this.logger.info("ProductFlavor({}): resValue '{}' value is being replaced: {} -> {}", new Object[]{flavorName, name, alreadyPresent.getValue(), value});
            }
        }
        this.addResValue((ClassField)new ClassFieldImpl(type, name, value));
    }

    public void proguardFile(Object proguardFile) {
        this.getProguardFiles().add(this.project.file(proguardFile));
    }

    public void proguardFiles(Object ... files) {
        for (Object file : files) {
            this.proguardFile(file);
        }
    }

    public void setProguardFiles(Iterable<?> proguardFileIterable) {
        this.getProguardFiles().clear();
        this.proguardFiles(Iterables.toArray(proguardFileIterable, Object.class));
    }

    public void testProguardFile(Object proguardFile) {
        this.getTestProguardFiles().add(this.project.file(proguardFile));
    }

    public void testProguardFiles(Object ... proguardFiles) {
        for (Object proguardFile : proguardFiles) {
            this.testProguardFile(proguardFile);
        }
    }

    public void setTestProguardFiles(Iterable<?> files) {
        this.getTestProguardFiles().clear();
        this.testProguardFiles(Iterables.toArray(files, Object.class));
    }

    public void consumerProguardFile(Object proguardFile) {
        this.getConsumerProguardFiles().add(this.project.file(proguardFile));
    }

    public void consumerProguardFiles(Object ... proguardFiles) {
        for (Object proguardFile : proguardFiles) {
            this.consumerProguardFile(proguardFile);
        }
    }

    public void setConsumerProguardFiles(Iterable<?> proguardFileIterable) {
        this.getConsumerProguardFiles().clear();
        this.consumerProguardFiles(Iterables.toArray(proguardFileIterable, Object.class));
    }

    public void ndk(Action<NdkOptions> action) {
        action.execute((Object)this.ndkConfig);
    }

    public void externalNativeBuild(Action<ExternalNativeBuildOptions> action) {
        action.execute((Object)this.externalNativeBuildOptions);
    }

    public void resConfig(String config) {
        this.addResourceConfiguration(config);
    }

    public void resConfigs(String ... config) {
        this.addResourceConfigurations(config);
    }

    public void resConfigs(Collection<String> config) {
        this.addResourceConfigurations(config);
    }

    @Override
    public JackOptions getJackOptions() {
        return this.jackOptions;
    }

    public void jackOptions(Action<JackOptions> action) {
        action.execute((Object)this.jackOptions);
    }

    @Deprecated
    public Boolean getUseJack() {
        this.errorReporter.handleSyncWarning(null, 0, "The Jack toolchain is deprecated and will not run. To enable support for Java 8 language features built into the plugin, remove 'jackOptions { ... }' from your build.gradle file, and add\n\nandroid.compileOptions.sourceCompatibility 1.8\nandroid.compileOptions.targetCompatibility 1.8\n\nFuture versions of the plugin will not support usage of 'jackOptions' in build.gradle.\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n");
        return null;
    }

    @Deprecated
    public void setUseJack(Boolean useJack) {
        this.errorReporter.handleSyncWarning(null, 0, "The Jack toolchain is deprecated and will not run. To enable support for Java 8 language features built into the plugin, remove 'jackOptions { ... }' from your build.gradle file, and add\n\nandroid.compileOptions.sourceCompatibility 1.8\nandroid.compileOptions.targetCompatibility 1.8\n\nFuture versions of the plugin will not support usage of 'jackOptions' in build.gradle.\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n");
    }

    @Deprecated
    public void useJack(Boolean useJack) {
        this.errorReporter.handleSyncWarning(null, 0, "The Jack toolchain is deprecated and will not run. To enable support for Java 8 language features built into the plugin, remove 'jackOptions { ... }' from your build.gradle file, and add\n\nandroid.compileOptions.sourceCompatibility 1.8\nandroid.compileOptions.targetCompatibility 1.8\n\nFuture versions of the plugin will not support usage of 'jackOptions' in build.gradle.\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n");
    }

    @Override
    public JavaCompileOptions getJavaCompileOptions() {
        return this.javaCompileOptions;
    }

    public void javaCompileOptions(Action<JavaCompileOptions> action) {
        action.execute((Object)this.javaCompileOptions);
    }

    @Override
    public CoreShaderOptions getShaders() {
        return this.shaderOptions;
    }

    public void shaders(Action<ShaderOptions> action) {
        action.execute((Object)this.shaderOptions);
    }

    @Deprecated
    public void setFlavorDimension(String dimension) {
        this.errorReporter.handleSyncWarning(null, 0, "'flavorDimension' will be removed in a future version of Android Gradle Plugin, it has been replaced by 'dimension'.");
        this.setDimension(dimension);
    }

    @Deprecated
    public String getFlavorDimension() {
        this.errorReporter.handleSyncWarning(null, 0, "'flavorDimension' will be removed in a future version of Android Gradle Plugin, it has been replaced by 'dimension'.");
        return this.getDimension();
    }

    public void jarJarRuleFile(Object file) {
        this.getJarJarRuleFiles().add(this.project.file(file));
    }

    public void jarJarRuleFiles(Object ... files) {
        this.getJarJarRuleFiles().clear();
        for (Object file : files) {
            this.getJarJarRuleFiles().add(this.project.file(file));
        }
    }

    @Deprecated
    public Set<String> getGeneratedDensities() {
        return this.getVectorDrawables().getGeneratedDensities();
    }

    @Deprecated
    public void setGeneratedDensities(Iterable<String> densities) {
        this.getVectorDrawables().setGeneratedDensities(densities);
    }

    public void vectorDrawables(Action<VectorDrawablesOptions> action) {
        action.execute((Object)this.getVectorDrawables());
    }

    public VectorDrawablesOptions getVectorDrawables() {
        return (VectorDrawablesOptions)super.getVectorDrawables();
    }

    public void wearAppUnbundled(Boolean wearAppUnbundled) {
        this.setWearAppUnbundled(wearAppUnbundled);
    }
}

