/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.externalBuild;

import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.externalBuild.ExternalBuildContext;
import com.android.build.gradle.internal.externalBuild.ExternalBuildVariantScope;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.AaptOptions;
import com.android.sdklib.AndroidVersion;
import com.android.utils.StringHelper;
import com.google.devtools.build.lib.rules.android.apkmanifest.ExternalBuildApkManifest;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;

public class ExternalBuildPackagingScope
implements PackagingScope {
    private final Project mProject;
    private final ExternalBuildContext mExternalBuildContext;
    private final ExternalBuildApkManifest.ApkManifest mBuildManifest;
    private final ExternalBuildVariantScope mVariantScope;
    private final TransformManager mTransformManager;
    private InstantRunBuildContext mInstantRunBuildContext;
    private final SigningConfig mSigningConfig;

    public ExternalBuildPackagingScope(Project project, ExternalBuildContext externalBuildContext, ExternalBuildVariantScope variantScope, TransformManager transformManager, SigningConfig signingConfig) {
        this.mProject = project;
        this.mExternalBuildContext = externalBuildContext;
        this.mBuildManifest = externalBuildContext.getBuildManifest();
        this.mVariantScope = variantScope;
        this.mTransformManager = transformManager;
        this.mSigningConfig = signingConfig;
        this.mInstantRunBuildContext = this.mVariantScope.getInstantRunBuildContext();
    }

    @Override
    public AndroidBuilder getAndroidBuilder() {
        return this.mExternalBuildContext.getAndroidBuilder();
    }

    @Override
    public String getProjectBaseName() {
        return this.mExternalBuildContext.getExecutionRoot().getName();
    }

    @Override
    public String getFullVariantName() {
        return this.mVariantScope.getFullVariantName();
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        return new AndroidVersion(this.mInstantRunBuildContext.getAndroidVersion().getApiLevel(), this.mInstantRunBuildContext.getAndroidVersion().getCodename());
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.mInstantRunBuildContext;
    }

    @Override
    public File getInstantRunSupportDir() {
        return this.mVariantScope.getInstantRunSupportDir();
    }

    @Override
    public File getIncrementalDir(String name) {
        return this.mVariantScope.getIncrementalDir(name);
    }

    @Override
    public FileCollection getDexFolders() {
        return this.mTransformManager.getPipelineOutputAsFileCollection(StreamFilter.DEX);
    }

    @Override
    public FileCollection getJavaResources() {
        return this.getProject().files(new Object[0]);
    }

    @Override
    public FileCollection getJniFolders() {
        return this.getProject().files(new Object[0]);
    }

    @Override
    public SplitHandlingPolicy getSplitHandlingPolicy() {
        return SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY;
    }

    @Override
    public Set<String> getAbiFilters() {
        return Collections.emptySet();
    }

    private ApkOutputFile getMainOutputFile() {
        return this.mVariantScope.getMainOutputFile();
    }

    @Override
    public Set<String> getSupportedAbis() {
        return null;
    }

    @Override
    public boolean isDebuggable() {
        return true;
    }

    @Override
    public boolean isJniDebuggable() {
        return false;
    }

    @Override
    public CoreSigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    @Override
    public PackagingOptions getPackagingOptions() {
        return new PackagingOptions();
    }

    @Override
    public String getTaskName(String name) {
        return name + StringHelper.capitalize((String)this.getFullVariantName());
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return prefix + this.getFullVariantName() + suffix;
    }

    @Override
    public Project getProject() {
        return this.mProject;
    }

    @Override
    public File getInstantRunSplitApkOutputFolder() {
        return this.mVariantScope.getInstantRunSplitApkOutputFolder();
    }

    @Override
    public String getApplicationId() {
        return this.mVariantScope.getApplicationId();
    }

    @Override
    public int getVersionCode() {
        return this.mVariantScope.getVersionCode();
    }

    @Override
    public String getVersionName() {
        return this.mVariantScope.getVersionName();
    }

    @Override
    public AaptOptions getAaptOptions() {
        return this.mVariantScope.getAaptOptions();
    }

    @Override
    public SplitScope getSplitScope() {
        return this.mVariantScope.getSplitScope();
    }

    @Override
    public FileCollection getOutput(TaskOutputHolder.OutputType outputType) {
        return this.mVariantScope.getOutput(outputType);
    }

    @Override
    public boolean hasOutput(TaskOutputHolder.OutputType outputType) {
        return this.mVariantScope.hasOutput(outputType);
    }

    @Override
    public ConfigurableFileCollection addTaskOutput(TaskOutputHolder.TaskOutputType outputType, File file, String taskName) {
        return this.mVariantScope.addTaskOutput(outputType, file, taskName);
    }

    @Override
    public ConfigurableFileCollection createAnchorOutput(TaskOutputHolder.AnchorOutputType outputType) {
        return this.mVariantScope.createAnchorOutput(outputType);
    }

    @Override
    public void addToAnchorOutput(TaskOutputHolder.AnchorOutputType outputType, File file, String taskName) {
        this.mVariantScope.addToAnchorOutput(outputType, file, taskName);
    }

    @Override
    public void addToAnchorOutput(TaskOutputHolder.AnchorOutputType outputType, FileCollection fileCollection) {
        this.mVariantScope.addToAnchorOutput(outputType, fileCollection);
    }

    @Override
    public void addTask(TaskContainer.TaskKind taskKind, Task task) {
    }
}

