/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.dependency.VariantAttr;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.level2.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.level2.FullDependencyGraphsImpl;
import com.android.build.gradle.internal.ide.level2.GraphItemImpl;
import com.android.build.gradle.internal.ide.level2.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.level2.ModuleLibraryImpl;
import com.android.build.gradle.internal.ide.level2.SimpleDependencyGraphsImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.android.ide.common.caching.CreatingCache;
import com.android.utils.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.component.Artifact;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;

public class ArtifactDependencyGraph {
    private static final String LOCAL_AAR_GROUPID = "__local_aars__";
    private static final CreatingCache<HashableResolvedArtifactResult, MavenCoordinates> sMavenCoordinatesCache = new CreatingCache(ArtifactDependencyGraph::computeMavenCoordinates);
    private static final CreatingCache<HashableResolvedArtifactResult, Library> sLibraryCache = new CreatingCache(ArtifactDependencyGraph::instantiateLibrary);
    private static final Map<String, Library> sGlobalLibrary = Maps.newHashMap();
    private final List<Throwable> failures = Lists.newArrayList();

    public static void clearCaches() {
        sMavenCoordinatesCache.clear();
        sLibraryCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Library instantiateLibrary(HashableResolvedArtifactResult artifact) {
        Library library;
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        String address = ArtifactDependencyGraph.computeAddress(artifact);
        if (!(id instanceof ProjectComponentIdentifier) || artifact.isWrappedModule()) {
            if (artifact.getDependencyType() == DependencyType.ANDROID) {
                File folder = artifact.getFile();
                library = new AndroidLibraryImpl(address, artifact.bundleResult != null ? artifact.bundleResult.getFile() : folder, folder, (Collection<File>)ImmutableList.of());
            } else {
                library = new JavaLibraryImpl(address, artifact.getFile());
            }
        } else {
            library = new ModuleLibraryImpl(address, ((ProjectComponentIdentifier)id).getProjectPath(), ArtifactDependencyGraph.getVariant(artifact));
        }
        Map<String, Library> map = sGlobalLibrary;
        synchronized (map) {
            sGlobalLibrary.put(library.getArtifactAddress(), library);
        }
        return library;
    }

    public static Map<String, Library> getGlobalLibMap() {
        return ImmutableMap.copyOf(sGlobalLibrary);
    }

    public static String getVariant(ResolvedArtifactResult artifact) {
        VariantAttr variantAttr = (VariantAttr)artifact.getVariant().getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
        return variantAttr == null ? null : variantAttr.getName();
    }

    public static String computeAddress(HashableResolvedArtifactResult artifact) {
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        if (id instanceof ProjectComponentIdentifier) {
            String variant = ArtifactDependencyGraph.getVariant(artifact);
            if (variant == null) {
                return ((ProjectComponentIdentifier)id).getProjectPath().intern();
            }
            return (((ProjectComponentIdentifier)id).getProjectPath() + "::" + variant).intern();
        }
        if (id instanceof ModuleComponentIdentifier || id instanceof OpaqueComponentArtifactIdentifier) {
            MavenCoordinates coordinates = (MavenCoordinates)sMavenCoordinatesCache.get((Object)artifact);
            Preconditions.checkNotNull((Object)coordinates);
            return coordinates.toString().intern();
        }
        throw new RuntimeException("Don't know how to handle ComponentIdentifier '" + id.getDisplayName() + "'of type " + id.getClass());
    }

    private static MavenCoordinates computeMavenCoordinates(ResolvedArtifactResult artifact) {
        HashableResolvedArtifactResult hashableResult = (HashableResolvedArtifactResult)artifact;
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        File artifactFile = artifact.getFile();
        String fileName = artifactFile.getName();
        String extension = hashableResult.getDependencyType().getExtension();
        if (id instanceof ModuleComponentIdentifier) {
            String pattern;
            Pattern p;
            Matcher m;
            ModuleComponentIdentifier moduleComponentId = (ModuleComponentIdentifier)id;
            String module = moduleComponentId.getModule();
            String version = moduleComponentId.getVersion();
            String classifier = null;
            if (!artifact.getFile().isDirectory() && (m = (p = Pattern.compile(pattern = "^" + module + "-" + version + "-(.+)\\." + extension + "$")).matcher(fileName)).matches()) {
                classifier = m.group(1);
            }
            return new MavenCoordinatesImpl(moduleComponentId.getGroup(), module, version, extension, classifier);
        }
        if (id instanceof ProjectComponentIdentifier) {
            return new MavenCoordinatesImpl("artifacts", ((ProjectComponentIdentifier)id).getProjectPath(), "unspecified");
        }
        if (id instanceof OpaqueComponentArtifactIdentifier) {
            if (hashableResult.getDependencyType() == DependencyType.JAVA) {
                return ArtifactDependencyGraph.getMavenCoordForLocalFile(artifactFile);
            }
            assert (artifactFile.isDirectory());
            return ArtifactDependencyGraph.getMavenCoordForLocalFile(artifactFile);
        }
        throw new RuntimeException("Don't know how to compute maven coordinate for artifact '" + artifact.getId().getDisplayName() + "' with component identifier of type '" + id.getClass() + "'.");
    }

    public static MavenCoordinatesImpl getMavenCoordForLocalFile(File artifactFile) {
        return new MavenCoordinatesImpl(LOCAL_AAR_GROUPID, artifactFile.getPath(), "unspecified");
    }

    public static Set<HashableResolvedArtifactResult> getAllArtifacts(VariantScope variantScope, AndroidArtifacts.ConsumedConfigType consumedConfigType, Consumer<Collection<Throwable>> failureConsumer) {
        ArtifactCollection allArtifactList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
        ArtifactCollection manifestList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
        ArtifactCollection explodedAarList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.EXPLODED_AAR);
        ArtifactCollection aarList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.AAR);
        if (failureConsumer != null) {
            failureConsumer.accept(allArtifactList.getFailures());
        }
        HashSet<ComponentIdentifier> wrapperModules = new HashSet<ComponentIdentifier>();
        HashMap<ComponentIdentifier, Object> aarFolders = new HashMap<ComponentIdentifier, Object>();
        for (Object result : explodedAarList.getArtifacts()) {
            ComponentIdentifier componentIdentifier = result.getId().getComponentIdentifier();
            if (componentIdentifier instanceof ProjectComponentIdentifier) {
                wrapperModules.add(componentIdentifier);
            }
            aarFolders.put(componentIdentifier, result);
        }
        HashMap<ComponentIdentifier, Object> aarArtifacts = new HashMap<ComponentIdentifier, Object>();
        for (Object result : aarList.getArtifacts()) {
            aarArtifacts.put(result.getId().getComponentIdentifier(), result);
        }
        HashSet<ComponentIdentifier> androidModules = new HashSet<ComponentIdentifier>();
        for (ResolvedArtifactResult result : manifestList.getArtifacts()) {
            androidModules.add(result.getId().getComponentIdentifier());
        }
        Set mainArtifacts = allArtifactList.getArtifacts();
        LinkedHashSet artifacts = Sets.newLinkedHashSet();
        for (ResolvedArtifactResult result : mainArtifacts) {
            ComponentIdentifier componentIdentifier = result.getId().getComponentIdentifier();
            boolean isWrappedModule = wrapperModules.contains(componentIdentifier);
            DependencyType dependencyType = DependencyType.JAVA;
            ResolvedArtifactResult aarResult = null;
            if (androidModules.contains(componentIdentifier)) {
                dependencyType = DependencyType.ANDROID;
                ResolvedArtifactResult explodedAar = (ResolvedArtifactResult)aarFolders.get(componentIdentifier);
                if (explodedAar != null) {
                    result = explodedAar;
                }
                aarResult = (ResolvedArtifactResult)aarArtifacts.get(componentIdentifier);
            }
            artifacts.add(new HashableResolvedArtifactResult(result, dependencyType, isWrappedModule, aarResult));
        }
        return artifacts;
    }

    private static ArtifactCollection computeArtifactList(VariantScope variantScope, AndroidArtifacts.ConsumedConfigType consumedConfigType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType type) {
        ArtifactCollection artifacts = variantScope.getArtifactCollection(consumedConfigType, scope, type);
        if (artifacts instanceof ArtifactCollectionWithExtraArtifact) {
            return ((ArtifactCollectionWithExtraArtifact)artifacts).getParentArtifacts();
        }
        return artifacts;
    }

    public DependencyGraphs createLevel2DependencyGraph(VariantScope variantScope, boolean withFullDependency, boolean downloadSources) {
        Project project = variantScope.getGlobalScope().getProject();
        ArrayList compileItems = Lists.newArrayList();
        Set<HashableResolvedArtifactResult> compileArtifacts = ArtifactDependencyGraph.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.failures::addAll);
        for (HashableResolvedArtifactResult artifact2 : compileArtifacts) {
            compileItems.add(new GraphItemImpl(ArtifactDependencyGraph.computeAddress(artifact2), (List<GraphItem>)ImmutableList.of()));
            sLibraryCache.get((Object)artifact2);
        }
        if (!withFullDependency) {
            if (downloadSources) {
                ArtifactDependencyGraph.handleJavadoc(project, compileArtifacts.stream().map(artifact -> artifact.getId().getComponentIdentifier()).collect(Collectors.toSet()));
            }
            return new SimpleDependencyGraphsImpl(compileItems);
        }
        ArrayList runtimeItems = Lists.newArrayList();
        Set<HashableResolvedArtifactResult> runtimeArtifacts = ArtifactDependencyGraph.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, this.failures::addAll);
        for (HashableResolvedArtifactResult artifact3 : runtimeArtifacts) {
            runtimeItems.add(new GraphItemImpl(ArtifactDependencyGraph.computeAddress(artifact3), (List<GraphItem>)ImmutableList.of()));
            sLibraryCache.get((Object)artifact3);
        }
        ArrayList providedItems = Lists.newArrayList((Iterable)compileItems);
        providedItems.removeAll(runtimeItems);
        if (downloadSources) {
            ArtifactDependencyGraph.handleJavadoc(project, Stream.concat(compileArtifacts.stream(), runtimeArtifacts.stream()).map(artifact -> artifact.getId().getComponentIdentifier()).collect(Collectors.toSet()));
        }
        return new FullDependencyGraphsImpl(compileItems, runtimeItems, (List)providedItems.stream().map(GraphItem::getArtifactAddress).collect(ImmutableCollectors.toImmutableList()), (List<String>)ImmutableList.of());
    }

    public DependenciesImpl createDependencies(VariantScope variantScope, boolean downloadSources) {
        ImmutableList.Builder projects = ImmutableList.builder();
        ImmutableList.Builder androidLibraries = ImmutableList.builder();
        ImmutableList.Builder javaLibrary = ImmutableList.builder();
        ArtifactCollection runtimeArtifactCollection = ArtifactDependencyGraph.computeArtifactList(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
        HashSet<ComponentIdentifier> runtimeIdentifiers = new HashSet<ComponentIdentifier>(runtimeArtifactCollection.getArtifacts().size());
        for (ResolvedArtifactResult result : runtimeArtifactCollection.getArtifacts()) {
            runtimeIdentifiers.add(result.getId().getComponentIdentifier());
        }
        Set<HashableResolvedArtifactResult> artifacts = ArtifactDependencyGraph.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.failures::addAll);
        for (HashableResolvedArtifactResult artifact2 : artifacts) {
            String projectPath;
            ComponentIdentifier id = artifact2.getId().getComponentIdentifier();
            boolean isProvided = !runtimeIdentifiers.contains(id);
            boolean isSubproject = id instanceof ProjectComponentIdentifier;
            String string = projectPath = isSubproject ? ((ProjectComponentIdentifier)id).getProjectPath() : null;
            if (artifact2.getDependencyType() == DependencyType.JAVA) {
                if (projectPath != null) {
                    projects.add((Object)projectPath);
                    continue;
                }
                javaLibrary.add((Object)new com.android.build.gradle.internal.ide.JavaLibraryImpl(artifact2.getFile(), null, (List<JavaLibrary>)ImmutableList.of(), null, (MavenCoordinates)Preconditions.checkNotNull((Object)sMavenCoordinatesCache.get((Object)artifact2)), false, isProvided));
                continue;
            }
            if (artifact2.isWrappedModule()) {
                projectPath = null;
            }
            androidLibraries.add((Object)new com.android.build.gradle.internal.ide.AndroidLibraryImpl((MavenCoordinates)Preconditions.checkNotNull((Object)sMavenCoordinatesCache.get((Object)artifact2)), projectPath, artifact2.bundleResult != null ? artifact2.bundleResult.getFile() : artifact2.getFile(), artifact2.getFile(), ArtifactDependencyGraph.getVariant(artifact2), isProvided, false, (List<AndroidLibrary>)ImmutableList.of(), (Collection<JavaLibrary>)ImmutableList.of(), (Collection<File>)ImmutableList.of()));
        }
        if (downloadSources) {
            ArtifactDependencyGraph.handleJavadoc(variantScope.getGlobalScope().getProject(), artifacts.stream().map(artifact -> artifact.getId().getComponentIdentifier()).collect(Collectors.toSet()));
        }
        return new DependenciesImpl((List<AndroidLibrary>)androidLibraries.build(), (List<JavaLibrary>)javaLibrary.build(), (List<String>)projects.build());
    }

    public List<String> collectFailures() {
        if (this.failures.isEmpty()) {
            return ImmutableList.of();
        }
        Pattern pattern = Pattern.compile(".*any matches for ([a-zA-Z0-9:\\-.+]+) .*", 32);
        Pattern pattern2 = Pattern.compile(".*Could not find ([a-zA-Z0-9:\\-.]+)\\..*", 32);
        return this.failures.stream().flatMap(throwable -> {
            List causes = throwable instanceof ResolveException ? ((ResolveException)throwable).getCauses() : Collections.singletonList(throwable);
            ArrayList<String> messages = new ArrayList<String>();
            for (Throwable cause : causes) {
                String message = cause.getMessage();
                Matcher m = pattern.matcher(message);
                if (m.matches()) {
                    messages.add(m.group(1));
                    continue;
                }
                m = pattern2.matcher(message);
                if (m.matches()) {
                    messages.add(m.group(1));
                    continue;
                }
                messages.add(cause.getMessage());
            }
            return messages.stream();
        }).collect(Collectors.toList());
    }

    public static Dependencies clone(Dependencies dependencies, int modelLevel) {
        if (modelLevel >= 4) {
            return ModelBuilder.EMPTY_DEPENDENCIES_IMPL;
        }
        List<AndroidLibrary> libraries = Collections.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List<String> projects = Collections.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyGraphs clone(DependencyGraphs dependencyGraphs, int modelLevel, boolean modelWithFullDependency) {
        if (modelLevel < 4) {
            return ModelBuilder.EMPTY_DEPENDENCY_GRAPH;
        }
        Preconditions.checkState((boolean)(dependencyGraphs instanceof ConfigurationDependencyGraphs));
        ConfigurationDependencyGraphs cdg = (ConfigurationDependencyGraphs)dependencyGraphs;
        List<Library> libs = cdg.getLibraries();
        Map<String, Library> map = sGlobalLibrary;
        synchronized (map) {
            for (Library library : libs) {
                sGlobalLibrary.put(library.getArtifactAddress(), library);
            }
        }
        List<GraphItem> nodes = cdg.getCompileDependencies();
        if (modelWithFullDependency) {
            return new FullDependencyGraphsImpl(nodes, nodes, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of());
        }
        return new SimpleDependencyGraphsImpl(nodes);
    }

    private static void handleJavadoc(Project project, Set<ComponentIdentifier> artifacts) {
        DependencyHandler dependencies = project.getDependencies();
        ArtifactResolutionQuery query = dependencies.createArtifactResolutionQuery();
        query.forComponents(artifacts);
        Class[] artifactTypesArray = new Class[]{JavadocArtifact.class, SourcesArtifact.class};
        query.withArtifacts(JvmLibrary.class, artifactTypesArray);
        query.execute().getResolvedComponents();
    }

    public static class HashableResolvedArtifactResult
    implements ResolvedArtifactResult {
        private final ResolvedArtifactResult delegate;
        private final DependencyType dependencyType;
        private final boolean wrappedModule;
        private final ResolvedArtifactResult bundleResult;

        public HashableResolvedArtifactResult(ResolvedArtifactResult delegate, DependencyType dependencyType, boolean wrappedModule, ResolvedArtifactResult bundleResult) {
            this.delegate = delegate;
            this.dependencyType = dependencyType;
            this.wrappedModule = wrappedModule;
            this.bundleResult = bundleResult;
        }

        public File getFile() {
            return this.delegate.getFile();
        }

        public ResolvedVariantResult getVariant() {
            return this.delegate.getVariant();
        }

        public ComponentArtifactIdentifier getId() {
            return this.delegate.getId();
        }

        public Class<? extends Artifact> getType() {
            return this.delegate.getType();
        }

        public DependencyType getDependencyType() {
            return this.dependencyType;
        }

        public boolean isWrappedModule() {
            return this.wrappedModule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashableResolvedArtifactResult that = (HashableResolvedArtifactResult)o;
            return this.wrappedModule == that.wrappedModule && this.dependencyType == that.dependencyType && com.google.common.base.Objects.equal((Object)this.getFile(), (Object)that.getFile()) && com.google.common.base.Objects.equal((Object)this.getId(), (Object)that.getId()) && com.google.common.base.Objects.equal(this.getType(), that.getType());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.delegate, this.dependencyType, this.wrappedModule});
        }
    }

    public static enum DependencyType {
        JAVA("jar"),
        ANDROID("aar");

        private final String extension;

        private DependencyType(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

