/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.api.transform.Transform;
import com.android.sdklib.AndroidVersion;
import com.android.tools.build.gradle.internal.profile.GradleTaskExecutionType;
import com.android.tools.build.gradle.internal.profile.GradleTransformExecutionType;
import com.google.common.base.CaseFormat;
import com.google.wireless.android.sdk.stats.ApiVersion;

public class AnalyticsUtil {
    public static GradleTransformExecutionType getTransformType(Class<? extends Transform> taskClass) {
        try {
            return GradleTransformExecutionType.valueOf((String)AnalyticsUtil.getPotentialTransformTypeName(taskClass));
        }
        catch (IllegalArgumentException ignored) {
            return GradleTransformExecutionType.UNKNOWN_TRANSFORM_TYPE;
        }
    }

    static String getPotentialTransformTypeName(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        if (taskImpl.endsWith("Transform")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "Transform".length());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
    }

    public static GradleTaskExecutionType getTaskExecutionType(Class<?> taskClass) {
        try {
            return GradleTaskExecutionType.valueOf((String)AnalyticsUtil.getPotentialTaskExecutionTypeName(taskClass));
        }
        catch (IllegalArgumentException ignored) {
            return GradleTaskExecutionType.UNKNOWN_TASK_TYPE;
        }
    }

    static String getPotentialTaskExecutionTypeName(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        if (taskImpl.endsWith("_Decorated")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "_Decorated".length());
        }
        if (taskImpl.endsWith("Task")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "Task".length());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
    }

    public static ApiVersion convert(AndroidVersion apiVersion) {
        ApiVersion.Builder builder = ApiVersion.newBuilder().setApiLevel((long)apiVersion.getApiLevel());
        if (apiVersion.getCodename() != null) {
            builder.setCodename(apiVersion.getCodename());
        }
        return builder.build();
    }

    public static ApiVersion convert(com.android.builder.model.ApiVersion apiVersion) {
        ApiVersion.Builder builder = ApiVersion.newBuilder().setApiLevel((long)apiVersion.getApiLevel());
        if (apiVersion.getCodename() != null) {
            builder.setCodename(apiVersion.getCodename());
        }
        return builder.build();
    }
}

