/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.PostprocessingActions;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dependency.SubtractingArtifactCollection;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.PostprocessingOptions;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.VariantPublishingSpec;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GenericVariantScopeImpl;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.MissingTaskOutputException;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskOutputAlreadyRegisteredException;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingProcessLayoutsTask;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.DeploymentDevice;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.BootClasspathBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexingType;
import com.android.builder.model.BaseConfig;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.compile.JavaCompile;

public class VariantScopeImpl
extends GenericVariantScopeImpl
implements VariantScope {
    private static final ILogger LOGGER = LoggerWrapper.getLogger(VariantScopeImpl.class);
    private final VariantPublishingSpec variantPublishingSpec;
    private final GlobalScope globalScope;
    private final BaseVariantData variantData;
    private final ErrorReporter errorReporter;
    private final TransformManager transformManager;
    private Collection<Object> ndkBuildable;
    private Collection<File> ndkSoFolder;
    private File ndkObjFolder;
    private final Map<Abi, File> ndkDebuggableLibraryFolders = Maps.newHashMap();
    private File mergeResourceOutputDir;
    private AndroidTask<DefaultTask> assembleTask;
    private AndroidTask<? extends DefaultTask> preBuildTask;
    private AndroidTask<Task> sourceGenTask;
    private AndroidTask<Task> resourceGenTask;
    private AndroidTask<Task> assetGenTask;
    private AndroidTask<CheckManifest> checkManifestTask;
    private AndroidTask<RenderscriptCompile> renderscriptCompileTask;
    private AndroidTask<AidlCompile> aidlCompileTask;
    private AndroidTask<MergeResources> mergeResourcesTask;
    private AndroidTask<MergeSourceSetFolders> mergeAssetsTask;
    private AndroidTask<GenerateBuildConfig> generateBuildConfigTask;
    private AndroidTask<Sync> processJavaResourcesTask;
    private AndroidTask<TransformTask> mergeJavaResourcesTask;
    private AndroidTask<DataBindingProcessLayoutsTask> dataBindingProcessLayoutsTask;
    private AndroidTask<? extends JavaCompile> javacTask;
    private AndroidTask<Task> compileTask;
    private AndroidTask<GenerateApkDataTask> microApkTask;
    private AndroidTask<ExternalNativeBuildTask> externalNativeBuild;
    private ExternalNativeJsonGenerator externalNativeJsonGenerator;
    private final List<NativeBuildConfigValue> externalNativeBuildConfigValues = Lists.newArrayList();
    private AndroidTask<?> coverageReportTask;
    private File resourceOutputDir;
    private InstantRunTaskManager instantRunTaskManager;
    private ConfigurableFileCollection desugarTryWithResourcesRuntimeJar;
    private AndroidTask<DataBindingExportBuildInfoTask> dataBindingExportBuildInfoTask;
    private AndroidTask<? extends ManifestProcessorTask> manifestProcessorTask;
    private final InstantRunBuildContext instantRunBuildContext;
    AndroidTask<ProcessAndroidResources> processAndroidResourcesTask;

    public VariantScopeImpl(GlobalScope globalScope, ErrorReporter errorReporter, TransformManager transformManager, BaseVariantData variantData) {
        this.globalScope = globalScope;
        this.errorReporter = errorReporter;
        this.transformManager = transformManager;
        this.variantData = variantData;
        this.variantPublishingSpec = VariantPublishingSpec.getVariantSpec(variantData.getType());
        ProjectOptions projectOptions = globalScope.getProjectOptions();
        this.instantRunBuildContext = new InstantRunBuildContext(variantData.getVariantConfiguration().isInstantRunBuild(globalScope), DeploymentDevice.getDeploymentDeviceAndroidVersion(projectOptions), projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI), projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY));
        this.validatePostprocessingOptions();
    }

    private void validatePostprocessingOptions() {
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        if (postprocessingOptions == null) {
            return;
        }
        if (postprocessingOptions.getCodeShrinkerEnum() == CodeShrinker.ANDROID_GRADLE) {
            if (postprocessingOptions.isObfuscate()) {
                this.errorReporter.handleSyncError(null, 0, "The 'android-gradle' code shrinker does not support obfuscating.");
            }
            if (postprocessingOptions.isOptimizeCode()) {
                this.errorReporter.handleSyncError(null, 0, "The 'android-gradle' code shrinker does not support optimizing code.");
            }
        }
    }

    @Override
    protected Project getProject() {
        return this.globalScope.getProject();
    }

    @Override
    public VariantPublishingSpec getPublishingSpec() {
        return this.variantPublishingSpec;
    }

    @Override
    public ConfigurableFileCollection addTaskOutput(TaskOutputHolder.TaskOutputType outputType, File file, String taskName) {
        ConfigurableFileCollection fileCollection;
        try {
            fileCollection = super.addTaskOutput(outputType, file, taskName);
        }
        catch (TaskOutputAlreadyRegisteredException e) {
            throw new RuntimeException(String.format("OutputType '%s' already registered for variant '%s'", e.getOutputType(), this.getFullVariantName()), e);
        }
        VariantPublishingSpec.OutputPublishingSpec taskSpec = this.variantPublishingSpec.getSpec(outputType);
        if (taskSpec != null) {
            this.publishIntermediateArtifact(file, taskName, taskSpec.getArtifactType(), taskSpec.getPublishedConfigTypes());
        }
        return fileCollection;
    }

    @Override
    public FileCollection getOutput(TaskOutputHolder.OutputType outputType) throws MissingTaskOutputException {
        try {
            return super.getOutput(outputType);
        }
        catch (MissingTaskOutputException e) {
            throw new RuntimeException(String.format("Variant '%s' has no output with type '%s'", this.getFullVariantName(), e.getOutputType()), e);
        }
    }

    private void publishIntermediateArtifact(File file, String builtBy, AndroidArtifacts.ArtifactType artifactType, Collection<AndroidArtifacts.PublishedConfigType> configTypes) {
        Preconditions.checkState((!configTypes.isEmpty() ? 1 : 0) != 0);
        VariantDependencies.PublishedConfigurations publishConfiguration = this.getVariantData().getVariantDependency().getSinglePublishConfiguration();
        if (configTypes.contains((Object)AndroidArtifacts.PublishedConfigType.API_ELEMENTS)) {
            this.publishArtifactToConfiguration(publishConfiguration.getApiElements(), file, builtBy, artifactType);
        }
        if (configTypes.contains((Object)AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS)) {
            this.publishArtifactToConfiguration(publishConfiguration.getRuntimeElements(), file, builtBy, artifactType);
        }
        if (configTypes.contains((Object)AndroidArtifacts.PublishedConfigType.METADATA_ELEMENTS) && publishConfiguration.getMetadataElements() != null) {
            this.publishArtifactToConfiguration(publishConfiguration.getMetadataElements(), file, builtBy, artifactType);
        }
    }

    private void publishArtifactToConfiguration(Configuration configuration, File file, String builtBy, AndroidArtifacts.ArtifactType artifactType) {
        Project project = this.getGlobalScope().getProject();
        String type = artifactType.getType();
        configuration.getOutgoing().variants(variants -> variants.create(type, variant -> variant.artifact((Object)file, artifact -> {
            artifact.setType(type);
            artifact.builtBy(new Object[]{project.getTasks().getByName(builtBy)});
        })));
    }

    @Override
    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @Override
    public BaseVariantData getVariantData() {
        return this.variantData;
    }

    @Override
    public GradleVariantConfiguration getVariantConfiguration() {
        return this.variantData.getVariantConfiguration();
    }

    @Override
    public String getFullVariantName() {
        return this.getVariantConfiguration().getFullName();
    }

    private PostprocessingOptions getPostprocessingOptionsIfUsed() {
        BuildType dslBuildType;
        CoreBuildType coreBuildType = this.getCoreBuildType();
        if (coreBuildType instanceof BuildType && (dslBuildType = (BuildType)coreBuildType).getPostprocessingConfiguration() == BuildType.PostprocessingConfiguration.POSTPROCESSING_BLOCK) {
            return dslBuildType.getPostprocessing();
        }
        return null;
    }

    private CoreBuildType getCoreBuildType() {
        return (CoreBuildType)this.getVariantConfiguration().getBuildType();
    }

    @Override
    public boolean useResourceShrinker() {
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        boolean userEnabledShrinkResources = postprocessingOptions != null ? postprocessingOptions.isRemoveUnusedResources() : this.getCoreBuildType().isShrinkResources();
        if (!userEnabledShrinkResources) {
            return false;
        }
        if (this.getCodeShrinker() == null) {
            this.errorReporter.handleSyncError(null, 0, "Removing unused resources requires unused code shrinking to be turned on. See http://d.android.com/r/tools/shrink-resources.html for more information.");
            return false;
        }
        if (this.getInstantRunBuildContext().isInInstantRunMode()) {
            LOGGER.warning("Instant Run: Resource shrinker automatically disabled for %s.", new Object[]{this.getVariantConfiguration().getFullName()});
            return false;
        }
        return true;
    }

    @Override
    public File getResourceShrinkerInputFolder() {
        if (!this.useResourceShrinker()) {
            return null;
        }
        return new File(this.globalScope.getIntermediatesDir() + "/resource-shrinker-in/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public CodeShrinker getCodeShrinker() {
        if (this.getVariantConfiguration().getType().isForTesting() && this.getTestedVariantData().getType() == VariantType.LIBRARY) {
            return null;
        }
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        if (postprocessingOptions == null) {
            CoreBuildType coreBuildType = this.getCoreBuildType();
            if (!coreBuildType.isMinifyEnabled()) {
                return null;
            }
            Boolean useProguard = coreBuildType.isUseProguard();
            if (useProguard == null) {
                return this.getDefaultCodeShrinker();
            }
            return useProguard != false ? CodeShrinker.PROGUARD : CodeShrinker.ANDROID_GRADLE;
        }
        CodeShrinker chosenShrinker = (CodeShrinker)((Object)MoreObjects.firstNonNull((Object)((Object)postprocessingOptions.getCodeShrinkerEnum()), (Object)((Object)this.getDefaultCodeShrinker())));
        switch (chosenShrinker) {
            case PROGUARD: {
                boolean somethingToDo = postprocessingOptions.isRemoveUnusedCode() || postprocessingOptions.isObfuscate() || postprocessingOptions.isOptimizeCode();
                return somethingToDo ? CodeShrinker.PROGUARD : null;
            }
            case ANDROID_GRADLE: {
                return postprocessingOptions.isRemoveUnusedCode() ? CodeShrinker.ANDROID_GRADLE : null;
            }
        }
        throw new AssertionError((Object)("Unknown value " + (Object)((Object)chosenShrinker)));
    }

    @Override
    public List<File> getProguardFiles() {
        List<File> result = this.gatherProguardFiles(PostprocessingOptions::getProguardFiles, BaseConfig::getProguardFiles);
        if (this.getPostprocessingOptionsIfUsed() == null && result.isEmpty()) {
            result.add(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.DONT_OPTIMIZE.fileName, this.getProject()));
        }
        return result;
    }

    @Override
    public List<File> getTestProguardFiles() {
        return this.gatherProguardFiles(PostprocessingOptions::getTestProguardFiles, BaseConfig::getTestProguardFiles);
    }

    @Override
    public List<File> getConsumerProguardFiles() {
        return this.gatherProguardFiles(PostprocessingOptions::getConsumerProguardFiles, BaseConfig::getConsumerProguardFiles);
    }

    private List<File> gatherProguardFiles(Function<PostprocessingOptions, List<File>> postprocessingGetter, Function<BaseConfig, Collection<File>> baseConfigGetter) {
        ArrayList<File> result = new ArrayList<File>();
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        if (postprocessingOptions == null) {
            GradleVariantConfiguration variantConfiguration = this.getVariantConfiguration();
            result.addAll(baseConfigGetter.apply((BaseConfig)variantConfiguration.getDefaultConfig()));
            result.addAll(baseConfigGetter.apply((BaseConfig)variantConfiguration.getBuildType()));
            for (CoreProductFlavor flavor : variantConfiguration.getProductFlavors()) {
                result.addAll(baseConfigGetter.apply((BaseConfig)flavor));
            }
        } else {
            result.addAll((Collection)postprocessingGetter.apply(postprocessingOptions));
        }
        return result;
    }

    @Override
    public PostprocessingActions getPostprocessingActions() {
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        if (postprocessingOptions != null) {
            return PostprocessingActions.create(postprocessingOptions.isRemoveUnusedCode(), postprocessingOptions.isObfuscate(), postprocessingOptions.isOptimizeCode());
        }
        return null;
    }

    private CodeShrinker getDefaultCodeShrinker() {
        return this.getInstantRunBuildContext().isInInstantRunMode() ? CodeShrinker.ANDROID_GRADLE : CodeShrinker.PROGUARD;
    }

    @Override
    public boolean isTestOnly() {
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        Boolean isTestOnlyOverride = projectOptions.get(OptionalBooleanOption.IDE_TEST_ONLY);
        if (isTestOnlyOverride != null) {
            return isTestOnlyOverride;
        }
        return !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) || !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY)) || projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API) != null || this.globalScope.getAndroidBuilder().isPreviewTarget() || this.getMinSdkVersion().getCodename() != null || this.getVariantConfiguration().getTargetSdkVersion().getCodename() != null;
    }

    @Override
    public boolean isBaseFeature() {
        return this.globalScope.getExtension().getBaseFeature();
    }

    @Override
    public DexingType getDexingType() {
        DexingType dexingType = this.variantData.getVariantConfiguration().getDexingType();
        if (this.variantData.getType().isForTesting() && this.getTestedVariantData() != null && this.getTestedVariantData().getType() != VariantType.LIBRARY && dexingType == DexingType.LEGACY_MULTIDEX) {
            return DexingType.MONO_DEX;
        }
        if (this.isInstantRunDexingTypeOverride()) {
            return DexingType.NATIVE_MULTIDEX;
        }
        return dexingType;
    }

    private boolean isInstantRunDexingTypeOverride() {
        return this.getInstantRunBuildContext().isInInstantRunMode() && this.getInstantRunBuildContext().getPatchingPolicy() == InstantRunPatchingPolicy.MULTI_APK;
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        return this.getVariantConfiguration().getMinSdkVersion();
    }

    @Override
    public String getDirName() {
        return this.variantData.getVariantConfiguration().getDirName();
    }

    @Override
    public Collection<String> getDirectorySegments() {
        return this.variantData.getVariantConfiguration().getDirectorySegments();
    }

    @Override
    public TransformManager getTransformManager() {
        return this.transformManager;
    }

    @Override
    public String getTaskName(String prefix) {
        return this.getTaskName(prefix, "");
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return this.variantData.getTaskName(prefix, suffix);
    }

    @Override
    public Collection<Object> getNdkBuildable() {
        return this.ndkBuildable;
    }

    @Override
    public void setNdkBuildable(Collection<Object> ndkBuildable) {
        this.ndkBuildable = ndkBuildable;
    }

    @Override
    public AndroidTask<DataBindingProcessLayoutsTask> getDataBindingProcessLayoutsTask() {
        return this.dataBindingProcessLayoutsTask;
    }

    @Override
    public void setDataBindingProcessLayoutsTask(AndroidTask<DataBindingProcessLayoutsTask> dataBindingProcessLayoutsTask) {
        this.dataBindingProcessLayoutsTask = dataBindingProcessLayoutsTask;
    }

    @Override
    public Collection<File> getNdkSoFolder() {
        return this.ndkSoFolder;
    }

    @Override
    public void setNdkSoFolder(Collection<File> ndkSoFolder) {
        this.ndkSoFolder = ndkSoFolder;
    }

    @Override
    public File getNdkObjFolder() {
        return this.ndkObjFolder;
    }

    @Override
    public void setNdkObjFolder(File ndkObjFolder) {
        this.ndkObjFolder = ndkObjFolder;
    }

    @Override
    public File getNdkDebuggableLibraryFolders(Abi abi) {
        return this.ndkDebuggableLibraryFolders.get((Object)abi);
    }

    @Override
    public void addNdkDebuggableLibraryFolders(Abi abi, File searchPath) {
        this.ndkDebuggableLibraryFolders.put(abi, searchPath);
    }

    @Override
    public BaseVariantData getTestedVariantData() {
        return this.variantData instanceof TestVariantData ? (BaseVariantData)((Object)((TestVariantData)this.variantData).getTestedVariantData()) : null;
    }

    @Override
    public File getBuildInfoOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/build-info/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getReloadDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/reload-dex/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRestartDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/restart-dex/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunSplitApkOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/split-apk/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunPastIterationsFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/builds/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public FileCollection getJavaClasspath(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType) {
        return this.getJavaClasspath(configType, classesType, null);
    }

    @Override
    public FileCollection getJavaClasspath(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType, Object generatedBytecodeKey) {
        FileCollection mainCollection = this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, classesType);
        return mainCollection.plus(this.getVariantData().getGeneratedBytecode(generatedBytecodeKey));
    }

    @Override
    public ArtifactCollection getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType, Object generatedBytecodeKey) {
        ArtifactCollection mainCollection = this.getArtifactCollection(configType, AndroidArtifacts.ArtifactScope.ALL, classesType);
        return ArtifactCollectionWithExtraArtifact.makeExtraCollection(mainCollection, this.getVariantData().getGeneratedBytecode(generatedBytecodeKey), this.getProject().getPath());
    }

    @Override
    public boolean keepDefaultBootstrap() {
        if (!JavaVersion.current().isJava8Compatible()) {
            return false;
        }
        VariantScope.Java8LangSupport java8LangSupport = this.getJava8LangSupportType();
        return java8LangSupport == VariantScope.Java8LangSupport.DESUGAR;
    }

    @Override
    public File getJavaOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/classes/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunSupportDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/instant-run-support/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunSliceSupportDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/instant-run-slices/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getIncrementalRuntimeSupportJar() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-runtime-classes/" + this.variantData.getVariantConfiguration().getDirName() + "/instant-run.jar");
    }

    @Override
    public File getIncrementalApplicationSupportDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-classes/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunResourcesFile() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"instant-run-resources", "resources-" + this.variantData.getVariantConfiguration().getDirName() + ".ir.ap_"});
    }

    @Override
    public File getIncrementalVerifierDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-verifier/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public FileCollection getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        ArtifactView artifactView = this.getArtifactView(configType, scope, artifactType);
        if (configType.needsTestedComponents()) {
            return this.handleTestedComponent(artifactView.getFiles(), configType, scope, artifactType, (mainCollection, testedCollection, unused) -> mainCollection.plus(testedCollection), (collection, artifactView1) -> collection.minus(artifactView1.getFiles()));
        }
        return artifactView.getFiles();
    }

    @Override
    public ArtifactCollection getArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        ArtifactView artifactView = this.getArtifactView(configType, scope, artifactType);
        if (configType.needsTestedComponents()) {
            return this.handleTestedComponent(artifactView.getArtifacts(), configType, scope, artifactType, (artifactResults, collection, variantName) -> ArtifactCollectionWithExtraArtifact.makeExtraCollectionForTest(artifactResults, collection, this.getProject().getPath(), variantName), (artifactResults, artifactView1) -> new SubtractingArtifactCollection((ArtifactCollection)artifactResults, artifactView1.getArtifacts()));
        }
        return artifactView.getArtifacts();
    }

    @Override
    public ArtifactView getArtifactView(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        Configuration configuration;
        switch (configType) {
            case COMPILE_CLASSPATH: {
                configuration = this.getVariantData().getVariantDependency().getCompileClasspath();
                break;
            }
            case RUNTIME_CLASSPATH: {
                configuration = this.getVariantData().getVariantDependency().getRuntimeClasspath();
                break;
            }
            case ANNOTATION_PROCESSOR: {
                configuration = this.getVariantData().getVariantDependency().getAnnotationProcessorConfiguration();
                break;
            }
            case METADATA_VALUES: {
                configuration = this.getVariantData().getVariantDependency().getMetadataValuesConfiguration();
                break;
            }
            default: {
                throw new RuntimeException("unknown ConfigType value");
            }
        }
        Action attributes = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)artifactType.getType());
        Spec<ComponentIdentifier> filter = VariantScopeImpl.getComponentFilter(scope);
        boolean lenientMode = Boolean.TRUE.equals(this.globalScope.getProjectOptions().get(BooleanOption.IDE_BUILD_MODEL_ONLY));
        return configuration.getIncoming().artifactView(config -> {
            config.attributes(attributes);
            if (filter != null) {
                config.componentFilter(filter);
            }
            config.lenient(lenientMode);
        });
    }

    private static Spec<ComponentIdentifier> getComponentFilter(AndroidArtifacts.ArtifactScope scope) {
        switch (scope) {
            case ALL: {
                return null;
            }
            case EXTERNAL: {
                return id -> !(id instanceof ProjectComponentIdentifier);
            }
            case MODULE: {
                return id -> id instanceof ProjectComponentIdentifier;
            }
        }
        throw new RuntimeException("unknown ArtifactScope value");
    }

    @Override
    public Supplier<Collection<File>> getLocalPackagedJars() {
        return TaskInputHelper.bypassFileSupplier(VariantScopeImpl.getLocalJarLambda(this.getVariantData().getVariantDependency().getRuntimeClasspath()));
    }

    @Override
    public FileCollection getProvidedOnlyClasspath() {
        FileCollection compile = this.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
        FileCollection pkg = this.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
        return compile.minus(pkg);
    }

    @Override
    public File getIntermediateJarOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/intermediate-jars/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getProguardComponentsJarFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/componentClasses.jar");
    }

    @Override
    public File getManifestKeepListProguardFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/manifest_keep.txt");
    }

    @Override
    public File getMainDexListFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/maindexlist.txt");
    }

    @Override
    public File getRenderscriptSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/rs/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRenderscriptLibOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "rs/" + this.variantData.getVariantConfiguration().getDirName() + "/lib");
    }

    @Override
    public File getFinalResourcesDir() {
        return (File)Objects.firstNonNull((Object)this.resourceOutputDir, (Object)this.getDefaultMergeResourcesOutputDir());
    }

    @Override
    public void setResourceOutputDir(File resourceOutputDir) {
        this.resourceOutputDir = resourceOutputDir;
    }

    @Override
    public File getDefaultMergeResourcesOutputDir() {
        return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"res", "merged", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getMergeResourcesOutputDir() {
        if (this.mergeResourceOutputDir == null) {
            return this.getDefaultMergeResourcesOutputDir();
        }
        return this.mergeResourceOutputDir;
    }

    @Override
    public void setMergeResourceOutputDir(File mergeResourceOutputDir) {
        this.mergeResourceOutputDir = mergeResourceOutputDir;
    }

    @Override
    public File getResourceBlameLogDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"blame", "res", this.getDirectorySegments()}));
    }

    @Override
    public File getMergeNativeLibsOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"/jniLibs/" + this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getMergeShadersOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"/shaders/" + this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getBuildConfigSourceOutputDir() {
        return new File(this.globalScope.getBuildDir() + "/" + "generated" + "/source/buildConfig/" + this.variantData.getVariantConfiguration().getDirName());
    }

    private File getGeneratedResourcesDir(String name) {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"res", name, this.getDirectorySegments()}));
    }

    private File getGeneratedAssetsDir(String name) {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"assets", name, this.getDirectorySegments()}));
    }

    @Override
    public File getGeneratedResOutputDir() {
        return this.getGeneratedResourcesDir("resValues");
    }

    @Override
    public File getGeneratedPngsOutputDir() {
        return this.getGeneratedResourcesDir("pngs");
    }

    @Override
    public File getRenderscriptResOutputDir() {
        return this.getGeneratedResourcesDir("rs");
    }

    @Override
    public File getRenderscriptObjOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"rs", this.getDirectorySegments(), "obj"}));
    }

    @Override
    public File getShadersOutputDir() {
        return this.getGeneratedAssetsDir("shaders");
    }

    @Override
    public File getSourceFoldersJavaResDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "sourceFolderJavaResources/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getJavaResourcesDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "javaResources/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getGeneratedJavaResourcesDir() {
        return new File(this.globalScope.getGeneratedDir(), "javaResources/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRClassSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/r/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getAidlSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/aidl/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getIncrementalDir(String name) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"incremental", name});
    }

    @Override
    public File getPackagedAidlDir() {
        return new File(this.getBaseBundleDir(), "aidl");
    }

    @Override
    public File getTypedefFile() {
        return new File(this.globalScope.getIntermediatesDir(), "typedefs.txt");
    }

    @Override
    public File getCoverageReportDir() {
        return new File(this.globalScope.getReportsDir(), "coverage/" + this.getDirName());
    }

    @Override
    public File getClassOutputForDataBinding() {
        return new File(this.globalScope.getGeneratedDir(), "source/dataBinding/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getLayoutInfoOutputForDataBinding() {
        return new File(this.globalScope.getIntermediatesDir() + "/data-binding-info/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getLayoutFolderOutputForDataBinding() {
        return new File(this.globalScope.getIntermediatesDir() + "/data-binding-layout-out/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getLayoutInputFolderForDataBinding() {
        return new File(this.globalScope.getIntermediatesDir() + "/data-binding-layout-in/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getBuildFolderForDataBindingCompiler() {
        return new File(this.globalScope.getIntermediatesDir() + "/data-binding-compiler/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getGeneratedClassListOutputFileForDataBinding() {
        return new File(this.getLayoutInfoOutputForDataBinding(), "_generated.txt");
    }

    @Override
    public File getBundleFolderForDataBinding() {
        return new File(this.getBaseBundleDir(), "data-binding");
    }

    @Override
    public File getProguardOutputFolder() {
        return new File(this.globalScope.getBuildDir(), "/outputs/mapping/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getProcessAndroidResourcesProguardOutputFile() {
        return new File(this.globalScope.getIntermediatesDir(), "/proguard-rules/" + this.getVariantConfiguration().getDirName() + "/aapt_rules.txt");
    }

    @Override
    public File getGenerateSplitAbiResOutputDirectory() {
        return new File(this.globalScope.getIntermediatesDir(), FileUtils.join((String[])new String[]{"splits", "res", "abi", this.getVariantConfiguration().getDirName()}));
    }

    @Override
    public File getSplitSupportDirectory() {
        return new File(this.globalScope.getIntermediatesDir(), "splits-support/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getSplitDensityOrLanguagesPackagesOutputDirectory() {
        return new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"outputs", "splits", "densityLanguage", this.getVariantConfiguration().getDirName()}));
    }

    @Override
    public File getSplitAbiPackagesOutputDirectory() {
        return new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"outputs", "splits", "abi", this.getVariantConfiguration().getDirName()}));
    }

    @Override
    public File getFullApkPackagesOutputDirectory() {
        return new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"outputs", "splits", "full", this.getVariantConfiguration().getDirName()}));
    }

    @Override
    public File getAaptFriendlyManifestOutputDirectory() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifests", "aapt", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getInstantRunManifestOutputDirectory() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifests", "instant-run", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getShrunkProcessedResourcesOutputDirectory() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res_stripped", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getManifestReportFile() {
        return FileUtils.join((File)this.getGlobalScope().getOutputsDir(), (String[])new String[]{"logs", "manifest-merger-" + this.variantData.getVariantConfiguration().getBaseName() + "-report.txt"});
    }

    @Override
    public File getMicroApkManifestFile() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"manifests", "microapk", this.getVariantConfiguration().getDirName(), "AndroidManifest.xml"});
    }

    @Override
    public File getMicroApkResDirectory() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"res", "microapk", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getCompatibleScreensManifestDirectory() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifests", "density", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getManifestOutputDirectory() {
        switch (this.getVariantConfiguration().getType()) {
            case DEFAULT: 
            case FEATURE: {
                return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"manifests", "full", this.getVariantConfiguration().getDirName()});
            }
            case LIBRARY: {
                return this.getBaseBundleDir();
            }
            case ANDROID_TEST: {
                return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"manifest", this.getVariantConfiguration().getDirName()});
            }
        }
        throw new RuntimeException("getManifestOutputFile called for an unexpected variant.");
    }

    @Override
    public File getApkLocation() {
        String override = this.globalScope.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
        File baseDirectory = override != null && this.variantData.getType() != VariantType.FEATURE ? this.globalScope.getProject().file((Object)override) : this.getDefaultApkLocation();
        return new File(baseDirectory, this.getVariantConfiguration().getDirName());
    }

    private File getDefaultApkLocation() {
        return FileUtils.join((File)this.globalScope.getBuildDir(), (String[])new String[]{"outputs", "apk"});
    }

    @Override
    public AndroidTask<? extends ManifestProcessorTask> getManifestProcessorTask() {
        return this.manifestProcessorTask;
    }

    @Override
    public void setManifestProcessorTask(AndroidTask<? extends ManifestProcessorTask> manifestProcessorTask) {
        this.manifestProcessorTask = manifestProcessorTask;
    }

    @Override
    public File getBaseBundleDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"bundles", this.getVariantConfiguration().getFullName()});
    }

    @Override
    public File getOutputBundleFile() {
        return FileUtils.join((File)this.globalScope.getOutputsDir(), (String[])new String[]{"aar", this.globalScope.getProjectBaseName() + "-" + this.getVariantConfiguration().getBaseName() + "." + "aar"});
    }

    @Override
    public File getAnnotationProcessorOutputDir() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"source", "apt", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getMainJarOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"packaged", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public AndroidTask<DefaultTask> getAssembleTask() {
        return this.assembleTask;
    }

    @Override
    public void setAssembleTask(AndroidTask<DefaultTask> assembleTask) {
        this.assembleTask = assembleTask;
    }

    @Override
    public AndroidTask<? extends DefaultTask> getPreBuildTask() {
        return this.preBuildTask;
    }

    @Override
    public void setPreBuildTask(AndroidTask<? extends DefaultTask> preBuildTask) {
        this.preBuildTask = preBuildTask;
    }

    @Override
    public AndroidTask<Task> getSourceGenTask() {
        return this.sourceGenTask;
    }

    @Override
    public void setSourceGenTask(AndroidTask<Task> sourceGenTask) {
        this.sourceGenTask = sourceGenTask;
    }

    @Override
    public AndroidTask<Task> getResourceGenTask() {
        return this.resourceGenTask;
    }

    @Override
    public void setResourceGenTask(AndroidTask<Task> resourceGenTask) {
        this.resourceGenTask = resourceGenTask;
    }

    @Override
    public AndroidTask<Task> getAssetGenTask() {
        return this.assetGenTask;
    }

    @Override
    public void setAssetGenTask(AndroidTask<Task> assetGenTask) {
        this.assetGenTask = assetGenTask;
    }

    @Override
    public AndroidTask<CheckManifest> getCheckManifestTask() {
        return this.checkManifestTask;
    }

    @Override
    public void setCheckManifestTask(AndroidTask<CheckManifest> checkManifestTask) {
        this.checkManifestTask = checkManifestTask;
    }

    @Override
    public AndroidTask<RenderscriptCompile> getRenderscriptCompileTask() {
        return this.renderscriptCompileTask;
    }

    @Override
    public void setRenderscriptCompileTask(AndroidTask<RenderscriptCompile> renderscriptCompileTask) {
        this.renderscriptCompileTask = renderscriptCompileTask;
    }

    @Override
    public AndroidTask<AidlCompile> getAidlCompileTask() {
        return this.aidlCompileTask;
    }

    @Override
    public void setAidlCompileTask(AndroidTask<AidlCompile> aidlCompileTask) {
        this.aidlCompileTask = aidlCompileTask;
    }

    @Override
    public AndroidTask<MergeResources> getMergeResourcesTask() {
        return this.mergeResourcesTask;
    }

    @Override
    public void setMergeResourcesTask(AndroidTask<MergeResources> mergeResourcesTask) {
        this.mergeResourcesTask = mergeResourcesTask;
    }

    @Override
    public AndroidTask<MergeSourceSetFolders> getMergeAssetsTask() {
        return this.mergeAssetsTask;
    }

    @Override
    public void setMergeAssetsTask(AndroidTask<MergeSourceSetFolders> mergeAssetsTask) {
        this.mergeAssetsTask = mergeAssetsTask;
    }

    @Override
    public AndroidTask<GenerateBuildConfig> getGenerateBuildConfigTask() {
        return this.generateBuildConfigTask;
    }

    @Override
    public void setGenerateBuildConfigTask(AndroidTask<GenerateBuildConfig> generateBuildConfigTask) {
        this.generateBuildConfigTask = generateBuildConfigTask;
    }

    @Override
    public AndroidTask<Sync> getProcessJavaResourcesTask() {
        return this.processJavaResourcesTask;
    }

    @Override
    public void setProcessJavaResourcesTask(AndroidTask<Sync> processJavaResourcesTask) {
        this.processJavaResourcesTask = processJavaResourcesTask;
    }

    @Override
    public void setMergeJavaResourcesTask(AndroidTask<TransformTask> mergeJavaResourcesTask) {
        this.mergeJavaResourcesTask = mergeJavaResourcesTask;
    }

    @Override
    public AndroidTask<TransformTask> getMergeJavaResourcesTask() {
        return this.mergeJavaResourcesTask;
    }

    @Override
    public AndroidTask<? extends JavaCompile> getJavacTask() {
        return this.javacTask;
    }

    @Override
    public void setJavacTask(AndroidTask<? extends JavaCompile> javacTask) {
        this.javacTask = javacTask;
    }

    @Override
    public AndroidTask<Task> getCompileTask() {
        return this.compileTask;
    }

    @Override
    public void setCompileTask(AndroidTask<Task> compileTask) {
        this.compileTask = compileTask;
    }

    @Override
    public AndroidTask<GenerateApkDataTask> getMicroApkTask() {
        return this.microApkTask;
    }

    @Override
    public void setMicroApkTask(AndroidTask<GenerateApkDataTask> microApkTask) {
        this.microApkTask = microApkTask;
    }

    @Override
    public AndroidTask<?> getCoverageReportTask() {
        return this.coverageReportTask;
    }

    @Override
    public void setCoverageReportTask(AndroidTask<?> coverageReportTask) {
        this.coverageReportTask = coverageReportTask;
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.instantRunBuildContext;
    }

    @Override
    public ImmutableList<File> getInstantRunBootClasspath() {
        SdkHandler sdkHandler = this.getGlobalScope().getSdkHandler();
        AndroidBuilder androidBuilder = this.globalScope.getAndroidBuilder();
        IAndroidTarget androidBuilderTarget = androidBuilder.getTarget();
        File annotationsJar = sdkHandler.getSdkLoader().getSdkInfo(LOGGER).getAnnotationsJar();
        AndroidVersion targetDeviceVersion = DeploymentDevice.getDeploymentDeviceAndroidVersion(this.getGlobalScope().getProjectOptions());
        if (targetDeviceVersion.equals((Object)androidBuilderTarget.getVersion())) {
            return BootClasspathBuilder.computeFullBootClasspath((IAndroidTarget)androidBuilderTarget, (File)annotationsJar);
        }
        IAndroidTarget targetToUse = VariantScopeImpl.getAndroidTarget(sdkHandler, AndroidTargetHash.getPlatformHashString((AndroidVersion)targetDeviceVersion));
        if (targetToUse == null) {
            throw new RuntimeException(String.format("In order to use Instant Run with this device running %1$S, you must install platform %1$S in your SDK", targetDeviceVersion.toString()));
        }
        return BootClasspathBuilder.computeFullBootClasspath((IAndroidTarget)targetToUse, (File)annotationsJar);
    }

    private static IAndroidTarget getAndroidTarget(SdkHandler sdkHandler, String targetHash) {
        File sdkLocation = sdkHandler.getSdkFolder();
        LoggerProgressIndicatorWrapper progressIndicator = new LoggerProgressIndicatorWrapper(LOGGER);
        IAndroidTarget target = AndroidSdkHandler.getInstance((File)sdkLocation).getAndroidTargetManager((ProgressIndicator)progressIndicator).getTargetFromHashString(targetHash, (ProgressIndicator)progressIndicator);
        if (target != null) {
            return target;
        }
        AndroidSdkHandler.resetInstance((File)sdkLocation);
        return AndroidSdkHandler.getInstance((File)sdkLocation).getAndroidTargetManager((ProgressIndicator)progressIndicator).getTargetFromHashString(targetHash, (ProgressIndicator)progressIndicator);
    }

    @Override
    public void setExternalNativeBuildTask(AndroidTask<ExternalNativeBuildTask> task) {
        this.externalNativeBuild = task;
    }

    @Override
    public ExternalNativeJsonGenerator getExternalNativeJsonGenerator() {
        return this.externalNativeJsonGenerator;
    }

    @Override
    public void setExternalNativeJsonGenerator(ExternalNativeJsonGenerator generator) {
        Preconditions.checkState((this.externalNativeJsonGenerator == null ? 1 : 0) != 0, (Object)"Unexpected overwrite of externalNativeJsonGenerator may result in information loss");
        this.externalNativeJsonGenerator = generator;
    }

    @Override
    public AndroidTask<ExternalNativeBuildTask> getExternalNativeBuildTask() {
        return this.externalNativeBuild;
    }

    public List<NativeBuildConfigValue> getExternalNativeBuildConfigValues() {
        return this.externalNativeBuildConfigValues;
    }

    @Override
    public void addExternalNativeBuildConfigValues(Collection<NativeBuildConfigValue> values) {
        this.externalNativeBuildConfigValues.addAll(values);
    }

    @Override
    public InstantRunTaskManager getInstantRunTaskManager() {
        return this.instantRunTaskManager;
    }

    @Override
    public void setInstantRunTaskManager(InstantRunTaskManager instantRunTaskManager) {
        this.instantRunTaskManager = instantRunTaskManager;
    }

    @Override
    public TransformVariantScope getTransformVariantScope() {
        return this;
    }

    private <T> T handleTestedComponent(T collection, AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope artifactScope, AndroidArtifacts.ArtifactType artifactType, TriFunction<T, FileCollection, String, T> plusFunction, BiFunction<T, ArtifactView, T> minusFunction) {
        VariantType variantType = this.getVariantConfiguration().getType();
        if (!variantType.isForTesting()) {
            return collection;
        }
        T result = collection;
        if (this.variantData instanceof TestVariantData) {
            TaskOutputHolder.OutputType taskOutputType;
            Collection<AndroidArtifacts.PublishedConfigType> publishedConfigs;
            VariantPublishingSpec testedSpec;
            VariantPublishingSpec.OutputPublishingSpec taskOutputSpec;
            TestedVariantData tested = ((TestVariantData)this.variantData).getTestedVariantData();
            VariantScope testedScope = tested.getScope();
            if ((artifactScope == AndroidArtifacts.ArtifactScope.MODULE || artifactScope == AndroidArtifacts.ArtifactScope.ALL) && (taskOutputSpec = (testedSpec = testedScope.getPublishingSpec().getTestingSpec(variantType)).getSpec(artifactType)) != null && (publishedConfigs = taskOutputSpec.getPublishedConfigTypes()).contains((Object)configType.getPublishedTo()) && testedScope.hasOutput(taskOutputType = taskOutputSpec.getOutputType())) {
                result = plusFunction.apply(result, testedScope.getOutput(taskOutputType), testedScope.getFullVariantName());
            }
            if (tested instanceof ApplicationVariantData && configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && variantType == VariantType.ANDROID_TEST) {
                result = minusFunction.apply(result, testedScope.getArtifactView(configType, artifactScope, artifactType));
            }
        }
        return result;
    }

    private static Supplier<Collection<File>> getLocalJarLambda(Configuration configuration) {
        return () -> {
            ArrayList files = new ArrayList();
            for (Dependency dependency : configuration.getAllDependencies()) {
                if (!(dependency instanceof SelfResolvingDependency) || dependency instanceof ProjectDependency) continue;
                files.addAll(((SelfResolvingDependency)dependency).resolve());
            }
            return files;
        };
    }

    @Override
    public File getProcessResourcePackageOutputDirectory() {
        return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"res", this.getDirName()});
    }

    @Override
    public void setProcessResourcesTask(AndroidTask<ProcessAndroidResources> processAndroidResourcesAndroidTask) {
        this.processAndroidResourcesTask = processAndroidResourcesAndroidTask;
    }

    @Override
    public AndroidTask<ProcessAndroidResources> getProcessResourcesTask() {
        return this.processAndroidResourcesTask;
    }

    @Override
    public void setDataBindingExportBuildInfoTask(AndroidTask<DataBindingExportBuildInfoTask> task) {
        this.dataBindingExportBuildInfoTask = task;
    }

    @Override
    public AndroidTask<DataBindingExportBuildInfoTask> getDataBindingExportBuildInfoTask() {
        return this.dataBindingExportBuildInfoTask;
    }

    @Override
    public SplitScope getSplitScope() {
        return this.variantData.getSplitScope();
    }

    @Override
    public VariantDependencies getVariantDependencies() {
        return this.variantData.getVariantDependency();
    }

    @Override
    public VariantScope.Java8LangSupport getJava8LangSupportType() {
        if (!this.getGlobalScope().getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
            return VariantScope.Java8LangSupport.UNUSED;
        }
        if (this.globalScope.getProject().getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            return VariantScope.Java8LangSupport.RETROLAMBDA;
        }
        if (this.globalScope.getProject().getPlugins().hasPlugin("dexguard")) {
            return VariantScope.Java8LangSupport.DEXGUARD;
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DESUGAR)) {
            return VariantScope.Java8LangSupport.DESUGAR;
        }
        this.errorReporter.handleSyncError(this.getVariantConfiguration().getFullName(), 0, "Please add 'android.enableDesugar=true' to your gradle.properties file to enable Java 8 language support.");
        return VariantScope.Java8LangSupport.INVALID;
    }

    @Override
    public ConfigurableFileCollection getTryWithResourceRuntimeSupportJar() {
        if (this.desugarTryWithResourcesRuntimeJar == null) {
            this.desugarTryWithResourcesRuntimeJar = this.getProject().files(new Object[]{FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"processing-tools", "runtime-deps", this.variantData.getVariantConfiguration().getDirName(), "desugar_try_with_resources.jar"})});
        }
        return this.desugarTryWithResourcesRuntimeJar;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getFullVariantName()).toString();
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

