/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.signing.KeytoolException;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

abstract class InstantRunSplitApkBuilder
extends Transform {
    protected final Logger logger;
    protected final Project project;
    private final AndroidBuilder androidBuilder;
    private final AaptGeneration aaptGeneration;
    private final InstantRunBuildContext buildContext;
    protected final File outputDirectory;
    private final CoreSigningConfig signingConf;
    private final PackagingScope packagingScope;
    private final AaptOptions aaptOptions;
    private final File supportDirectory;

    public InstantRunSplitApkBuilder(Logger logger, Project project, InstantRunBuildContext buildContext, AndroidBuilder androidBuilder, PackagingScope packagingScope, CoreSigningConfig signingConf, AaptGeneration aaptGeneration, AaptOptions aaptOptions, File outputDirectory, File supportDirectory) {
        this.logger = logger;
        this.project = project;
        this.buildContext = buildContext;
        this.androidBuilder = androidBuilder;
        this.packagingScope = packagingScope;
        this.signingConf = signingConf;
        this.aaptGeneration = aaptGeneration;
        this.aaptOptions = aaptOptions;
        this.outputDirectory = outputDirectory;
        this.supportDirectory = supportDirectory;
    }

    public final Map<String, Object> getParameterInputs() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"applicationId", (Object)this.packagingScope.getApplicationId()).put((Object)"versionCode", (Object)this.packagingScope.getVersionCode()).put((Object)"aaptGeneration", (Object)this.aaptGeneration.name());
        if (this.packagingScope.getVersionName() != null) {
            builder.put((Object)"versionName", (Object)this.packagingScope.getVersionName());
        }
        return builder.build();
    }

    protected File generateSplitApk(DexFiles dexFiles) throws IOException, KeytoolException, PackagerException, InterruptedException, ProcessException, TransformException {
        String uniqueName = dexFiles.encodeName();
        File alignedOutput = new File(this.outputDirectory, uniqueName + ".apk");
        Files.createParentDirs((File)alignedOutput);
        File resPackageFile = this.generateSplitApkManifest(uniqueName);
        File tempDir = new File(this.supportDirectory, "package_" + uniqueName);
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new TransformException("Cannot create temporary folder " + tempDir.getAbsolutePath());
        }
        FileUtils.cleanOutputDir((File)tempDir);
        this.androidBuilder.packageCodeSplitApk(resPackageFile, (Set)dexFiles.dexFiles, (SigningConfig)this.signingConf, alignedOutput, tempDir, ApkCreatorFactories.fromProjectProperties(this.project, true));
        this.buildContext.addChangedFile(FileType.SPLIT, alignedOutput);
        resPackageFile.delete();
        return alignedOutput;
    }

    private File generateSplitApkManifest(String uniqueName) throws IOException, ProcessException, InterruptedException {
        File apkSupportDir;
        String versionNameToUse = this.packagingScope.getVersionName();
        int versionCode = this.packagingScope.getVersionCode();
        if (versionNameToUse == null) {
            versionNameToUse = String.valueOf(versionCode);
        }
        if (!(apkSupportDir = new File(this.supportDirectory, uniqueName)).exists() && !apkSupportDir.mkdirs()) {
            this.logger.error("Cannot create apk support dir {}", (Object)apkSupportDir.getAbsoluteFile());
        }
        File androidManifest = new File(apkSupportDir, "AndroidManifest.xml");
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(androidManifest), "UTF-8");){
            fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n").append("      package=\"").append(this.packagingScope.getApplicationId()).append("\"\n");
            if (versionCode != -1) {
                fileWriter.append("      android:versionCode=\"").append(String.valueOf(versionCode)).append("\"\n").append("      android:versionName=\"").append(versionNameToUse).append("\"\n");
            }
            fileWriter.append("      split=\"lib_").append(uniqueName).append("_apk\">\n").append("</manifest>\n");
            fileWriter.flush();
        }
        File resFilePackageFile = new File(apkSupportDir, "resources_ap");
        AaptPackageConfig.Builder aaptConfig = new AaptPackageConfig.Builder().setManifestFile(androidManifest).setOptions(this.aaptOptions).setDebuggable(true).setVariantType(VariantType.DEFAULT).setResourceOutputApk(resFilePackageFile);
        this.androidBuilder.processResources(this.getAapt(), aaptConfig, false);
        return resFilePackageFile;
    }

    protected Aapt getAapt() {
        return InstantRunSplitApkBuilder.makeAapt(this.aaptGeneration, this.androidBuilder, this.packagingScope);
    }

    public static Aapt makeAapt(AaptGeneration aaptGeneration, AndroidBuilder androidBuilder, PackagingScope packagingScope) {
        return AaptGradleFactory.make(aaptGeneration, androidBuilder, true, FileUtils.mkdirs((File)new File(packagingScope.getIncrementalDir("instantRunDependenciesApkBuilder"), "aapt-temp")), 0);
    }

    protected static class DexFiles {
        private final ImmutableSet<File> dexFiles;
        private final String dexFolderName;

        protected DexFiles(File[] dexFiles, String dexFolderName) {
            this((ImmutableSet<File>)ImmutableSet.copyOf((Object[])dexFiles), dexFolderName);
        }

        protected DexFiles(ImmutableSet<File> dexFiles, String dexFolderName) {
            this.dexFiles = dexFiles;
            this.dexFolderName = dexFolderName;
        }

        protected String encodeName() {
            return this.dexFolderName.replace('-', '_');
        }

        protected ImmutableSet<File> getDexFiles() {
            return this.dexFiles;
        }
    }
}

