/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.BaseProguardAction;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.dexing.RuntimeAnnotatedClassCollector;
import com.android.builder.dexing.RuntimeAnnotatedClassDetector;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.process.ProcessException;
import com.android.multidex.MainDexListBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.LoggingManager;
import proguard.ParseException;

public class MainDexListTransform
extends BaseProguardAction {
    private final File manifestKeepListProguardFile;
    private final File userMainDexKeepProguard;
    private final File userMainDexKeepFile;
    private final VariantScope variantScope;
    private final boolean keepRuntimeAnnotatedClasses;
    private final File proguardComponentsJarFile;
    private final File configFileOut;
    private final File mainDexListFile;

    public MainDexListTransform(VariantScope variantScope, DexOptions dexOptions) {
        super(variantScope);
        this.manifestKeepListProguardFile = variantScope.getManifestKeepListProguardFile();
        this.userMainDexKeepProguard = variantScope.getVariantConfiguration().getMultiDexKeepProguard();
        this.userMainDexKeepFile = variantScope.getVariantConfiguration().getMultiDexKeepFile();
        this.variantScope = variantScope;
        this.configFileOut = new File(variantScope.getGlobalScope().getBuildDir() + "/" + "intermediates" + "/multi-dex/" + variantScope.getVariantConfiguration().getDirName() + "/components.flags");
        this.mainDexListFile = variantScope.getMainDexListFile();
        this.keepRuntimeAnnotatedClasses = dexOptions.getKeepRuntimeAnnotatedClasses();
        this.proguardComponentsJarFile = variantScope.getProguardComponentsJarFile();
    }

    public String getName() {
        return "multidexlist";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    @Override
    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        return Stream.of(this.manifestKeepListProguardFile, this.userMainDexKeepFile, this.userMainDexKeepProguard).filter(Objects::nonNull).map(SecondaryFile::nonIncremental).collect(Collectors.toList());
    }

    public Map<String, Object> getParameterInputs() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"keepRuntimeAnnotatedClasses", (Object)this.keepRuntimeAnnotatedClasses);
        params.put((Object)"implementationClass", (Object)"MainDexListTransform");
        TargetInfo targetInfo = this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo();
        if (targetInfo != null) {
            params.put((Object)"build_tools", (Object)targetInfo.getBuildTools().getRevision().toString());
        }
        return params.build();
    }

    public Collection<File> getSecondaryFileOutputs() {
        return Lists.newArrayList((Object[])new File[]{this.mainDexListFile, this.configFileOut});
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        LoggingManager loggingManager = invocation.getContext().getLogging();
        loggingManager.captureStandardOutput(LogLevel.INFO);
        loggingManager.captureStandardError(LogLevel.WARN);
        try {
            Collection<File> inputs = TransformInputUtil.getAllFiles(invocation.getReferencedInputs());
            this.shrinkWithProguard(inputs, this.proguardComponentsJarFile);
            ImmutableSet<String> classes = MainDexListTransform.computeList(inputs, this.proguardComponentsJarFile, this.userMainDexKeepFile, this.keepRuntimeAnnotatedClasses);
            Files.write(this.mainDexListFile.toPath(), classes, new OpenOption[0]);
        }
        catch (ProcessException | ParseException e) {
            throw new TransformException(e);
        }
    }

    private void shrinkWithProguard(Collection<File> inputs, File outJar) throws IOException, ParseException {
        this.configuration.obfuscate = false;
        this.configuration.optimize = false;
        this.dontwarn();
        this.dontnote();
        this.forceprocessing();
        this.applyConfigurationFile(this.manifestKeepListProguardFile);
        if (this.userMainDexKeepProguard != null) {
            this.applyConfigurationFile(this.userMainDexKeepProguard);
        }
        this.keep("public class * extends android.app.Instrumentation { <init>(); }");
        this.keep("public class * extends android.app.Application {   <init>();   void attachBaseContext(android.content.Context);}");
        this.keep("public class * extends android.app.backup.BackupAgent { <init>(); }");
        this.keep("public class * extends java.lang.annotation.Annotation { *;}");
        this.keep("class com.android.tools.fd.** {*;}");
        this.libraryJar(this.findShrinkedAndroidJar());
        for (File input : inputs) {
            this.inJar(input);
        }
        this.outJar(outJar);
        this.printconfiguration(this.configFileOut);
        this.runProguard();
    }

    private File findShrinkedAndroidJar() {
        Preconditions.checkNotNull((Object)this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo());
        File shrinkedAndroid = new File(this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "lib" + File.separatorChar + "shrinkedAndroid.jar");
        if (!shrinkedAndroid.isFile()) {
            shrinkedAndroid = new File(this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "multidex" + File.separatorChar + "shrinkedAndroid.jar");
        }
        return shrinkedAndroid;
    }

    @VisibleForTesting
    static ImmutableSet<String> computeList(Collection<File> allClasses, File jarOfRoots, File userMainDexKeepFile, boolean keepRuntimeAnnotatedClasses) throws ProcessException, IOException, InterruptedException {
        ImmutableSet.Builder mainDexClasses = ImmutableSet.builder();
        mainDexClasses.addAll(MainDexListTransform.callDx(allClasses, jarOfRoots));
        if (userMainDexKeepFile != null) {
            mainDexClasses.addAll(Files.readAllLines(userMainDexKeepFile.toPath(), Charsets.UTF_8));
        }
        if (keepRuntimeAnnotatedClasses) {
            RuntimeAnnotatedClassCollector collector = new RuntimeAnnotatedClassCollector(RuntimeAnnotatedClassDetector::hasRuntimeAnnotations);
            mainDexClasses.addAll((Iterable)collector.collectClasses((Collection)allClasses.stream().map(File::toPath).collect(Collectors.toList())));
        }
        return mainDexClasses.build();
    }

    private static ImmutableSet<String> callDx(Collection<File> allClasses, File jarOfRoots) throws IOException {
        String pathList = allClasses.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        MainDexListBuilder builder = new MainDexListBuilder(false, jarOfRoots.getAbsolutePath(), pathList);
        Set mainDexList = builder.getMainDexList().stream().map(input -> input.startsWith("/") ? input.substring(1) : input).collect(Collectors.toSet());
        return ImmutableSet.copyOf(mainDexList);
    }
}

