/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker.parser;

import com.android.build.gradle.shrinker.parser.BytecodeVersion;
import com.android.build.gradle.shrinker.parser.ClassSpecification;
import com.android.build.gradle.shrinker.parser.FilterSpecification;
import com.google.common.collect.Lists;
import java.util.List;

public class Flags {
    private final List<ClassSpecification> keepClassSpecs = Lists.newArrayList();
    private final List<ClassSpecification> keepClassesWithMembersSpecs = Lists.newArrayList();
    private final List<ClassSpecification> keepClassMembersSpecs = Lists.newArrayList();
    private final List<FilterSpecification> dontWarnSpecs = Lists.newArrayList();
    private final List<ClassSpecification> whyAreYouKeepingSpecs = Lists.newArrayList();
    private BytecodeVersion bytecodeVersion = null;
    private boolean ignoreWarnings;
    private boolean dontShrink;
    private boolean dontObfuscate;
    private boolean dontOptimize;

    public List<ClassSpecification> getKeepClassSpecs() {
        return this.keepClassSpecs;
    }

    public List<ClassSpecification> getKeepClassesWithMembersSpecs() {
        return this.keepClassesWithMembersSpecs;
    }

    public List<ClassSpecification> getKeepClassMembersSpecs() {
        return this.keepClassMembersSpecs;
    }

    public void addKeepClassSpecification(ClassSpecification classSpecification) {
        this.keepClassSpecs.add(classSpecification);
    }

    public void addKeepClassesWithMembers(ClassSpecification classSpecification) {
        this.keepClassesWithMembersSpecs.add(classSpecification);
    }

    public void addKeepClassMembers(ClassSpecification classSpecification) {
        this.keepClassMembersSpecs.add(classSpecification);
    }

    public void whyAreYouKeeping(ClassSpecification classSpecification) {
        this.whyAreYouKeepingSpecs.add(classSpecification);
    }

    public void dontWarn(List<FilterSpecification> classSpec) {
        this.dontWarnSpecs.addAll(classSpec);
    }

    public void target(String target) {
        int version;
        switch (target) {
            case "8": 
            case "1.8": {
                version = 52;
                break;
            }
            case "7": 
            case "1.7": {
                version = 51;
                break;
            }
            case "6": 
            case "1.6": {
                version = 50;
                break;
            }
            case "5": 
            case "1.5": {
                version = 49;
                break;
            }
            case "1.4": {
                version = 48;
                break;
            }
            case "1.3": {
                version = 47;
                break;
            }
            case "1.2": {
                version = 46;
                break;
            }
            case "1.1": {
                version = 196653;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown target " + target));
            }
        }
        this.bytecodeVersion = new BytecodeVersion(version);
    }

    public List<FilterSpecification> getDontWarnSpecs() {
        return this.dontWarnSpecs;
    }

    public List<ClassSpecification> getWhyAreYouKeepingSpecs() {
        return this.whyAreYouKeepingSpecs;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public BytecodeVersion getBytecodeVersion() {
        return this.bytecodeVersion;
    }

    public boolean isDontShrink() {
        return this.dontShrink;
    }

    public void setDontShrink(boolean dontShrink) {
        this.dontShrink = dontShrink;
    }

    public boolean isDontObfuscate() {
        return this.dontObfuscate;
    }

    public void setDontObfuscate(boolean dontObfuscate) {
        this.dontObfuscate = dontObfuscate;
    }

    public boolean isDontOptimize() {
        return this.dontOptimize;
    }

    public void setDontOptimize(boolean dontOptimize) {
        this.dontOptimize = dontOptimize;
    }
}

