/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker.parser;

import com.android.build.gradle.shrinker.parser.AnnotationSpecification;
import com.android.build.gradle.shrinker.parser.ClassSpecification;
import com.android.build.gradle.shrinker.parser.ClassTypeSpecification;
import com.android.build.gradle.shrinker.parser.FieldSpecification;
import com.android.build.gradle.shrinker.parser.FilterSpecification;
import com.android.build.gradle.shrinker.parser.Flags;
import com.android.build.gradle.shrinker.parser.InheritanceSpecification;
import com.android.build.gradle.shrinker.parser.KeepModifier;
import com.android.build.gradle.shrinker.parser.MethodSpecification;
import com.android.build.gradle.shrinker.parser.ModifierSpecification;
import com.android.build.gradle.shrinker.parser.NameSpecification;
import com.android.build.gradle.shrinker.parser.ProguardLexer;
import com.android.build.gradle.shrinker.parser.ProguardParser;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrammarActions {
    private static Logger logger = LoggerFactory.getLogger(GrammarActions.class);

    public static void parse(File proguardFile, Flags flags) throws RecognitionException {
        ProguardParser parser = GrammarActions.createParserFromFile(proguardFile);
        parser.prog(flags, proguardFile.getParentFile().getPath());
    }

    public static void parse(String input, Flags flags) throws RecognitionException {
        ProguardParser parser = GrammarActions.createParserFromString(input);
        parser.prog(flags, null);
    }

    static void include(String fileName, String baseDirectory, Flags flags) throws RecognitionException {
        GrammarActions.parse(GrammarActions.getFileFromBaseDir(baseDirectory, fileName), flags);
    }

    static void dontWarn(Flags flags, List<FilterSpecification> classSpec) {
        flags.dontWarn(classSpec);
    }

    static void ignoreWarnings(Flags flags) {
        flags.setIgnoreWarnings(true);
    }

    static void addKeepClassMembers(Flags flags, ClassSpecification classSpecification, KeepModifier keepModifier) {
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassMembers(classSpecification);
    }

    static void addKeepClassSpecification(Flags flags, ClassSpecification classSpecification, KeepModifier keepModifier) {
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassSpecification(classSpecification);
    }

    static void addKeepClassesWithMembers(Flags flags, ClassSpecification classSpecification, KeepModifier keepModifier) {
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassesWithMembers(classSpecification);
    }

    static void addAccessFlag(ModifierSpecification modSpec, ModifierSpecification.AccessFlag accessFlag, boolean hasNegator) {
        modSpec.addAccessFlag(accessFlag, hasNegator);
    }

    static void addModifier(ModifierSpecification modSpec, ModifierSpecification.Modifier modifier, boolean hasNegator) {
        modSpec.addModifier(modifier, hasNegator);
    }

    static AnnotationSpecification annotation(String annotationName, boolean hasNameNegator) {
        NameSpecification name = GrammarActions.name(annotationName, FilterSeparator.CLASS);
        name.setNegator(hasNameNegator);
        return new AnnotationSpecification(name);
    }

    static ClassSpecification classSpec(List<NameSpecification> classNames, ClassTypeSpecification classType, AnnotationSpecification annotation, ModifierSpecification modifier) {
        ClassSpecification classSpec = new ClassSpecification(classNames, classType, annotation);
        classSpec.setModifier(modifier);
        return classSpec;
    }

    static NameSpecification className(String name, boolean hasNameNegator) {
        NameSpecification nameSpec = name.equals("*") ? GrammarActions.name("**", FilterSeparator.CLASS) : GrammarActions.name(name, FilterSeparator.CLASS);
        nameSpec.setNegator(hasNameNegator);
        return nameSpec;
    }

    static ClassTypeSpecification classType(int type, boolean hasNegator) {
        ClassTypeSpecification classSpec = new ClassTypeSpecification(type);
        classSpec.setNegator(hasNegator);
        return classSpec;
    }

    static InheritanceSpecification createInheritance(String className, boolean hasNameNegator, AnnotationSpecification annotationType) {
        NameSpecification nameSpec = GrammarActions.name(className, FilterSeparator.CLASS);
        nameSpec.setNegator(hasNameNegator);
        return new InheritanceSpecification(nameSpec, annotationType);
    }

    static void field(ClassSpecification classSpec, AnnotationSpecification annotationType, String typeSignature, String name, ModifierSpecification modifier) {
        NameSpecification typeSignatureSpec = null;
        if (typeSignature != null) {
            typeSignatureSpec = GrammarActions.name(typeSignature, FilterSeparator.CLASS);
        } else {
            Preconditions.checkState((boolean)name.equals("*"), (Object)"No type signature, but name is not <fields> or *.");
            name = "*";
        }
        classSpec.add(new FieldSpecification(GrammarActions.name(name, FilterSeparator.GENERAL), modifier, typeSignatureSpec, annotationType));
    }

    static void fieldOrAnyMember(ClassSpecification classSpec, AnnotationSpecification annotationType, String typeSig, String name, ModifierSpecification modifier) {
        if (typeSig == null) {
            assert (name.equals("*"));
            GrammarActions.method(classSpec, annotationType, GrammarActions.getSignature("***", 0), "*", "\\(" + GrammarActions.getSignature("...", 0) + "\\)", modifier);
        }
        GrammarActions.field(classSpec, annotationType, typeSig, name, modifier);
    }

    static void filter(List<FilterSpecification> filter, boolean negator, String filterName, FilterSeparator separator) {
        filter.add(new FilterSpecification(GrammarActions.name(filterName, separator), negator));
    }

    static String getSignature(String name, int dim) {
        StringBuilder sig = new StringBuilder();
        for (int i = 0; i < dim; ++i) {
            sig.append("\\[");
        }
        switch (name) {
            case "...": {
                sig.append(".*");
                break;
            }
            case "***": {
                sig.append(".*");
                break;
            }
            case "%": {
                sig.append("(B|C|D|F|I|J|S|Z)");
                break;
            }
            case "boolean": {
                sig.append("Z");
                break;
            }
            case "byte": {
                sig.append("B");
                break;
            }
            case "char": {
                sig.append("C");
                break;
            }
            case "short": {
                sig.append("S");
                break;
            }
            case "int": {
                sig.append("I");
                break;
            }
            case "float": {
                sig.append("F");
                break;
            }
            case "double": {
                sig.append("D");
                break;
            }
            case "long": {
                sig.append("J");
                break;
            }
            case "void": {
                sig.append("V");
                break;
            }
            default: {
                sig.append("L").append(GrammarActions.convertNameToPattern(name, FilterSeparator.CLASS)).append(";");
            }
        }
        return sig.toString();
    }

    static void method(ClassSpecification classSpec, AnnotationSpecification annotationType, String typeSig, String name, String signature, ModifierSpecification modifier) {
        String fullName = "^" + GrammarActions.convertNameToPattern(name, FilterSeparator.CLASS);
        fullName = fullName + ":";
        fullName = fullName + signature;
        fullName = typeSig != null ? fullName + typeSig : fullName + "V";
        fullName = fullName + "$";
        Pattern pattern = Pattern.compile(fullName);
        classSpec.add(new MethodSpecification(new NameSpecification(pattern), modifier, annotationType));
    }

    static NameSpecification name(String name, FilterSeparator filterSeparator) {
        String transformedName = "^" + GrammarActions.convertNameToPattern(name, filterSeparator) + "$";
        Pattern pattern = Pattern.compile(transformedName);
        return new NameSpecification(pattern);
    }

    static void unsupportedFlag(String flag) {
        throw new IllegalArgumentException(String.format("Flag %s is not supported by the built-in shrinker.", flag));
    }

    static void ignoredFlag(String flag, boolean printWarning) {
        if (printWarning) {
            logger.warn("Flag {} is ignored by the built-in shrinker.", (Object)flag);
        }
    }

    static void target(Flags flags, String target) {
        flags.target(target);
    }

    static void whyAreYouKeeping(Flags flags, ClassSpecification classSpecification) {
        flags.whyAreYouKeeping(classSpecification);
    }

    static void dontOptimize(Flags flags) {
        flags.setDontOptimize(true);
    }

    static void dontShrink(Flags flags) {
        flags.setDontShrink(true);
    }

    static void dontObfuscate(Flags flags) {
        flags.setDontObfuscate(true);
    }

    private static String convertNameToPattern(String name, FilterSeparator separator) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '.': {
                    if (separator == FilterSeparator.CLASS) {
                        sb.append('/');
                        continue block6;
                    }
                    sb.append('.');
                    continue block6;
                }
                case '?': {
                    sb.append(separator.singleCharWildcard);
                    continue block6;
                }
                case '*': {
                    int j = i + 1;
                    if (j < name.length() && name.charAt(j) == '*') {
                        sb.append(".*");
                        ++i;
                        continue block6;
                    }
                    sb.append(separator.multipleCharWildcard);
                    continue block6;
                }
                case '$': {
                    sb.append("\\$");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static ProguardParser createParserCommon(CharStream stream) {
        ProguardLexer lexer = new ProguardLexer(stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        return new ProguardParser((TokenStream)tokens);
    }

    private static ProguardParser createParserFromFile(File file) {
        try {
            return GrammarActions.createParserCommon((CharStream)new ANTLRFileStream(file.getPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ProguardParser createParserFromString(String input) {
        return GrammarActions.createParserCommon((CharStream)new ANTLRStringStream(input));
    }

    private static File getFileFromBaseDir(String baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }

    static enum FilterSeparator {
        GENERAL(".", ".*"),
        FILE("[^/]", "[^/]*"),
        CLASS("[^/]", "[^/]*"),
        ATTRIBUTE(".", ".*");

        private final String singleCharWildcard;
        private final String multipleCharWildcard;

        private FilterSeparator(String singleCharWildcard, String multipleCharWildcard) {
            this.singleCharWildcard = singleCharWildcard;
            this.multipleCharWildcard = multipleCharWildcard;
        }
    }
}

