/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AbstractAndroidCompile;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.tasks.annotations.Extractor;
import com.android.builder.core.AndroidBuilder;
import com.android.tools.lint.LintCoreApplicationEnvironment;
import com.android.tools.lint.LintCoreProjectEnvironment;
import com.google.common.collect.Lists;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiJavaFile;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
@ParallelizableTask
public class ExtractAnnotations
extends AbstractAndroidCompile {
    private BaseVariantData variant;
    private Supplier<List<String>> bootClasspath;
    private File typedefFile;
    private File output;
    private String encoding;
    private File classDir;
    private ArtifactCollection libraries;

    public void setVariant(BaseVariantData variant) {
        this.variant = variant;
    }

    @CompileClasspath
    public List<String> getBootClasspath() {
        return this.bootClasspath.get();
    }

    public void setBootClasspath(Supplier<List<String>> bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    @CompileClasspath
    public FileCollection getLibraries() {
        return this.libraries.getArtifactFiles();
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @OutputFile
    public File getTypedefFile() {
        return this.typedefFile;
    }

    public void setTypedefFile(File typedefFile) {
        this.typedefFile = typedefFile;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Optional
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getClassDir() {
        return this.classDir;
    }

    public void setClassDir(File classDir) {
        this.classDir = classDir;
    }

    @TaskAction
    protected void compile() {
        if (!this.hasAndroidAnnotations()) {
            try {
                Files.write(this.typedefFile.toPath(), Collections.singletonList(""), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return;
        }
        LintCoreApplicationEnvironment appEnv = LintCoreApplicationEnvironment.get();
        Disposable parentDisposable = Disposer.newDisposable();
        try {
            LintCoreProjectEnvironment projectEnvironment = LintCoreProjectEnvironment.create((Disposable)parentDisposable, (JavaCoreApplicationEnvironment)appEnv);
            List<PsiJavaFile> parsedUnits = this.parseSources(projectEnvironment);
            boolean displayInfo = this.getLogger().isEnabled(LogLevel.INFO);
            Extractor extractor = new Extractor(null, this.classDir, displayInfo, false, false);
            extractor.extractFromProjectSource(parsedUnits);
            extractor.export(this.output, null);
            extractor.writeTypedefFile(this.typedefFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Disposer.dispose((Disposable)parentDisposable);
            LintCoreApplicationEnvironment.clearAccessorCache();
        }
    }

    @Input
    public boolean hasAndroidAnnotations() {
        for (ResolvedArtifactResult artifact : this.libraries.getArtifacts()) {
            ModuleComponentIdentifier moduleId;
            ComponentIdentifier id = artifact.getId().getComponentIdentifier();
            if (!(id instanceof ModuleComponentIdentifier) || !(moduleId = (ModuleComponentIdentifier)id).getModule().equals("support-annotations") || !moduleId.getGroup().equals("com.android.support")) continue;
            return true;
        }
        return false;
    }

    private List<PsiJavaFile> parseSources(LintCoreProjectEnvironment projectEnvironment) {
        SourceFileVisitor fileVisitor = new SourceFileVisitor();
        this.getSource().visit((FileVisitor)fileVisitor);
        List sourceFiles = fileVisitor.sourceUnits;
        List<File> sourceRoots = fileVisitor.getSourceRoots();
        if (this.getClasspath() != null) {
            for (File jar : this.getClasspath()) {
                sourceRoots.add(jar);
            }
        }
        for (String path : this.getBootClasspath()) {
            sourceRoots.add(new File(path));
        }
        projectEnvironment.registerPaths(sourceRoots);
        return Extractor.createUnitsForFiles((Project)projectEnvironment.getProject(), sourceFiles);
    }

    private static class SourceFileVisitor
    extends EmptyFileVisitor {
        private final List<File> sourceUnits = Lists.newArrayListWithExpectedSize((int)100);
        private final List<File> sourceRoots = Lists.newArrayList();
        private String mostRecentRoot = "\u0000";
        private static final String BUILD_GENERATED = File.separator + "build" + File.separator + "generated" + File.separator;

        public List<File> getSourceFiles() {
            return this.sourceUnits;
        }

        public List<File> getSourceRoots() {
            return this.sourceRoots;
        }

        public void visitFile(FileVisitDetails details) {
            File file = details.getFile();
            String path = file.getPath();
            if (path.endsWith(".java") && !path.contains(BUILD_GENERATED)) {
                if (!path.startsWith(this.mostRecentRoot)) {
                    String root;
                    File rootFile;
                    RelativePath relativePath = details.getRelativePath();
                    String pathString = relativePath.getPathString();
                    if (path.endsWith(pathString = pathString.replace('/', File.separatorChar)) && !this.sourceRoots.contains(rootFile = new File(root = path.substring(0, path.length() - pathString.length())))) {
                        this.mostRecentRoot = rootFile.getPath();
                        this.sourceRoots.add(rootFile);
                    }
                }
                this.sourceUnits.add(file);
            }
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<ExtractAnnotations> {
        private AndroidConfig extension;
        private VariantScope variantScope;
        private File outputFile;

        public ConfigAction(AndroidConfig extension, VariantScope variantScope) {
            this.extension = extension;
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("extract", "Annotations");
        }

        @Override
        public Class<ExtractAnnotations> getType() {
            return ExtractAnnotations.class;
        }

        @Override
        public void execute(ExtractAnnotations task) {
            GradleVariantConfiguration variantConfig = this.variantScope.getVariantConfiguration();
            AndroidBuilder androidBuilder = this.variantScope.getGlobalScope().getAndroidBuilder();
            task.setDescription("Extracts Android annotations for the " + variantConfig.getFullName() + " variant into the archive file");
            task.setGroup("build");
            task.setVariant(this.variantScope.getVariantData());
            task.setDestinationDir(new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "annotations/" + variantConfig.getDirName()));
            this.outputFile = new File(task.getDestinationDir(), "annotations.zip");
            task.setOutput(this.outputFile);
            task.setTypedefFile(this.variantScope.getTypedefFile());
            task.setClassDir(this.variantScope.getJavaOutputDir());
            task.setSource(this.variantScope.getVariantData().getJavaSources());
            task.setEncoding(this.extension.getCompileOptions().getEncoding());
            task.setSourceCompatibility(this.extension.getCompileOptions().getSourceCompatibility().toString());
            task.setClasspath(this.variantScope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES));
            task.libraries = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES);
            task.setBootClasspath(() -> androidBuilder.getBootClasspathAsStrings(false));
            ((LibraryVariantData)this.variantScope.getVariantData()).generateAnnotationsTask = task;
        }
    }
}

