/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GenerateTestConfig
extends DefaultTask {
    Path resourcesDirectory;
    Path assetsDirectory;
    Path sdkHome;
    Path generatedJavaResourcesDirectory;
    SplitScope splitScope;
    FileCollection manifests;

    @InputFiles
    FileCollection getManifests() {
        return this.manifests;
    }

    @TaskAction
    public void generateTestConfig() throws IOException {
        Preconditions.checkNotNull((Object)this.resourcesDirectory);
        Preconditions.checkNotNull((Object)this.assetsDirectory);
        Preconditions.checkNotNull((Object)this.sdkHome);
        this.generateTestConfigForOutput(SplitScope.getOutput(BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, this.manifests), (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, (ApkInfo)this.splitScope.getMainSplit()));
    }

    void generateTestConfigForOutput(BuildOutput buildOutput) throws IOException {
        Preconditions.checkNotNull((Object)buildOutput);
        Properties properties = new Properties();
        properties.put("android_sdk_home", this.sdkHome.toAbsolutePath().toString());
        properties.put("android_merged_resources", this.resourcesDirectory.toAbsolutePath().toString());
        properties.put("android_merged_assets", this.assetsDirectory.toAbsolutePath().toString());
        properties.put("android_merged_manifest", buildOutput.getOutputFile().toPath().toString());
        Path output = this.getOutputPath();
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(output, new OpenOption[0]);){
            properties.store(writer, null);
        }
    }

    private Path getOutputPath() {
        return this.generatedJavaResourcesDirectory.resolve("com").resolve("android").resolve("tools").resolve("test_config.properties");
    }

    @Input
    public String getResourcesDirectory() {
        return this.resourcesDirectory.toString();
    }

    @Input
    public String getAssetsDirectory() {
        return this.assetsDirectory.toString();
    }

    @Input
    public String getSdkHome() {
        return this.sdkHome.toString();
    }

    @OutputFile
    public File getOutputFile() {
        return this.getOutputPath().toFile();
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateTestConfig> {
        private final VariantScope scope;
        private VariantScope testedScope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
            this.testedScope = ((BaseVariantData)Preconditions.checkNotNull((Object)scope.getTestedVariantData(), (Object)"Not a unit test variant.")).getScope();
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "Config");
        }

        @Override
        public Class<GenerateTestConfig> getType() {
            return GenerateTestConfig.class;
        }

        @Override
        public void execute(GenerateTestConfig task) {
            FileCollection assets = this.testedScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_ASSETS);
            task.dependsOn(new Object[]{assets});
            task.generatedJavaResourcesDirectory = this.scope.getGeneratedJavaResourcesDir().toPath();
            task.resourcesDirectory = this.testedScope.getMergeResourcesOutputDir().toPath();
            task.assetsDirectory = assets.getSingleFile().toPath();
            task.manifests = this.testedScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS);
            task.splitScope = this.testedScope.getSplitScope();
            task.sdkHome = Paths.get(this.scope.getGlobalScope().getAndroidBuilder().getTarget().getLocation(), new String[0]);
        }
    }
}

