/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LintGradleClient;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.tasks.GroovyGradleDetector;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.FileUtils;
import com.android.utils.Pair;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

@ParallelizableTask
public class Lint
extends BaseTask {
    public static final String MODEL_LIBRARIES_PROPERTY = "lint.new-lib-model";
    public static final boolean MODEL_LIBRARIES = !"false".equals(System.getProperty("lint.new-lib-model"));
    private static final Logger LOG = Logging.getLogger(Lint.class);
    private LintOptions lintOptions;
    private File sdkHome;
    private boolean fatalOnly;
    private ToolingModelBuilderRegistry toolingRegistry;
    private File reportsDir;
    private File manifestReportFile;
    private File outputsDir;
    private FileCollection manifestsForVariant;
    private VariantScope variantScope;

    @InputFiles
    @Optional
    public FileCollection getManifestsForVariant() {
        return this.manifestsForVariant;
    }

    public void setLintOptions(LintOptions lintOptions) {
        this.lintOptions = lintOptions;
    }

    public void setSdkHome(File sdkHome) {
        this.sdkHome = sdkHome;
    }

    public void setToolingRegistry(ToolingModelBuilderRegistry toolingRegistry) {
        this.toolingRegistry = toolingRegistry;
    }

    public void setReportsDir(File reportDir) {
        this.reportsDir = reportDir;
    }

    public void setFatalOnly(boolean fatalOnly) {
        this.fatalOnly = fatalOnly;
    }

    @TaskAction
    public void lint() throws IOException {
        System.setProperty("java.awt.headless", "true");
        AndroidProject modelProject = this.createAndroidProject(this.getProject());
        if (this.getVariantName() != null && !this.getVariantName().isEmpty()) {
            for (Variant variant : modelProject.getVariants()) {
                if (!variant.getName().equals(this.getVariantName())) continue;
                this.lintSingleVariant(modelProject, variant);
            }
        } else {
            this.lintAllVariants(modelProject);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void lintAllVariants(AndroidProject modelProject) throws IOException {
        void var6_11;
        UnusedResourceDetector.sIncludeInactiveReferences = false;
        HashMap warningMap = Maps.newHashMap();
        ArrayList baselines = Lists.newArrayList();
        for (Object variant : modelProject.getVariants()) {
            Pair<List<Warning>, LintBaseline> pair = this.runLint(modelProject, (Variant)variant, false);
            List warnings = (List)pair.getFirst();
            warningMap.put(variant, warnings);
            LintBaseline baseline = (LintBaseline)pair.getSecond();
            if (baseline == null) continue;
            baselines.add(baseline);
        }
        boolean quiet = false;
        if (this.lintOptions != null) {
            quiet = this.lintOptions.isQuiet();
        }
        for (Map.Entry entry : warningMap.entrySet()) {
            Variant variant = (Variant)entry.getKey();
            List warnings = (List)entry.getValue();
            if (this.fatalOnly || quiet) continue;
            LOG.warn("Ran lint on variant {}: {} issues found", (Object)variant.getName(), (Object)warnings.size());
        }
        List<Warning> mergedWarnings = LintGradleClient.merge(warningMap, modelProject);
        boolean bl = false;
        int warningCount = 0;
        for (Warning warning : mergedWarnings) {
            if (warning.severity == Severity.ERROR || warning.severity == Severity.FATAL) {
                ++var6_11;
                continue;
            }
            if (warning.severity != Severity.WARNING) continue;
            ++warningCount;
        }
        if (!modelProject.getVariants().isEmpty()) {
            TreeSet allVariants = Sets.newTreeSet((v1, v2) -> v1.getName().compareTo(v2.getName()));
            allVariants.addAll(modelProject.getVariants());
            Variant variant = (Variant)allVariants.iterator().next();
            BuiltinIssueRegistry registry = new BuiltinIssueRegistry();
            LintCliFlags flags = new LintCliFlags();
            LintGradleClient client = new LintGradleClient((IssueRegistry)registry, flags, this.getProject(), modelProject, this.sdkHome, variant, this.getBuildTools(), this.getManifestReportFile(variant));
            Lint.syncOptions(this.lintOptions, client, flags, null, this.getProject(), this.reportsDir, true, this.fatalOnly);
            int baselineErrorCount = 0;
            int baselineWarningCount = 0;
            int fixedCount = 0;
            if (!baselines.isEmpty()) {
                for (Object baseline : baselines) {
                    baselineErrorCount = Math.max(baselineErrorCount, baseline.getFoundErrorCount());
                    baselineWarningCount = Math.max(baselineWarningCount, baseline.getFoundWarningCount());
                    fixedCount = Math.max(fixedCount, baseline.getFixedCount());
                }
            }
            Reporter.Stats stats = new Reporter.Stats((int)var6_11, warningCount, baselineErrorCount, baselineWarningCount, fixedCount);
            for (Reporter reporter : flags.getReporters()) {
                reporter.write(stats, mergedWarnings);
            }
            File baselineFile = flags.getBaselineFile();
            if (baselineFile != null && !baselineFile.exists()) {
                File dir = baselineFile.getParentFile();
                boolean ok = true;
                if (!dir.isDirectory()) {
                    ok = dir.mkdirs();
                }
                if (!ok) {
                    System.err.println("Couldn't create baseline folder " + dir);
                } else {
                    Reporter reporter = Reporter.createXmlReporter((LintCliClient)client, (File)baselineFile, (boolean)true);
                    reporter.write(stats, mergedWarnings);
                    System.err.println("Created baseline file " + baselineFile);
                    if ("true".equals(System.getProperty("lint.baselines.continue"))) {
                        return;
                    }
                    System.err.println("(Also breaking build in case this was not intentional.)");
                    String message = "Created baseline file " + baselineFile + "\n\nAlso breaking the build in case this was not intentional. If you\ndeliberately created the baseline file, re-run the build and this\ntime it should succeed without warnings.\n\nIf not, investigate the baseline path in the lintOptions config\nor verify that the baseline file has been checked into version\ncontrol.\n\nYou can set the system property lint.baselines.continue=true\nif you want to create many missing baselines in one go.";
                    throw new GradleException(message);
                }
            }
            if (baselineErrorCount > 0 || baselineWarningCount > 0) {
                System.out.println(String.format("%1$s were filtered out because they were listed in the baseline file, %2$s\n", LintUtils.describeCounts((int)baselineErrorCount, (int)baselineWarningCount, (boolean)false, (boolean)true), baselineFile));
            }
            if (fixedCount > 0) {
                System.out.println(String.format("%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?\n", fixedCount, baselineFile));
            }
            if (flags.isSetExitCode() && var6_11 > 0) {
                this.abort();
            }
        }
    }

    private void abort() {
        String message = this.fatalOnly ? "Lint found fatal errors while assembling a release target.\n\nTo proceed, either fix the issues identified by lint, or modify your build script as follows:\n...\nandroid {\n    lintOptions {\n        checkReleaseBuilds false\n        // Or, if you prefer, you can continue to check for errors in release builds,\n        // but continue the build even when errors are found:\n        abortOnError false\n    }\n}\n..." : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nandroid {\n    lintOptions {\n        abortOnError false\n    }\n}\n...";
        throw new GradleException(message);
    }

    public void lintSingleVariant(AndroidProject modelProject, Variant variant) {
        this.runLint(modelProject, variant, true);
    }

    private Pair<List<Warning>, LintBaseline> runLint(AndroidProject modelProject, Variant variant, boolean report) {
        Pair<List<Warning>, LintBaseline> warnings;
        BuiltinIssueRegistry registry = Lint.createIssueRegistry();
        LintCliFlags flags = new LintCliFlags();
        LintGradleClient client = new LintGradleClient((IssueRegistry)registry, flags, this.getProject(), modelProject, this.sdkHome, variant, this.getBuildTools(), this.getManifestReportFile(variant));
        if (this.fatalOnly) {
            flags.setFatalOnly(true);
        }
        if (this.lintOptions != null) {
            Lint.syncOptions(this.lintOptions, client, flags, variant, this.getProject(), this.reportsDir, report, this.fatalOnly);
        }
        if (!report || this.fatalOnly) {
            flags.setQuiet(true);
        }
        flags.setWriteBaselineIfMissing(report && !this.fatalOnly);
        try {
            warnings = client.run((IssueRegistry)registry);
        }
        catch (IOException e) {
            throw new GradleException("Invalid arguments.", (Throwable)e);
        }
        if (report && client.haveErrors() && flags.isSetExitCode()) {
            this.abort();
        }
        return warnings;
    }

    private static void syncOptions(LintOptions options, LintGradleClient client, LintCliFlags flags, Variant variant, Project project, File reportsDir, boolean report, boolean fatalOnly) {
        options.syncTo(client, flags, variant != null ? variant.getName() : null, project, reportsDir, report);
        boolean displayEmpty = !fatalOnly && !flags.isQuiet();
        for (Reporter reporter : flags.getReporters()) {
            reporter.setDisplayEmpty(displayEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AndroidProject createAndroidProject(Project gradleProject) {
        String modelName = AndroidProject.class.getName();
        ToolingModelBuilder modelBuilder = this.toolingRegistry.getBuilder(modelName);
        assert (modelBuilder != null);
        ExtraPropertiesExtension ext = gradleProject.getExtensions().getExtraProperties();
        ext.set("android.injected.build.model.only.versioned", (Object)Integer.toString(3));
        ext.set("android.injected.build.model.disable.src.download", (Object)true);
        try {
            AndroidProject androidProject = (AndroidProject)modelBuilder.buildAll(modelName, gradleProject);
            return androidProject;
        }
        finally {
            ext.set("android.injected.build.model.only.versioned", null);
            ext.set("android.injected.build.model.disable.src.download", null);
        }
    }

    private static BuiltinIssueRegistry createIssueRegistry() {
        return new LintGradleIssueRegistry();
    }

    public void setManifestReportFile(File manifestReportFile) {
        this.manifestReportFile = manifestReportFile;
    }

    public File getManifestReportFile(Variant variant) {
        if (this.manifestReportFile == null && this.outputsDir != null && variant != null) {
            this.manifestReportFile = FileUtils.join((File)this.outputsDir, (String[])new String[]{"logs", "manifest-merger-" + variant.getDisplayName() + "-report.txt"});
        }
        return this.manifestReportFile;
    }

    public void setOutputsDir(File outputsDir) {
        this.outputsDir = outputsDir;
    }

    public File getOutputsDir() {
        return this.outputsDir;
    }

    public static class GlobalConfigAction
    implements TaskConfigAction<Lint> {
        private final GlobalScope globalScope;

        public GlobalConfigAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        @Override
        public String getName() {
            return "lint";
        }

        @Override
        public Class<Lint> getType() {
            return Lint.class;
        }

        @Override
        public void execute(Lint lintTask) {
            lintTask.setDescription("Runs lint on all variants.");
            lintTask.setVariantName("");
            lintTask.setGroup("verification");
            lintTask.setLintOptions(this.globalScope.getExtension().getLintOptions());
            File sdkFolder = this.globalScope.getSdkHandler().getSdkFolder();
            if (sdkFolder != null) {
                lintTask.setSdkHome(sdkFolder);
            }
            lintTask.setToolingRegistry(this.globalScope.getToolingRegistry());
            lintTask.setReportsDir(this.globalScope.getReportsDir());
            lintTask.setOutputsDir(this.globalScope.getOutputsDir());
            lintTask.setAndroidBuilder(this.globalScope.getAndroidBuilder());
        }
    }

    public static class VitalConfigAction
    implements TaskConfigAction<Lint> {
        private final VariantScope scope;

        public VitalConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lintVital");
        }

        @Override
        public Class<Lint> getType() {
            return Lint.class;
        }

        @Override
        public void execute(Lint task) {
            String variantName = this.scope.getVariantData().getVariantConfiguration().getFullName();
            GlobalScope globalScope = this.scope.getGlobalScope();
            task.setAndroidBuilder(globalScope.getAndroidBuilder());
            task.setLintOptions(globalScope.getExtension().getLintOptions());
            task.setSdkHome((File)Preconditions.checkNotNull((Object)globalScope.getSdkHandler().getSdkFolder(), (Object)"SDK not set up."));
            task.setVariantName(variantName);
            task.manifestsForVariant = this.scope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS);
            task.setToolingRegistry(globalScope.getToolingRegistry());
            task.setReportsDir(globalScope.getReportsDir());
            task.setOutputsDir(this.scope.getGlobalScope().getOutputsDir());
            task.setManifestReportFile(this.scope.getManifestReportFile());
            task.setFatalOnly(true);
            task.setDescription("Runs lint on just the fatal issues in the " + variantName + " build.");
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<Lint> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lint");
        }

        @Override
        public Class<Lint> getType() {
            return Lint.class;
        }

        @Override
        public void execute(Lint lint) {
            GlobalScope globalScope = this.scope.getGlobalScope();
            lint.setLintOptions(globalScope.getExtension().getLintOptions());
            File sdkFolder = globalScope.getSdkHandler().getSdkFolder();
            if (sdkFolder != null) {
                lint.setSdkHome(sdkFolder);
            }
            lint.setAndroidBuilder(globalScope.getAndroidBuilder());
            lint.setVariantName(this.scope.getVariantConfiguration().getFullName());
            lint.manifestsForVariant = this.scope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS);
            lint.setToolingRegistry(globalScope.getToolingRegistry());
            lint.setReportsDir(globalScope.getReportsDir());
            lint.setOutputsDir(this.scope.getGlobalScope().getOutputsDir());
            lint.setManifestReportFile(this.scope.getManifestReportFile());
            lint.setDescription("Runs lint on the " + StringHelper.capitalize((String)this.scope.getVariantConfiguration().getFullName()) + " build.");
            lint.setGroup("verification");
        }
    }

    public static class LintGradleIssueRegistry
    extends BuiltinIssueRegistry {
        private boolean mInitialized;

        public List<Issue> getIssues() {
            List issues = super.getIssues();
            if (!this.mInitialized) {
                this.mInitialized = true;
                for (Issue issue : issues) {
                    if (issue.getImplementation().getDetectorClass() != GradleDetector.class) continue;
                    issue.setImplementation(GroovyGradleDetector.IMPLEMENTATION);
                }
            }
            return issues;
        }
    }
}

