/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NdkTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.LongOption;
import com.android.build.gradle.options.NdkLease;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.util.ReferenceHolder;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@ParallelizableTask
public class NdkCompile
extends NdkTask {
    private FileCollection sourceFolders;
    private File generatedMakefile;
    private boolean debuggable;
    private File soFolder;
    private File objFolder;
    private File ndkDirectory;
    private boolean ndkRenderScriptMode;
    private boolean ndkCygwinMode;
    private boolean isForTesting;
    private boolean isUseDeprecatedNdkFlag;
    private boolean isDeprecatedNdkCompileLeaseExpired;

    private static String getAlternatives(File generatedMakefile, String urlSuffix) {
        String generatedAndridMk = "";
        if (generatedMakefile != null) {
            generatedAndridMk = String.format(" To get started, you can use the sample ndk-build script the Android\n plugin generated for you at:\n %s\n", generatedMakefile);
        }
        return String.format("Consider using CMake or ndk-build integration. For more information, go to:\n http://d.android.com/r/studio-ui/add-native-code.html%s\n%sAlternatively, you can use the experimental plugin:\n https://developer.android.com/studio/build/experimental-plugin.html.\n", urlSuffix, generatedAndridMk);
    }

    @OutputFile
    public File getGeneratedMakefile() {
        return this.generatedMakefile;
    }

    public void setGeneratedMakefile(File generatedMakefile) {
        this.generatedMakefile = generatedMakefile;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @OutputDirectory
    public File getSoFolder() {
        return this.soFolder;
    }

    public void setSoFolder(File soFolder) {
        this.soFolder = soFolder;
    }

    @OutputDirectory
    public File getObjFolder() {
        return this.objFolder;
    }

    public void setObjFolder(File objFolder) {
        this.objFolder = objFolder;
    }

    @Optional
    @Input
    public File getNdkDirectory() {
        return this.ndkDirectory;
    }

    public void setNdkDirectory(File ndkDirectory) {
        this.ndkDirectory = ndkDirectory;
    }

    @Input
    public boolean isNdkRenderScriptMode() {
        return this.ndkRenderScriptMode;
    }

    public void setNdkRenderScriptMode(boolean ndkRenderScriptMode) {
        this.ndkRenderScriptMode = ndkRenderScriptMode;
    }

    @Input
    public boolean isNdkCygwinMode() {
        return this.ndkCygwinMode;
    }

    public void setNdkCygwinMode(boolean ndkCygwinMode) {
        this.ndkCygwinMode = ndkCygwinMode;
    }

    @Input
    public boolean isForTesting() {
        return this.isForTesting;
    }

    public void setForTesting(boolean forTesting) {
        this.isForTesting = forTesting;
    }

    @Input
    public boolean isDeprecatedNdkCompileLeaseExpired() {
        return this.isDeprecatedNdkCompileLeaseExpired;
    }

    @Input
    public boolean isUseDeprecatedNdkFlag() {
        return this.isUseDeprecatedNdkFlag;
    }

    @SkipWhenEmpty
    @InputFiles
    public FileTree getSource() {
        return this.sourceFolders.getAsFileTree();
    }

    private static String getAlternativesAndLeaseNotice(File generatedMakefile, String urlSuffix) {
        return String.format(NdkCompile.getAlternatives(generatedMakefile, urlSuffix) + "To continue using the deprecated NDK compile for another %s days, set \n%s=%s in gradle.properties", 60L, LongOption.DEPRECATED_NDK_COMPILE_LEASE.getPropertyName(), NdkLease.getFreshDeprecatedNdkCompileLease());
    }

    @TaskAction
    void taskAction(IncrementalTaskInputs inputs) throws IOException, ProcessException {
        FileTree sourceFileTree = this.getSource();
        Set sourceFiles = sourceFileTree.matching((PatternFilterable)new PatternSet().exclude(new String[]{"**/*.h"})).getFiles();
        File makefile = this.getGeneratedMakefile();
        if (this.isUseDeprecatedNdkFlag) {
            this.writeMakefile(sourceFiles, makefile);
            throw new RuntimeException(String.format("Error: Flag %s is no longer supported and will be removed in the next version of Android Studio.  Please switch to a supported build system.\n%s", BooleanOption.ENABLE_DEPRECATED_NDK.getPropertyName(), NdkCompile.getAlternativesAndLeaseNotice(makefile, "#ndkCompile")));
        }
        if (this.isDeprecatedNdkCompileLeaseExpired) {
            this.writeMakefile(sourceFiles, makefile);
            throw new RuntimeException("Error: Your project contains C++ files but it is not using a supported native build system.\n" + NdkCompile.getAlternatives(null, ""));
        }
        if (sourceFiles.isEmpty()) {
            makefile.delete();
            FileUtils.cleanOutputDir((File)this.getSoFolder());
            FileUtils.cleanOutputDir((File)this.getObjFolder());
            return;
        }
        if (this.ndkDirectory == null || !this.ndkDirectory.isDirectory()) {
            throw new GradleException("NDK not configured.\nDownload the NDK from http://developer.android.com/tools/sdk/ndk/.Then add ndk.dir=path/to/ndk in local.properties.\n(On Windows, make sure you escape backslashes, e.g. C:\\\\ndk rather than C:\\ndk)");
        }
        final ReferenceHolder generateMakeFile = ReferenceHolder.of((Object)false);
        if (!inputs.isIncremental()) {
            this.getLogger().info("Unable do incremental execution: full task run");
            generateMakeFile.setValue((Object)true);
            FileUtils.cleanOutputDir((File)this.getSoFolder());
            FileUtils.cleanOutputDir((File)this.getObjFolder());
        } else {
            inputs.outOfDate((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails change) {
                    if (change.isAdded()) {
                        generateMakeFile.setValue((Object)true);
                    }
                }
            });
            inputs.removed((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails change) {
                    generateMakeFile.setValue((Object)true);
                }
            });
        }
        if (((Boolean)generateMakeFile.getValue()).booleanValue()) {
            this.writeMakefile(sourceFiles, makefile);
        }
        this.getLogger().warn("Warning: Deprecated NDK integration enabled by " + LongOption.DEPRECATED_NDK_COMPILE_LEASE.getPropertyName() + " flag in gradle.properties will be removed from Android Gradle plugin in the next version.\n" + NdkCompile.getAlternatives(makefile, "#ndkCompile"));
        this.runNdkBuild(this.ndkDirectory, makefile);
    }

    private void writeMakefile(Set<File> sourceFiles, File makefile) throws IOException {
        String moduleName;
        CoreNdkOptions ndk = this.getNdkConfig();
        Preconditions.checkNotNull((Object)ndk, (Object)"Ndk config should be set");
        StringBuilder sb = new StringBuilder();
        sb.append("LOCAL_PATH := $(call my-dir)\ninclude $(CLEAR_VARS)\n\n");
        String string = moduleName = ndk.getModuleName() != null ? ndk.getModuleName() : this.getProject().getName();
        if (this.isForTesting) {
            moduleName = moduleName + "_test";
        }
        sb.append("LOCAL_MODULE := ").append(moduleName).append('\n');
        if (ndk.getcFlags() != null) {
            sb.append("LOCAL_CFLAGS := ").append(ndk.getcFlags()).append('\n');
        }
        sb.append("LOCAL_LDFLAGS := -Wl,--build-id\n");
        ArrayList fullLdlibs = Lists.newArrayList();
        if (ndk.getLdLibs() != null) {
            fullLdlibs.addAll(ndk.getLdLibs());
        }
        if (this.isNdkRenderScriptMode()) {
            fullLdlibs.add("dl");
            fullLdlibs.add("log");
            fullLdlibs.add("jnigraphics");
            fullLdlibs.add("RScpp_static");
        }
        if (!fullLdlibs.isEmpty()) {
            sb.append("LOCAL_LDLIBS := \\\n");
            for (String lib : fullLdlibs) {
                sb.append("\t-l").append(lib).append(" \\\n");
            }
            sb.append('\n');
        }
        sb.append("LOCAL_SRC_FILES := \\\n");
        for (File sourceFile : sourceFiles) {
            sb.append('\t').append(sourceFile.getAbsolutePath()).append(" \\\n");
        }
        sb.append('\n');
        for (File sourceFolder : this.sourceFolders.getFiles()) {
            sb.append("LOCAL_C_INCLUDES += ").append(sourceFolder.getAbsolutePath()).append('\n');
        }
        if (this.isNdkRenderScriptMode()) {
            sb.append("LOCAL_LDFLAGS += -L$(call host-path,$(TARGET_C_INCLUDES)/../lib/rs)\n");
            sb.append("LOCAL_C_INCLUDES += $(TARGET_C_INCLUDES)/rs/cpp\n");
            sb.append("LOCAL_C_INCLUDES += $(TARGET_C_INCLUDES)/rs\n");
            sb.append("LOCAL_C_INCLUDES += $(TARGET_OBJS)/$(LOCAL_MODULE)\n");
        }
        sb.append("\ninclude $(BUILD_SHARED_LIBRARY)\n");
        Files.write((CharSequence)sb.toString(), (File)makefile, (Charset)Charsets.UTF_8);
    }

    private void runNdkBuild(File ndkLocation, File makefile) throws ProcessException {
        Set<String> abiFilters;
        CoreNdkOptions ndk = this.getNdkConfig();
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        String exe = ndkLocation.getAbsolutePath() + File.separator + "ndk-build";
        if (SdkConstants.CURRENT_PLATFORM == 2 && !this.ndkCygwinMode) {
            exe = exe + ".cmd";
        }
        builder.setExecutable(exe);
        builder.addArgs("NDK_PROJECT_PATH=null", "APP_BUILD_SCRIPT=" + makefile.getAbsolutePath());
        IAndroidTarget target = this.getBuilder().getTarget();
        if (!target.isPlatform()) {
            target = target.getParent();
        }
        builder.addArgs("APP_PLATFORM=" + target.hashString());
        builder.addArgs("NDK_OUT=" + this.getObjFolder().getAbsolutePath());
        builder.addArgs("NDK_LIBS_OUT=" + this.getSoFolder().getAbsolutePath());
        if (this.isDebuggable()) {
            builder.addArgs("NDK_DEBUG=1");
        }
        if (ndk.getStl() != null) {
            builder.addArgs("APP_STL=" + ndk.getStl());
        }
        if ((abiFilters = ndk.getAbiFilters()) != null && !abiFilters.isEmpty()) {
            if (abiFilters.size() == 1) {
                builder.addArgs("APP_ABI=" + abiFilters.iterator().next());
            } else {
                Joiner joiner = Joiner.on((char)',').skipNulls();
                builder.addArgs("APP_ABI=" + joiner.join(abiFilters.iterator()));
            }
        } else {
            builder.addArgs("APP_ABI=all");
        }
        if (ndk.getJobs() != null) {
            builder.addArgs("-j" + ndk.getJobs());
        }
        LoggedProcessOutputHandler handler = new LoggedProcessOutputHandler(this.getBuilder().getLogger());
        this.getBuilder().executeProcess(builder.createProcess(), (ProcessOutputHandler)handler).rethrowFailure().assertNormalExitValue();
    }

    private boolean isNdkOptionUnset() {
        return this.getModuleName() == null && this.getcFlags() == null && this.getLdLibs() == null && this.getAbiFilters() == null && this.getStl() == null;
    }

    public static class ConfigAction
    implements TaskConfigAction<NdkCompile> {
        private final VariantScope variantScope;

        public ConfigAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("compile", "Ndk");
        }

        @Override
        public Class<NdkCompile> getType() {
            return NdkCompile.class;
        }

        @Override
        public void execute(NdkCompile ndkCompile) {
            BaseVariantData variantData = this.variantScope.getVariantData();
            ndkCompile.setAndroidBuilder(this.variantScope.getGlobalScope().getAndroidBuilder());
            ndkCompile.setVariantName(variantData.getName());
            ndkCompile.setNdkDirectory(this.variantScope.getGlobalScope().getSdkHandler().getNdkFolder());
            ndkCompile.setForTesting(variantData.getType().isForTesting());
            ndkCompile.isUseDeprecatedNdkFlag = this.variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_DEPRECATED_NDK);
            ndkCompile.isDeprecatedNdkCompileLeaseExpired = NdkLease.isDeprecatedNdkCompileLeaseExpired(this.variantScope.getGlobalScope().getProjectOptions());
            variantData.ndkCompileTask = ndkCompile;
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            if (Boolean.TRUE.equals(variantConfig.getMergedFlavor().getRenderscriptNdkModeEnabled())) {
                ndkCompile.setNdkRenderScriptMode(true);
            } else {
                ndkCompile.setNdkRenderScriptMode(false);
            }
            Callable<Collection<File>> callable = TaskInputHelper.bypassFileCallable(() -> {
                List sourceList = variantConfig.getJniSourceList();
                if (Boolean.TRUE.equals(variantConfig.getMergedFlavor().getRenderscriptNdkModeEnabled())) {
                    sourceList.add(variantData.renderscriptCompileTask.getSourceOutputDir());
                }
                return sourceList;
            });
            ndkCompile.sourceFolders = (FileCollection)this.variantScope.getGlobalScope().getProject().files(new Object[]{callable});
            ndkCompile.setGeneratedMakefile(new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/Android.mk"));
            ndkCompile.setNdkConfig(variantConfig.getNdkConfig());
            ndkCompile.setDebuggable(((CoreBuildType)variantConfig.getBuildType()).isJniDebuggable());
            ndkCompile.setObjFolder(new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj"));
            Collection<File> ndkSoFolder = this.variantScope.getNdkSoFolder();
            if (ndkSoFolder != null && !ndkSoFolder.isEmpty()) {
                ndkCompile.setSoFolder(ndkSoFolder.iterator().next());
            }
        }
    }
}

