/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SigningException;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.signing.KeytoolException;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class PackageSplitAbi
extends BaseTask {
    private FileCollection processedAbiResources;
    private File outputDirectory;
    private boolean jniDebuggable;
    private SigningConfig signingConfig;
    private FileCollection jniFolders;
    private AndroidVersion minSdkVersion;
    private File incrementalDir;
    private AaptOptions aaptOptions;
    private SplitScope splitScope;

    @InputFiles
    public FileCollection getProcessedAbiResources() {
        return this.processedAbiResources;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public Set<String> getSplits() {
        return this.splitScope.getApkDatas().stream().map(ApkData::getFilterName).collect(Collectors.toSet());
    }

    @Input
    public boolean isJniDebuggable() {
        return this.jniDebuggable;
    }

    @Nested
    @Optional
    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    @InputFiles
    public FileCollection getJniFolders() {
        return this.jniFolders;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.getFeatureLevel();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return (Collection)MoreObjects.firstNonNull((Object)this.aaptOptions.getNoCompress(), Collections.emptyList());
    }

    @TaskAction
    protected void doFullTaskAction() throws SigningException, KeytoolException, PackagerException, IOException {
        FileUtils.cleanOutputDir((File)this.incrementalDir);
        this.splitScope.parallelForEachOutput(BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES, this.processedAbiResources), TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES, TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT, (split, output) -> {
            String apkName = this.getApkName(split);
            File outFile = new File(this.outputDirectory, apkName);
            try (IncrementalPackager pkg = new IncrementalPackagerBuilder().withOutputFile(outFile).withSigning(this.signingConfig).withCreatedBy(this.getBuilder().getCreatedBy()).withMinSdk(this.getMinSdkVersion()).withAaptOptions(this.aaptOptions).withIntermediateDir(this.incrementalDir).withProject(this.getProject()).withDebuggableBuild(this.isJniDebuggable()).withJniDebuggableBuild(this.isJniDebuggable()).withAcceptedAbis((Set<String>)ImmutableSet.of((Object)split.getFilterName())).build();){
                ImmutableMap nativeLibs = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getJniFolders());
                pkg.updateNativeLibraries(nativeLibs);
                ImmutableMap androidResources = IncrementalRelativeFileSets.fromZip((File)output);
                pkg.updateAndroidResources(androidResources);
            }
            return outFile;
        });
        this.splitScope.save(TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT, this.outputDirectory);
    }

    private String getApkName(ApkData apkData) {
        String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        String apkName = archivesBaseName + "-" + apkData.getBaseName();
        return apkName + (this.getSigningConfig() == null ? "-unsigned" : "") + ".apk";
    }

    public static class ConfigAction
    implements TaskConfigAction<PackageSplitAbi> {
        private VariantScope scope;
        private File outputDirectory;
        private FileCollection processedAbiResources;

        public ConfigAction(VariantScope scope, File outputDirectory, FileCollection processedAbiResources) {
            this.scope = scope;
            this.outputDirectory = outputDirectory;
            this.processedAbiResources = processedAbiResources;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "SplitAbi");
        }

        @Override
        public Class<PackageSplitAbi> getType() {
            return PackageSplitAbi.class;
        }

        @Override
        public void execute(PackageSplitAbi packageSplitAbiTask) {
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            packageSplitAbiTask.processedAbiResources = this.processedAbiResources;
            packageSplitAbiTask.splitScope = this.scope.getSplitScope();
            packageSplitAbiTask.signingConfig = config.getSigningConfig();
            packageSplitAbiTask.outputDirectory = this.outputDirectory;
            packageSplitAbiTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            packageSplitAbiTask.setVariantName(config.getFullName());
            packageSplitAbiTask.minSdkVersion = config.getMinSdkVersion();
            packageSplitAbiTask.incrementalDir = this.scope.getIncrementalDir(packageSplitAbiTask.getName());
            packageSplitAbiTask.aaptOptions = this.scope.getGlobalScope().getExtension().getAaptOptions();
            packageSplitAbiTask.jniDebuggable = config.getBuildType().isJniDebuggable();
            packageSplitAbiTask.jniFolders = this.scope.getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.NATIVE_LIBS);
            packageSplitAbiTask.jniDebuggable = config.getBuildType().isJniDebuggable();
        }
    }
}

