/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.build.gradle.shrinker.AbstractShrinker;
import com.android.build.gradle.shrinker.FullRunShrinker;
import com.android.build.gradle.shrinker.IncrementalShrinker;
import com.android.build.gradle.shrinker.JavaSerializationShrinkerGraph;
import com.android.build.gradle.shrinker.KeepRules;
import com.android.build.gradle.shrinker.ProguardConfig;
import com.android.build.gradle.shrinker.ProguardParserKeepRules;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.build.gradle.shrinker.parser.ProguardFlags;
import com.android.build.gradle.shrinker.parser.UnsupportedFlagsHandler;
import com.android.build.gradle.shrinker.tracing.Trace;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.BuildException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInShrinkerTransform
extends ProguardConfigurable {
    private static final String NAME = "androidGradleClassShrinker";
    private static final UnsupportedFlagsHandler FLAGS_HANDLER = new ShrinkerFlagsHandler();
    private static final Logger logger = LoggerFactory.getLogger(BuiltInShrinkerTransform.class);
    private final Set<File> platformJars;
    private final File incrementalDir;
    private final List<String> addtionalLines;

    public BuiltInShrinkerTransform(VariantScope scope) {
        super(scope);
        this.platformJars = ImmutableSet.copyOf((Collection)scope.getGlobalScope().getAndroidBuilder().getBootClasspath(true));
        this.incrementalDir = scope.getIncrementalDir(scope.getTaskName(NAME));
        this.addtionalLines = Lists.newArrayList();
    }

    public String getName() {
        return NAME;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        return ImmutableList.of((Object)SecondaryFile.nonIncremental((FileCollection)this.getAllConfigurationFiles()));
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.incrementalDir);
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        TransformOutputProvider output = invocation.getOutputProvider();
        Collection referencedInputs = invocation.getReferencedInputs();
        Preconditions.checkNotNull((Object)output, (Object)("Missing output object for transform " + this.getName()));
        if (BuiltInShrinkerTransform.isIncrementalRun(invocation.isIncremental(), referencedInputs)) {
            this.incrementalRun(invocation.getInputs(), referencedInputs, output);
        } else {
            this.fullRun(invocation.getInputs(), referencedInputs, output);
        }
    }

    private void fullRun(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider output) throws IOException {
        ProguardFlags flags = this.getProguardFlags();
        ShrinkerLogger shrinkerLogger = new ShrinkerLogger(flags.getDontWarnSpecs(), logger);
        FullRunShrinker<String> shrinker = new FullRunShrinker<String>(WaitableExecutor.useGlobalSharedThreadPool(), JavaSerializationShrinkerGraph.empty(this.incrementalDir), this.platformJars, shrinkerLogger, flags.getBytecodeVersion());
        boolean saveState = this.isIncremental();
        ProguardParserKeepRules whyAreYouKeepingRules = null;
        if (!flags.getWhyAreYouKeepingSpecs().isEmpty()) {
            whyAreYouKeepingRules = ProguardParserKeepRules.whyAreYouKeepingRules(flags, shrinkerLogger);
        }
        FullRunShrinker.Result result = shrinker.run(inputs, referencedInputs, output, (ImmutableMap<AbstractShrinker.CounterSet, KeepRules>)ImmutableMap.of((Object)((Object)AbstractShrinker.CounterSet.SHRINK), (Object)ProguardParserKeepRules.keepRules(flags, shrinkerLogger)), whyAreYouKeepingRules, saveState);
        if (!result.traces.isEmpty()) {
            System.out.println("Explaining why classes and class members are being kept...");
            System.out.println();
            BuiltInShrinkerTransform.printWhyAreYouKeepingExplanation(result.traces, System.out);
        }
        BuiltInShrinkerTransform.checkForWarnings(flags, shrinkerLogger);
    }

    @VisibleForTesting
    static void printWhyAreYouKeepingExplanation(Map<String, Trace<String>> traces, PrintStream out) {
        traces.forEach((node, trace) -> {
            for (Pair pair : trace.toList()) {
                out.println((String)pair.getFirst());
                out.print("  ");
                out.print(pair.getSecond());
                out.print(" from ");
            }
        });
        out.println("keep rules");
    }

    private static void checkForWarnings(ProguardFlags flags, ShrinkerLogger shrinkerLogger) {
        if (shrinkerLogger.getWarningsCount() > 0 && !flags.isIgnoreWarnings()) {
            throw new BuildException("Warnings found during shrinking, please use -dontwarn or -ignorewarnings to suppress them.", null);
        }
    }

    private ProguardFlags getProguardFlags() throws IOException {
        ProguardConfig config = new ProguardConfig();
        for (File configFile : this.getAllConfigurationFiles()) {
            if (!configFile.isFile()) continue;
            config.parse(configFile, FLAGS_HANDLER);
        }
        config.parse(this.getAdditionalConfigString());
        return config.getFlags();
    }

    private String getAdditionalConfigString() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.addtionalLines) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void incrementalRun(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider output) throws IOException {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            JavaSerializationShrinkerGraph graph = JavaSerializationShrinkerGraph.readFromDir(this.incrementalDir, ((Object)((Object)this)).getClass().getClassLoader());
            AbstractShrinker.logTime("loading state", stopwatch);
            ProguardFlags proguardFlags = this.getProguardFlags();
            if (!proguardFlags.getWhyAreYouKeepingSpecs().isEmpty()) {
                logger.warn("-whyareyoukeeping is ignored during incremental runs. Clean the project to use it.");
            }
            ShrinkerLogger shrinkerLogger = new ShrinkerLogger(proguardFlags.getDontWarnSpecs(), logger);
            IncrementalShrinker<String> shrinker = new IncrementalShrinker<String>(WaitableExecutor.useGlobalSharedThreadPool(), graph, shrinkerLogger, proguardFlags.getBytecodeVersion());
            shrinker.incrementalRun(inputs, output);
            BuiltInShrinkerTransform.checkForWarnings(proguardFlags, shrinkerLogger);
        }
        catch (IncrementalShrinker.IncrementalRunImpossibleException e) {
            logger.warn("Incremental shrinker run impossible: " + e.getMessage());
            logger.info("Incremental shrinker run impossible: " + e.getMessage(), (Throwable)e);
            this.fullRun(inputs, referencedInputs, output);
        }
    }

    private static boolean isIncrementalRun(boolean isIncremental, Collection<TransformInput> referencedInputs) {
        if (!isIncremental) {
            return false;
        }
        for (TransformInput referencedInput : referencedInputs) {
            for (JarInput jarInput : referencedInput.getJarInputs()) {
                if (jarInput.getStatus() == Status.NOTCHANGED) continue;
                return false;
            }
            for (DirectoryInput directoryInput : referencedInput.getDirectoryInputs()) {
                if (directoryInput.getChangedFiles().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void keep(String keep) {
        this.addtionalLines.add("-keep " + keep);
    }

    @Override
    public void dontwarn(String dontwarn) {
        this.addtionalLines.add("-dontwarn " + dontwarn);
    }

    @Override
    public void setActions(PostprocessingFeatures actions) {
    }

    private static class ShrinkerFlagsHandler
    implements UnsupportedFlagsHandler {
        private static final ImmutableSet<String> UNSUPPORTED_FLAGS = ImmutableSet.of((Object)"-dump", (Object)"-forceprocessing", (Object)"-injars", (Object)"-keepdirectories", (Object)"-libraryjars", (Object)"-microedition", (Object[])new String[]{"-outjars", "-printconfiguration", "-printmapping", "-printseeds", "-printusage"});
        private static final ImmutableSet<String> IGNORED_FLAGS = ImmutableSet.of((Object)"-optimizations", (Object)"-adaptclassstrings", (Object)"-adaptresourcefilecontents", (Object)"-adaptresourcefilenames", (Object)"-allowaccessmodification", (Object)"-applymapping", (Object[])new String[]{"-assumenosideeffects", "-classobfuscationdictionary", "-flattenpackagehierarchy", "-mergeinterfacesaggressively", "-obfuscationdictionary", "-optimizationpasses", "-overloadaggressively", "-packageobfuscationdictionary", "-renamesourcefileattribute", "-repackageclasses", "-useuniqueclassmembernames"});

        private ShrinkerFlagsHandler() {
        }

        @Override
        public void unsupportedFlag(String flagName) {
            if (UNSUPPORTED_FLAGS.contains((Object)flagName)) {
                throw new InvalidUserDataException(flagName + " is not supported by the built-in class shrinker.");
            }
            if (IGNORED_FLAGS.contains((Object)flagName)) {
                logger.warn(flagName + " is ignored by the built-in class shrinker.");
            }
        }
    }
}

