/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.apkzlib.utils.IOExceptionWrapper;
import com.android.apkzlib.zip.compress.Zip64NotSupportedException;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.incremental.DexPackagingPolicy;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.KnownFilesSaveData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.res2.FileStatus;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public abstract class PackageAndroidArtifact
extends IncrementalTask {
    public static final String INSTANT_RUN_PACKAGES_PREFIX = "instant-run";
    protected TaskOutputHolder.TaskOutputType manifestType;
    protected FileCollection resourceFiles;
    protected FileCollection dexFolders;
    protected FileCollection assets;
    protected FileCollection javaResourceFiles;
    protected FileCollection jniFolders;
    private Set<String> abiFilters;
    private boolean debugBuild;
    private boolean jniDebugBuild;
    private CoreSigningConfig signingConfig;
    private PackagingOptions packagingOptions;
    private AndroidVersion minSdkVersion;
    protected InstantRunBuildContext instantRunContext;
    protected File instantRunSupportDir;
    protected DexPackagingPolicy dexPackagingPolicy;
    protected FileCollection manifests;
    protected Collection<String> aaptOptionsNoCompress;
    protected FileType instantRunFileType;
    protected SplitScope splitScope;
    protected String projectBaseName;
    protected File outputDirectory;
    private Map<ApkData, File> outputFiles;
    protected OutputFileProvider outputFileProvider;
    private static final String ZIP_DIFF_CACHE_DIR = "zip-cache";
    private static final String ZIP_64_COPY_DIR = "zip64-copy";
    TaskOutputHolder.TaskOutputType taskInputType;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifests() {
        return this.manifests;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getResourceFiles() {
        return this.resourceFiles;
    }

    @Input
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public void setAbiFilters(Set<String> abiFilters) {
        this.abiFilters = abiFilters != null ? abiFilters : ImmutableSet.of();
    }

    @Input
    public TaskOutputHolder.TaskOutputType getManifestType() {
        return this.manifestType;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getJavaResourceFiles() {
        return this.javaResourceFiles;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getJniFolders() {
        return this.jniFolders;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getDexFolders() {
        return this.dexFolders;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getAssets() {
        return this.assets;
    }

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Input
    public boolean getJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public void setJniDebugBuild(boolean jniDebugBuild) {
        this.jniDebugBuild = jniDebugBuild;
    }

    @Input
    public boolean getDebugBuild() {
        return this.debugBuild;
    }

    public void setDebugBuild(boolean debugBuild) {
        this.debugBuild = debugBuild;
    }

    @Nested
    @Optional
    public CoreSigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(CoreSigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Nested
    public PackagingOptions getPackagingOptions() {
        return this.packagingOptions;
    }

    public void setPackagingOptions(PackagingOptions packagingOptions) {
        this.packagingOptions = packagingOptions;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.getApiLevel();
    }

    public void setMinSdkVersion(AndroidVersion version) {
        this.minSdkVersion = version;
    }

    @Input
    public String getDexPackagingPolicy() {
        return this.dexPackagingPolicy.toString();
    }

    @Input
    public List<String> getNativeLibrariesPackagingModeName() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        this.manifests.getFiles().forEach(manifest -> {
            if (manifest.isFile() && manifest.getName().equals("AndroidManifest.xml")) {
                listBuilder.add((Object)PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)manifest).toString());
            }
        });
        return listBuilder.build();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return this.aaptOptionsNoCompress != null ? this.aaptOptionsNoCompress : Collections.emptyList();
    }

    @Input
    public TaskOutputHolder.TaskOutputType getTaskInputType() {
        return this.taskInputType;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @OutputFiles
    public synchronized Collection<File> getOutputFiles() {
        if (this.outputFiles == null) {
            this.outputFiles = PackageAndroidArtifact.computeOutputFiles(this.splitScope, BuildOutputs.load((TaskOutputHolder.OutputType)this.taskInputType, this.resourceFiles), this.taskInputType, this.outputDirectory, this.outputFileProvider);
        }
        File metadataFile = BuildOutputs.getMetadataFile(this.outputDirectory);
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.addAll(this.outputFiles.values()).add((Object)metadataFile).build();
    }

    @Input
    public Collection<String> getApkList() {
        this.getOutputFiles();
        Objects.requireNonNull(this.outputFiles);
        return this.outputFiles.keySet().stream().map(ApkData::getFullName).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Map<ApkData, File> computeOutputFiles(SplitScope splitScope, Collection<BuildOutput> inputs, TaskOutputHolder.OutputType inputType, File outputDirectory, OutputFileProvider outputFileProvider) {
        HashMap outputFiles = Maps.newHashMap();
        for (ApkData split : splitScope.getApkDatas()) {
            BuildOutput buildOutput = SplitScope.getOutput(inputs, inputType, (ApkInfo)split);
            if (buildOutput == null) continue;
            File outputFile = outputFileProvider != null ? outputFileProvider.getOutputFile(split) : new File(outputDirectory, split.getOutputFileName());
            outputFiles.put(split, outputFile);
        }
        return outputFiles;
    }

    protected abstract TaskOutputHolder.TaskOutputType getTaskOutputType();

    @Override
    protected void doFullTaskAction() throws IOException {
        Collection<BuildOutput> mergedResources = BuildOutputs.load((TaskOutputHolder.OutputType)this.getTaskInputType(), this.resourceFiles);
        this.splitScope.parallelForEachOutput(mergedResources, this.getTaskInputType(), this.getTaskOutputType(), this::splitFullAction);
        this.splitScope.save(this.getTaskOutputType(), this.outputDirectory);
    }

    public File splitFullAction(ApkData apkData, File processedResources) throws IOException {
        File incrementalDirForSplit = new File(this.getIncrementalFolder(), apkData.getFullName());
        if (incrementalDirForSplit.exists()) {
            FileUtils.deleteDirectoryContents((File)incrementalDirForSplit);
        } else {
            FileUtils.mkdirs((File)incrementalDirForSplit);
        }
        File cacheByPathDir = new File(incrementalDirForSplit, ZIP_DIFF_CACHE_DIR);
        FileUtils.mkdirs((File)cacheByPathDir);
        FileCacheByPath cacheByPath = new FileCacheByPath(cacheByPathDir);
        cacheByPath.clear();
        HashSet<File> androidResources = new HashSet<File>();
        if (processedResources != null) {
            androidResources.add(processedResources);
        }
        FileUtils.mkdirs((File)this.outputDirectory);
        Objects.requireNonNull(this.outputFiles);
        File outputFile = this.outputFiles.get(apkData);
        FileUtils.deleteIfExists((File)outputFile);
        ImmutableMap updatedDex = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getDexFolders());
        ImmutableMap<RelativeFile, FileStatus> updatedJavaResources = this.getJavaResourcesChanges();
        ImmutableMap updatedAssets = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.assets.getFiles());
        ImmutableMap updatedAndroidResources = IncrementalRelativeFileSets.fromZipsAndDirectories(androidResources);
        ImmutableMap updatedJniResources = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getJniFolders());
        Collection<BuildOutput> manifestOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)this.manifestType, this.manifests);
        this.doTask(apkData, incrementalDirForSplit, outputFile, cacheByPath, manifestOutputs, (ImmutableMap<RelativeFile, FileStatus>)updatedDex, updatedJavaResources, (ImmutableMap<RelativeFile, FileStatus>)updatedAssets, (ImmutableMap<RelativeFile, FileStatus>)updatedAndroidResources, (ImmutableMap<RelativeFile, FileStatus>)updatedJniResources);
        KnownFilesSaveData saveData = KnownFilesSaveData.make(incrementalDirForSplit);
        saveData.setInputSet((Collection<RelativeFile>)updatedDex.keySet(), KnownFilesSaveData.InputSet.DEX);
        saveData.setInputSet((Collection<RelativeFile>)updatedJavaResources.keySet(), KnownFilesSaveData.InputSet.JAVA_RESOURCE);
        saveData.setInputSet((Collection<RelativeFile>)updatedAssets.keySet(), KnownFilesSaveData.InputSet.ASSET);
        saveData.setInputSet((Collection<RelativeFile>)updatedAndroidResources.keySet(), KnownFilesSaveData.InputSet.ANDROID_RESOURCE);
        saveData.setInputSet((Collection<RelativeFile>)updatedJniResources.keySet(), KnownFilesSaveData.InputSet.NATIVE_RESOURCE);
        saveData.saveCurrentData();
        this.recordMetrics(outputFile, processedResources);
        return outputFile;
    }

    abstract void recordMetrics(File var1, File var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static File copyJavaResourcesOnly(File destinationFolder, File zip64File) throws IOException {
        File cacheDir = new File(destinationFolder, ZIP_64_COPY_DIR);
        File copiedZip = new File(cacheDir, zip64File.getName());
        FileUtils.mkdirs((File)copiedZip.getParentFile());
        try (ZipFile inFile = new ZipFile(zip64File);
             ZipOutputStream outFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(copiedZip)));){
            Enumeration<? extends ZipEntry> entries = inFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.getName().endsWith(".class")) continue;
                outFile.putNextEntry(new ZipEntry(zipEntry.getName()));
                try {
                    ByteStreams.copy((InputStream)new BufferedInputStream(inFile.getInputStream(zipEntry)), (OutputStream)outFile);
                }
                finally {
                    outFile.closeEntry();
                }
            }
        }
        return copiedZip;
    }

    ImmutableMap<RelativeFile, FileStatus> getJavaResourcesChanges() throws IOException {
        ImmutableMap.Builder updatedJavaResourcesBuilder = ImmutableMap.builder();
        for (File javaResourceFile : this.getJavaResourceFiles()) {
            try {
                updatedJavaResourcesBuilder.putAll((Map)(javaResourceFile.isFile() ? IncrementalRelativeFileSets.fromZip((File)javaResourceFile) : IncrementalRelativeFileSets.fromDirectory((File)javaResourceFile)));
            }
            catch (Zip64NotSupportedException e) {
                updatedJavaResourcesBuilder.putAll((Map)IncrementalRelativeFileSets.fromZip((File)PackageAndroidArtifact.copyJavaResourcesOnly(this.getIncrementalFolder(), javaResourceFile)));
            }
        }
        return updatedJavaResourcesBuilder.build();
    }

    private void doTask(ApkData apkData, File incrementalDirForSplit, File outputFile, FileCacheByPath cacheByPath, Collection<BuildOutput> manifestOutputs, ImmutableMap<RelativeFile, FileStatus> changedDex, ImmutableMap<RelativeFile, FileStatus> changedJavaResources, ImmutableMap<RelativeFile, FileStatus> changedAssets, ImmutableMap<RelativeFile, FileStatus> changedAndroidResources, ImmutableMap<RelativeFile, FileStatus> changedNLibs) throws IOException {
        ImmutableMap.Builder javaResourcesForApk = ImmutableMap.builder();
        javaResourcesForApk.putAll(changedJavaResources);
        if (this.dexPackagingPolicy == DexPackagingPolicy.INSTANT_RUN_MULTI_APK) {
            changedDex = ImmutableMap.copyOf((Map)Maps.filterKeys(changedDex, (Predicate)Predicates.compose((Predicate)Predicates.in((Collection)this.getDexFolders().getFiles()), RelativeFile::getBase)));
        }
        ImmutableMap dexFilesToPackage = changedDex;
        String abiFilter = apkData.getFilter(VariantOutput.FilterType.ABI);
        BuildOutput manifestForSplit = SplitScope.getOutput(manifestOutputs, (TaskOutputHolder.OutputType)this.manifestType, (ApkInfo)apkData);
        if (manifestForSplit == null || manifestForSplit.getOutputFile() == null) {
            throw new RuntimeException("Found a .ap_ for split " + apkData + " but no " + this.manifestType + " associated manifest file");
        }
        FileUtils.mkdirs((File)outputFile.getParentFile());
        try (IncrementalPackager packager = new IncrementalPackagerBuilder().withOutputFile(outputFile).withSigning(this.signingConfig).withCreatedBy(this.getBuilder().getCreatedBy()).withMinSdk(this.getMinSdkVersion()).withNativeLibraryPackagingMode(PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)manifestForSplit.getOutputFile())).withNoCompressPredicate(PackagingUtils.getNoCompressPredicate(this.aaptOptionsNoCompress, (File)manifestForSplit.getOutputFile())).withIntermediateDir(incrementalDirForSplit).withProject(this.getProject()).withDebuggableBuild(this.getDebugBuild()).withAcceptedAbis((Set<String>)(abiFilter == null ? this.abiFilters : ImmutableSet.of((Object)abiFilter))).withJniDebuggableBuild(this.getJniDebugBuild()).build();){
            packager.updateDex(dexFilesToPackage);
            packager.updateJavaResources(changedJavaResources);
            packager.updateAssets(changedAssets);
            packager.updateAndroidResources(changedAndroidResources);
            packager.updateNativeLibraries(changedNLibs);
            if (packager.hasPendingChangesWithWait()) {
                this.instantRunContext.addChangedFile(this.instantRunFileType, outputFile);
            }
        }
        Stream.concat(dexFilesToPackage.keySet().stream(), Stream.concat(changedJavaResources.keySet().stream(), Stream.concat(changedAndroidResources.keySet().stream(), changedNLibs.keySet().stream()))).map(RelativeFile::getBase).filter(File::isFile).distinct().forEach(f -> {
            try {
                cacheByPath.add(f);
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        });
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        Preconditions.checkNotNull(changedInputs, (Object)"changedInputs == null");
        this.splitScope.parallelForEachOutput(BuildOutputs.load((TaskOutputHolder.OutputType)this.getTaskInputType(), this.resourceFiles), this.getTaskInputType(), this.getTaskOutputType(), (split, output) -> this.splitIncrementalAction(split, output, changedInputs));
        this.splitScope.save(this.getTaskOutputType(), this.outputDirectory);
    }

    private File splitIncrementalAction(ApkData apkData, File resourceFile, Map<File, FileStatus> changedInputs) throws IOException {
        ImmutableMap<RelativeFile, FileStatus> changedJavaResources;
        File incrementalDirForSplit;
        File cacheByPathDir;
        HashSet<File> androidResources = new HashSet<File>();
        if (resourceFile != null) {
            androidResources.add(resourceFile);
        }
        if (!(cacheByPathDir = new File(incrementalDirForSplit = new File(this.getIncrementalFolder(), apkData.getFullName()), ZIP_DIFF_CACHE_DIR)).exists()) {
            FileUtils.mkdirs((File)cacheByPathDir);
        }
        FileCacheByPath cacheByPath = new FileCacheByPath(cacheByPathDir);
        KnownFilesSaveData saveData = KnownFilesSaveData.make(incrementalDirForSplit);
        Set assetsFiles = this.assets.getFiles();
        HashSet<Runnable> cacheUpdates = new HashSet<Runnable>();
        ImmutableMap<RelativeFile, FileStatus> changedDexFiles = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.DEX, this.getDexFolders().getFiles(), cacheByPath, cacheUpdates);
        try {
            changedJavaResources = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.JAVA_RESOURCE, this.getJavaResourceFiles().getFiles(), cacheByPath, cacheUpdates);
        }
        catch (Zip64NotSupportedException e) {
            ImmutableMap.Builder copiedInputs = ImmutableMap.builder();
            for (Map.Entry<File, FileStatus> fileFileStatusEntry : changedInputs.entrySet()) {
                copiedInputs.put((Object)PackageAndroidArtifact.copyJavaResourcesOnly(this.getIncrementalFolder(), fileFileStatusEntry.getKey()), (Object)fileFileStatusEntry.getValue());
            }
            changedJavaResources = KnownFilesSaveData.getChangedInputs((Map<File, FileStatus>)copiedInputs.build(), saveData, KnownFilesSaveData.InputSet.JAVA_RESOURCE, this.getJavaResourceFiles().getFiles(), cacheByPath, cacheUpdates);
        }
        ImmutableMap<RelativeFile, FileStatus> changedAssets = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.ASSET, assetsFiles, cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedAndroidResources = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.ANDROID_RESOURCE, androidResources, cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedNLibs = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.NATIVE_RESOURCE, this.getJniFolders().getFiles(), cacheByPath, cacheUpdates);
        Objects.requireNonNull(this.outputFiles);
        File outputFile = this.outputFiles.get(apkData);
        Collection<BuildOutput> manifestOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)this.manifestType, this.manifests);
        this.doTask(apkData, incrementalDirForSplit, outputFile, cacheByPath, manifestOutputs, changedDexFiles, changedJavaResources, changedAssets, changedAndroidResources, changedNLibs);
        cacheUpdates.forEach(Runnable::run);
        ImmutableMap allDex = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getDexFolders());
        ImmutableMap allJavaResources = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getJavaResourceFiles());
        ImmutableMap allAssets = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)assetsFiles);
        ImmutableMap allAndroidResources = IncrementalRelativeFileSets.fromZipsAndDirectories(androidResources);
        ImmutableMap allJniResources = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getJniFolders());
        saveData.setInputSet((Collection<RelativeFile>)allDex.keySet(), KnownFilesSaveData.InputSet.DEX);
        saveData.setInputSet((Collection<RelativeFile>)allJavaResources.keySet(), KnownFilesSaveData.InputSet.JAVA_RESOURCE);
        saveData.setInputSet((Collection<RelativeFile>)allAssets.keySet(), KnownFilesSaveData.InputSet.ASSET);
        saveData.setInputSet((Collection<RelativeFile>)allAndroidResources.keySet(), KnownFilesSaveData.InputSet.ANDROID_RESOURCE);
        saveData.setInputSet((Collection<RelativeFile>)allJniResources.keySet(), KnownFilesSaveData.InputSet.NATIVE_RESOURCE);
        saveData.saveCurrentData();
        this.recordMetrics(outputFile, resourceFile);
        return outputFile;
    }

    public static abstract class ConfigAction<T extends PackageAndroidArtifact>
    implements TaskConfigAction<T> {
        protected final Project project;
        protected final PackagingScope packagingScope;
        protected final DexPackagingPolicy dexPackagingPolicy;
        protected final FileCollection manifests;
        protected final TaskOutputHolder.TaskOutputType inputResourceFilesType;
        protected final FileCollection resourceFiles;
        protected final File outputDirectory;
        protected final SplitScope splitScope;
        private final TaskOutputHolder.TaskOutputType manifestType;

        public ConfigAction(PackagingScope packagingScope, File outputDirectory, InstantRunPatchingPolicy patchingPolicy, TaskOutputHolder.TaskOutputType inputResourceFilesType, FileCollection resourceFiles, FileCollection manifests, TaskOutputHolder.TaskOutputType manifestType, SplitScope splitScope) {
            this.project = packagingScope.getProject();
            this.packagingScope = (PackagingScope)Preconditions.checkNotNull((Object)packagingScope);
            this.inputResourceFilesType = inputResourceFilesType;
            this.dexPackagingPolicy = patchingPolicy == null ? DexPackagingPolicy.STANDARD : patchingPolicy.getDexPatchingPolicy();
            this.manifests = manifests;
            this.outputDirectory = outputDirectory;
            this.resourceFiles = resourceFiles;
            this.splitScope = splitScope;
            this.manifestType = manifestType;
        }

        @Override
        public void execute(T packageAndroidArtifact) {
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).instantRunFileType = FileType.MAIN;
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).taskInputType = this.inputResourceFilesType;
            ((BaseTask)((Object)packageAndroidArtifact)).setAndroidBuilder(this.packagingScope.getAndroidBuilder());
            ((DefaultAndroidTask)((Object)packageAndroidArtifact)).setVariantName(this.packagingScope.getFullVariantName());
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).setMinSdkVersion(this.packagingScope.getMinSdkVersion());
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).instantRunContext = this.packagingScope.getInstantRunBuildContext();
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).dexPackagingPolicy = this.dexPackagingPolicy;
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).instantRunSupportDir = this.packagingScope.getInstantRunSupportDir();
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).resourceFiles = this.resourceFiles;
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).outputDirectory = this.outputDirectory;
            ((IncrementalTask)((Object)packageAndroidArtifact)).setIncrementalFolder(this.packagingScope.getIncrementalDir(packageAndroidArtifact.getName()));
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).splitScope = this.splitScope;
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).aaptOptionsNoCompress = this.packagingScope.getAaptOptions().getNoCompress();
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).manifests = this.manifests;
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).dexFolders = this.packagingScope.getDexFolders();
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).javaResourceFiles = this.packagingScope.getJavaResources();
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).assets = this.packagingScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_ASSETS);
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).setAbiFilters(this.packagingScope.getSupportedAbis());
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).setJniDebugBuild(this.packagingScope.isJniDebuggable());
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).setDebugBuild(this.packagingScope.isDebuggable());
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).setPackagingOptions(this.packagingScope.getPackagingOptions());
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).projectBaseName = this.packagingScope.getProjectBaseName();
            ((PackageAndroidArtifact)((Object)packageAndroidArtifact)).manifestType = this.manifestType;
            this.packagingScope.addTask(TaskContainer.TaskKind.PACKAGE_ANDROID_ARTIFACT, (Task)packageAndroidArtifact);
            this.configure(packageAndroidArtifact);
        }

        protected void configure(T task) {
            ImmutableSet<String> filters;
            ((PackageAndroidArtifact)((Object)task)).instantRunFileType = FileType.MAIN;
            ((PackageAndroidArtifact)((Object)task)).dexPackagingPolicy = this.dexPackagingPolicy;
            ((PackageAndroidArtifact)((Object)task)).dexFolders = this.packagingScope.getDexFolders();
            ((PackageAndroidArtifact)((Object)task)).javaResourceFiles = this.packagingScope.getJavaResources();
            ((PackageAndroidArtifact)((Object)task)).jniFolders = this.packagingScope.getSplitHandlingPolicy() == SplitHandlingPolicy.PRE_21_POLICY ? this.packagingScope.getJniFolders() : ((filters = AbiSplitOptions.getAbiFilters(this.packagingScope.getAbiFilters())).isEmpty() ? this.packagingScope.getJniFolders() : this.project.files(new Object[0]));
            ((PackageAndroidArtifact)((Object)task)).setSigningConfig(this.packagingScope.getSigningConfig());
        }
    }

    static interface OutputFileProvider {
        public File getOutputFile(ApkData var1);
    }
}

