/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.internal.api.ReadOnlyBaseConfig;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.ReadOnlyVectorDrawablesOptions;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.VectorDrawablesOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ReadOnlyProductFlavor
extends ReadOnlyBaseConfig
implements ProductFlavor {
    final ProductFlavor productFlavor;
    private final ReadOnlyObjectProvider readOnlyObjectProvider;

    ReadOnlyProductFlavor(ProductFlavor productFlavor, ReadOnlyObjectProvider readOnlyObjectProvider) {
        super((BaseConfig)productFlavor);
        this.productFlavor = productFlavor;
        this.readOnlyObjectProvider = readOnlyObjectProvider;
    }

    public String getApplicationId() {
        return this.productFlavor.getApplicationId();
    }

    public Integer getVersionCode() {
        return this.productFlavor.getVersionCode();
    }

    public String getVersionName() {
        return this.productFlavor.getVersionName();
    }

    public ApiVersion getMinSdkVersion() {
        return this.productFlavor.getMinSdkVersion();
    }

    public ApiVersion getTargetSdkVersion() {
        return this.productFlavor.getTargetSdkVersion();
    }

    public Integer getMaxSdkVersion() {
        return this.productFlavor.getMaxSdkVersion();
    }

    public Integer getRenderscriptTargetApi() {
        return this.productFlavor.getRenderscriptTargetApi();
    }

    public Boolean getRenderscriptSupportModeEnabled() {
        return this.productFlavor.getRenderscriptSupportModeEnabled();
    }

    public Boolean getRenderscriptSupportModeBlasEnabled() {
        return this.productFlavor.getRenderscriptSupportModeBlasEnabled();
    }

    public Boolean getRenderscriptNdkModeEnabled() {
        return this.productFlavor.getRenderscriptNdkModeEnabled();
    }

    public String getTestApplicationId() {
        return this.productFlavor.getTestApplicationId();
    }

    public String getTestInstrumentationRunner() {
        return this.productFlavor.getTestInstrumentationRunner();
    }

    public Map<String, String> getTestInstrumentationRunnerArguments() {
        return ImmutableMap.copyOf((Map)this.productFlavor.getTestInstrumentationRunnerArguments());
    }

    public Boolean getTestHandleProfiling() {
        return this.productFlavor.getTestHandleProfiling();
    }

    public Boolean getTestFunctionalTest() {
        return this.productFlavor.getTestFunctionalTest();
    }

    public Collection<String> getResourceConfigurations() {
        return ImmutableList.copyOf((Collection)this.productFlavor.getResourceConfigurations());
    }

    public SigningConfig getSigningConfig() {
        return this.readOnlyObjectProvider.getSigningConfig(this.productFlavor.getSigningConfig());
    }

    public VectorDrawablesOptions getVectorDrawables() {
        return new ReadOnlyVectorDrawablesOptions(this.productFlavor.getVectorDrawables());
    }

    public String getDimension() {
        return this.productFlavor.getDimension();
    }

    public List<File> getJarJarRuleFiles() {
        return ImmutableList.copyOf((Collection)this.productFlavor.getJarJarRuleFiles());
    }

    @Deprecated
    public String getFlavorDimension() {
        return this.productFlavor.getDimension();
    }

    public Boolean getWearAppUnbundled() {
        return this.productFlavor.getWearAppUnbundled();
    }
}

