/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.model.SourceProvider;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TestDataImpl
extends AbstractTestDataImpl {
    private final TestVariantData testVariantData;
    private final VariantConfiguration testVariantConfig;

    public TestDataImpl(TestVariantData testVariantData) {
        super(testVariantData.getVariantConfiguration());
        this.testVariantData = testVariantData;
        this.testVariantConfig = testVariantData.getVariantConfiguration();
        if (testVariantData.getOutputScope().getSplitsByType(VariantOutput.OutputType.FULL_SPLIT).size() > 1) {
            throw new RuntimeException("Multi-output in test variant not yet supported");
        }
    }

    public void loadFromMetadataFile(File metadataFile) throws ParserConfigurationException, SAXException, IOException {
    }

    public String getApplicationId() {
        return this.testVariantData.getApplicationId();
    }

    public String getTestedApplicationId() {
        return this.testVariantConfig.getTestedApplicationId();
    }

    public boolean isLibrary() {
        TestedVariantData testedVariantData = this.testVariantData.getTestedVariantData();
        BaseVariantData testedVariantData2 = (BaseVariantData)((Object)testedVariantData);
        return testedVariantData2.getVariantConfiguration().getType() == VariantType.LIBRARY;
    }

    public ImmutableList<File> getTestedApks(ProcessExecutor processExecutor, File splitSelectExe, DeviceConfigProvider deviceConfigProvider, ILogger logger) throws ProcessException {
        BaseVariantData testedVariantData = (BaseVariantData)((Object)this.testVariantData.getTestedVariantData());
        ImmutableList.Builder apks = ImmutableList.builder();
        ImmutableList splitOutputs = ImmutableList.copyOf(BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.APK, testedVariantData.getScope().getOutput(TaskOutputHolder.TaskOutputType.APK)));
        apks.addAll((Iterable)SplitOutputMatcher.computeBestOutput((ProcessExecutor)processExecutor, (File)splitSelectExe, (DeviceConfigProvider)deviceConfigProvider, (Collection)splitOutputs, testedVariantData.getVariantConfiguration().getSupportedAbis()));
        return apks.build();
    }

    public File getTestApk() {
        Optional<File> testApkFile = this.testVariantData.getScope().getOutput(TaskOutputHolder.TaskOutputType.APK).getAsFileTree().getFiles().stream().filter(file -> file.getName().endsWith(".apk")).findFirst();
        if (!testApkFile.isPresent()) {
            throw new RuntimeException("Cannot find test APK file in scope");
        }
        return testApkFile.get();
    }

    public List<File> getTestDirectories() {
        GradleVariantConfiguration variantConfiguration = this.testVariantData.getVariantConfiguration();
        ImmutableList.Builder javaDirectories = ImmutableList.builder();
        for (SourceProvider sourceProvider : variantConfiguration.getSortedSourceProviders()) {
            javaDirectories.addAll((Iterable)sourceProvider.getJavaDirectories());
        }
        return javaDirectories.build();
    }
}

