/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker.tracing;

import com.android.build.gradle.shrinker.tracing.Trace;
import com.android.build.gradle.shrinker.tracing.Tracer;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RealTracer<T>
implements Tracer<T> {
    private final Set<T> nodesToExplain;
    private final Map<T, Trace<T>> traces;

    public RealTracer(Set<T> nodesToExplain) {
        this.nodesToExplain = nodesToExplain;
        this.traces = new ConcurrentHashMap<T, Trace<T>>();
    }

    @Override
    public Trace<T> startTrace() {
        return new Trace<Object>(null, null, null);
    }

    @Override
    public void nodeReached(T node, Trace<T> trace) {
        Verify.verify((boolean)node.equals(trace.node), (String)"Trace does not end with the node.", (Object[])new Object[0]);
        if (this.nodesToExplain.contains(node)) {
            Verify.verify((!this.traces.containsKey(node) ? 1 : 0) != 0, (String)"Node %s already recorded.", (Object[])new Object[]{node});
            this.traces.put(node, trace);
        }
    }

    @Override
    public Map<T, Trace<T>> getRecordedTraces() {
        return this.traces;
    }
}

