/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.builder.model.AaptOptions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class AaptOptionsImpl
implements AaptOptions,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String ignoreAssets;
    private final Collection<String> noCompress;
    private final boolean failOnMissingConfigEntry;
    private final List<String> additionalParameters;
    private final AaptOptions.Namespacing namespacing;

    public static AaptOptions create(com.android.build.gradle.internal.dsl.AaptOptions aaptOptions) {
        return new AaptOptionsImpl(aaptOptions.getIgnoreAssets(), aaptOptions.getNoCompress(), aaptOptions.getFailOnMissingConfigEntry(), aaptOptions.getAdditionalParameters(), Boolean.TRUE.equals(aaptOptions.getNamespaced()) ? AaptOptions.Namespacing.REQUIRED : AaptOptions.Namespacing.DISABLED);
    }

    public AaptOptionsImpl(String ignoreAssets, Collection<String> noCompress, boolean failOnMissingConfigEntry, List<String> additionalParameters, AaptOptions.Namespacing namespacing) {
        this.ignoreAssets = ignoreAssets;
        this.failOnMissingConfigEntry = failOnMissingConfigEntry;
        this.noCompress = noCompress == null ? null : ImmutableList.copyOf(noCompress);
        this.additionalParameters = additionalParameters == null ? ImmutableList.of() : additionalParameters;
        this.namespacing = namespacing;
    }

    public String getIgnoreAssets() {
        return this.ignoreAssets;
    }

    public Collection<String> getNoCompress() {
        return this.noCompress;
    }

    public boolean getFailOnMissingConfigEntry() {
        return this.failOnMissingConfigEntry;
    }

    public List<String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public AaptOptions.Namespacing getNamespacing() {
        return this.namespacing;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ignoreAssets", (Object)this.ignoreAssets).add("noCompress", this.noCompress).add("failOnMissingConfigEntry", this.failOnMissingConfigEntry).add("additionalParameters", this.additionalParameters).add("namespacing", (Object)this.namespacing).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AaptOptionsImpl)) {
            return false;
        }
        AaptOptionsImpl that = (AaptOptionsImpl)o;
        return this.failOnMissingConfigEntry == that.failOnMissingConfigEntry && Objects.equals(this.ignoreAssets, that.ignoreAssets) && Objects.equals(this.noCompress, that.noCompress) && Objects.equals(this.additionalParameters, that.additionalParameters) && this.namespacing == that.namespacing;
    }

    public int hashCode() {
        return Objects.hash(this.ignoreAssets, this.noCompress, this.failOnMissingConfigEntry, this.additionalParameters, this.namespacing);
    }
}

