/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BuildOutput
implements OutputFile,
Serializable {
    private final TaskOutputHolder.OutputType outputType;
    private final ApkInfo apkInfo;
    private final File outputFile;
    private final Map<String, String> properties;

    public BuildOutput(TaskOutputHolder.OutputType outputType, ApkInfo apkInfo, File outputFile) {
        this(outputType, apkInfo, outputFile, (Map<String, String>)ImmutableMap.of());
    }

    public BuildOutput(TaskOutputHolder.OutputType outputType, ApkInfo apkInfo, File outputFile, Map<String, String> properties) {
        this.outputType = outputType;
        this.apkInfo = apkInfo;
        this.outputFile = outputFile;
        this.properties = properties;
    }

    public ApkInfo getApkInfo() {
        return this.apkInfo;
    }

    public File getOutputFile() {
        return new File(this.outputFile.getPath());
    }

    public TaskOutputHolder.OutputType getType() {
        return this.outputType;
    }

    public String getOutputType() {
        return this.apkInfo.getType().toString();
    }

    public Collection<String> getFilterTypes() {
        return this.apkInfo.getFilters().stream().map(FilterData::getFilterType).collect(Collectors.toList());
    }

    public Collection<FilterData> getFilters() {
        return this.apkInfo.getFilters();
    }

    public String getFilter(String filterType) {
        return ApkData.getFilter((Collection)this.apkInfo.getFilters(), (VariantOutput.FilterType)VariantOutput.FilterType.valueOf((String)filterType));
    }

    @Deprecated
    public OutputFile getMainOutputFile() {
        return this;
    }

    @Deprecated
    public Collection<? extends OutputFile> getOutputs() {
        return ImmutableList.of((Object)this);
    }

    public int getVersionCode() {
        return this.apkInfo.getVersionCode();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("apkInfo", (Object)this.apkInfo).add("outputFile", (Object)this.outputFile).add("properties", (Object)Joiner.on((String)",").join(this.properties.entrySet())).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildOutput that = (BuildOutput)o;
        return this.outputType == that.outputType && Objects.equals(this.properties, that.properties) && Objects.equals(this.apkInfo, that.apkInfo) && Objects.equals(this.outputFile, that.outputFile);
    }

    public int hashCode() {
        return Objects.hash(this.outputType, this.apkInfo, this.outputFile, this.properties);
    }
}

