/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexingType;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.process.ProcessOutput;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;

class DexMergerTransformCallable
implements Callable<Void> {
    private final DexingType dexingType;
    private final ProcessOutput processOutput;
    private final File dexOutputDir;
    private final Collection<Path> dexArchives;
    private final ForkJoinPool forkJoinPool;
    private final Path mainDexList;
    private final DexMergerTool dexMerger;

    public DexMergerTransformCallable(DexingType dexingType, ProcessOutput processOutput, File dexOutputDir, Collection<Path> dexArchives, Path mainDexList, ForkJoinPool forkJoinPool, DexMergerTool dexMerger) {
        this.dexingType = dexingType;
        this.processOutput = processOutput;
        this.dexOutputDir = dexOutputDir;
        this.dexArchives = dexArchives;
        this.mainDexList = mainDexList;
        this.forkJoinPool = forkJoinPool;
        this.dexMerger = dexMerger;
    }

    @Override
    public Void call() throws Exception {
        DexArchiveMerger merger;
        switch (this.dexMerger) {
            case DX: {
                DxContext dxContext = new DxContext(this.processOutput.getStandardOutput(), this.processOutput.getErrorOutput());
                merger = DexArchiveMerger.createDxDexMerger((DxContext)dxContext, (ForkJoinPool)this.forkJoinPool);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown dex merger " + this.dexMerger.name()));
            }
        }
        merger.mergeDexArchives(this.dexArchives, this.dexOutputDir.toPath(), this.mainDexList, this.dexingType);
        return null;
    }
}

