/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.tasks.annotations.TypedefRemover;
import com.android.builder.packaging.ZipAbortException;
import com.android.builder.packaging.ZipEntryFilter;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.io.Closer;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarMerger {
    private final byte[] buffer = new byte[8192];
    public static final FileTime ZERO_TIME = FileTime.fromMillis(0L);
    private final ILogger logger = LoggerWrapper.getLogger(JarMerger.class);
    private final File jarFile;
    private Closer closer;
    private JarOutputStream jarOutputStream;
    private ZipEntryFilter filter;
    private TypedefRemover typedefRemover;

    public JarMerger(File jarFile) throws IOException {
        this.jarFile = jarFile;
    }

    public void setTypedefRemover(TypedefRemover typedefRemover) {
        this.typedefRemover = typedefRemover;
    }

    private void init() throws IOException {
        if (this.closer == null) {
            FileUtils.mkdirs((File)this.jarFile.getParentFile());
            this.closer = Closer.create();
            FileOutputStream fos = (FileOutputStream)this.closer.register((Closeable)new FileOutputStream(this.jarFile));
            BufferedOutputStream bos = (BufferedOutputStream)this.closer.register((Closeable)new BufferedOutputStream(fos));
            this.jarOutputStream = (JarOutputStream)this.closer.register((Closeable)new JarOutputStream(bos));
        }
    }

    public void setFilter(ZipEntryFilter filter) {
        this.filter = filter;
    }

    public void addFolder(File folder) throws IOException {
        this.init();
        try {
            this.addFolder(folder, "");
        }
        catch (ZipAbortException e) {
            throw new IOException(e);
        }
    }

    private void addFolder(File folder, String path) throws IOException, ZipAbortException {
        this.logger.verbose("addFolder(%1$s, %2$s)", new Object[]{folder, path});
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    String entryPath = path + file.getName();
                    if (this.filter != null && !this.filter.checkEntry(entryPath)) continue;
                    this.logger.verbose("addFolder(%1$s, %2$s): entry %3$s", new Object[]{folder, path, entryPath});
                    if (this.typedefRemover != null && this.typedefRemover.isRemoved(entryPath)) continue;
                    JarEntry jarEntry = new JarEntry(entryPath);
                    jarEntry.setLastModifiedTime(ZERO_TIME);
                    jarEntry.setLastAccessTime(ZERO_TIME);
                    jarEntry.setCreationTime(ZERO_TIME);
                    this.jarOutputStream.putNextEntry(jarEntry);
                    try (Closer localCloser = Closer.create();){
                        int count;
                        InputStream fis = (InputStream)localCloser.register((Closeable)new FileInputStream(file));
                        if (this.typedefRemover != null) {
                            fis = this.typedefRemover.filter(entryPath, fis);
                            assert (fis != null);
                        }
                        while ((count = fis.read(this.buffer)) != -1) {
                            this.jarOutputStream.write(this.buffer, 0, count);
                        }
                    }
                    this.jarOutputStream.closeEntry();
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.addFolder(file, path + file.getName() + "/");
            }
        }
    }

    public void addJar(File file) throws IOException {
        this.logger.verbose("addJar(%1$s)", new Object[]{file});
        this.init();
        try (Closer localCloser = Closer.create();){
            ZipEntry entry;
            FileInputStream fis = (FileInputStream)localCloser.register((Closeable)new FileInputStream(file));
            ZipInputStream zis = (ZipInputStream)localCloser.register((Closeable)new ZipInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (this.filter != null && !this.filter.checkEntry(name)) continue;
                JarEntry newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                newEntry.setLastModifiedTime(ZERO_TIME);
                newEntry.setLastAccessTime(ZERO_TIME);
                newEntry.setCreationTime(ZERO_TIME);
                this.logger.verbose("addJar(%1$s): entry %2$s", new Object[]{file, name});
                this.jarOutputStream.putNextEntry(newEntry);
                while ((count = zis.read(this.buffer)) != -1) {
                    this.jarOutputStream.write(this.buffer, 0, count);
                }
                this.jarOutputStream.closeEntry();
                zis.closeEntry();
            }
        }
        catch (ZipAbortException e) {
            throw new IOException(e);
        }
    }

    public void addEntry(String path, byte[] bytes) throws IOException {
        this.init();
        this.jarOutputStream.putNextEntry(new JarEntry(path));
        this.jarOutputStream.write(bytes);
        this.jarOutputStream.closeEntry();
    }

    public void close() throws IOException {
        if (this.closer != null) {
            this.closer.close();
        }
    }
}

