/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.SplitList;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.tasks.ResourceUsageAnalyzer;
import com.android.builder.core.VariantType;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;

public class ShrinkResourcesTransform
extends Transform {
    private static boolean ourWarned = true;
    private final BaseVariantData variantData;
    private final Logger logger;
    private final File sourceDir;
    private final File resourceDir;
    private final FileCollection mappingFileSrc;
    private final FileCollection mergedManifests;
    private final FileCollection uncompressedResources;
    private final FileCollection splitListInput;
    private final AaptGeneration aaptGeneration;
    private final AaptOptions aaptOptions;
    private final VariantType variantType;
    private final boolean isDebuggableBuildType;
    private final MultiOutputPolicy multiOutputPolicy;
    private final File compressedResources;

    public ShrinkResourcesTransform(BaseVariantData variantData, FileCollection uncompressedResources, File compressedResources, AaptGeneration aaptGeneration, FileCollection splitListInput, Logger logger) {
        VariantScope variantScope = variantData.getScope();
        GlobalScope globalScope = variantScope.getGlobalScope();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        this.variantData = variantData;
        this.logger = logger;
        this.sourceDir = variantScope.getRClassSourceOutputDir();
        this.resourceDir = (File)Preconditions.checkNotNull((Object)variantScope.getResourceShrinkerInputFolder());
        this.mappingFileSrc = variantScope.hasOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING) ? variantScope.getOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING) : null;
        this.mergedManifests = variantScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS);
        this.uncompressedResources = uncompressedResources;
        this.splitListInput = splitListInput;
        this.aaptGeneration = aaptGeneration;
        this.aaptOptions = globalScope.getExtension().getAaptOptions();
        this.variantType = variantData.getType();
        this.isDebuggableBuildType = ((CoreBuildType)variantConfig.getBuildType()).isDebuggable();
        this.multiOutputPolicy = variantData.getOutputScope().getMultiOutputPolicy();
        this.compressedResources = compressedResources;
    }

    public String getName() {
        return "shrinkRes";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        LinkedList secondaryFiles = Lists.newLinkedList();
        secondaryFiles.add(SecondaryFile.nonIncremental((File)this.sourceDir));
        secondaryFiles.add(SecondaryFile.nonIncremental((File)this.resourceDir));
        if (this.mappingFileSrc != null) {
            secondaryFiles.add(SecondaryFile.nonIncremental((FileCollection)this.mappingFileSrc));
        }
        secondaryFiles.add(SecondaryFile.nonIncremental((FileCollection)this.mergedManifests));
        secondaryFiles.add(SecondaryFile.nonIncremental((FileCollection)this.uncompressedResources));
        secondaryFiles.add(SecondaryFile.nonIncremental((FileCollection)this.splitListInput));
        return secondaryFiles;
    }

    public Map<String, Object> getParameterInputs() {
        HashMap params = Maps.newHashMapWithExpectedSize((int)7);
        params.put("aaptGeneration", this.aaptGeneration.name());
        params.put("aaptOptions", Joiner.on((String)";").join((Object)(this.aaptOptions.getIgnoreAssetsPattern() != null ? this.aaptOptions.getIgnoreAssetsPattern() : ""), (Object)(this.aaptOptions.getNoCompress() != null ? Joiner.on((String)":").join(this.aaptOptions.getNoCompress()) : ""), new Object[]{this.aaptOptions.getFailOnMissingConfigEntry(), this.aaptOptions.getAdditionalParameters() != null ? Joiner.on((String)":").join(this.aaptOptions.getAdditionalParameters()) : "", this.aaptOptions.getCruncherProcesses()}));
        params.put("variantType", this.variantType.name());
        params.put("isDebuggableBuildType", this.isDebuggableBuildType);
        params.put("splitHandlingPolicy", this.multiOutputPolicy);
        return params;
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.compressedResources);
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        SplitList splitList = SplitList.load(this.splitListInput);
        Collection<BuildOutput> uncompressedBuildOutputs = BuildOutputs.load(this.uncompressedResources);
        OutputScope outputScope = this.variantData.getScope().getOutputScope();
        outputScope.parallelForEachOutput(uncompressedBuildOutputs, TaskOutputHolder.TaskOutputType.PROCESSED_RES, TaskOutputHolder.TaskOutputType.SHRUNK_PROCESSED_RES, this::splitAction, invocation, splitList);
        outputScope.save(TaskOutputHolder.TaskOutputType.SHRUNK_PROCESSED_RES, this.compressedResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File splitAction(ApkData apkData, File uncompressedResourceFile, TransformInvocation invocation, SplitList splitList) {
        File logDir;
        File mappingFile;
        if (uncompressedResourceFile == null) {
            return null;
        }
        Collection referencedInputs = invocation.getReferencedInputs();
        ArrayList<File> classes = new ArrayList<File>();
        for (TransformInput transformInput : referencedInputs) {
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                classes.add(directoryInput.getFile());
            }
            for (JarInput jarInput : transformInput.getJarInputs()) {
                classes.add(jarInput.getFile());
            }
        }
        File reportFile = null;
        File file = mappingFile = this.mappingFileSrc != null ? this.mappingFileSrc.getSingleFile() : null;
        if (mappingFile != null && (logDir = mappingFile.getParentFile()) != null) {
            reportFile = new File(logDir, "resources.txt");
        }
        File compressedResourceFile = new File(this.compressedResources, "resources-" + apkData.getBaseName() + "-stripped.ap_");
        FileUtils.mkdirs((File)compressedResourceFile.getParentFile());
        Collection<BuildOutput> mergedManifests = BuildOutputs.load(this.mergedManifests);
        BuildOutput mergedManifest = OutputScope.getOutput(mergedManifests, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, (ApkInfo)apkData);
        if (mergedManifest == null) {
            try {
                FileUtils.copyFile((File)uncompressedResourceFile, (File)compressedResourceFile);
            }
            catch (IOException e) {
                this.logger.error("Failed to copy uncompressed resource file :", (Throwable)e);
                throw new RuntimeException("Failed to copy uncompressed resource file", e);
            }
            return compressedResourceFile;
        }
        ResourceUsageAnalyzer analyzer = new ResourceUsageAnalyzer(this.sourceDir, classes, mergedManifest.getOutputFile(), mappingFile, this.resourceDir, reportFile);
        try {
            analyzer.setVerbose(this.logger.isEnabled(LogLevel.INFO));
            analyzer.setDebug(this.logger.isEnabled(LogLevel.DEBUG));
            analyzer.analyze();
            analyzer.rewriteResourceZip(uncompressedResourceFile, compressedResourceFile);
            int unused = analyzer.getUnusedResourceCount();
            if (unused > 0) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("Removed unused resources");
                long before = uncompressedResourceFile.length();
                long after = compressedResourceFile.length();
                long percent = (int)((before - after) * 100L / before);
                sb.append(": Binary resource data reduced from ").append(ShrinkResourcesTransform.toKbString(before)).append("KB to ").append(ShrinkResourcesTransform.toKbString(after)).append("KB: Removed ").append(percent).append("%");
                if (!ourWarned) {
                    ourWarned = true;
                    String name = ((CoreBuildType)this.variantData.getVariantConfiguration().getBuildType()).getName();
                    sb.append("\n").append("Note: If necessary, you can disable resource shrinking by adding\n").append("android {\n").append("    buildTypes {\n").append("        ").append(name).append(" {\n").append("            shrinkResources false\n").append("        }\n").append("    }\n").append("}");
                }
                System.out.println(sb.toString());
            }
        }
        catch (Exception e) {
            this.logger.quiet("Failed to shrink resources: ignoring", (Throwable)e);
        }
        finally {
            analyzer.dispose();
        }
        return compressedResourceFile;
    }

    private static String toKbString(long size) {
        return Integer.toString((int)size / 1024);
    }
}

