/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.builder.model.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public class JacocoReportTask
extends DefaultTask {
    private FileCollection jacocoClasspath;
    private Supplier<File> coverageDirectory;
    private Supplier<File> classDir;
    private Supplier<Collection<File>> sourceDir;
    private File coverageFile;
    private File reportDir;
    private String reportName;
    private int tabWidth = 4;

    @InputFile
    @Optional
    public File getCoverageFile() {
        return this.coverageFile;
    }

    public void setCoverageFile(File coverageFile) {
        this.coverageFile = coverageFile;
    }

    @InputDirectory
    @Optional
    public File getCoverageDirectory() {
        return this.coverageDirectory.get();
    }

    @OutputDirectory
    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    @InputDirectory
    public File getClassDir() {
        return this.classDir.get();
    }

    @InputFiles
    public Collection<File> getSourceDir() {
        return this.sourceDir.get();
    }

    public String getReportName() {
        return this.reportName;
    }

    @Input
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @InputFiles
    public FileCollection getJacocoClasspath() {
        return this.jacocoClasspath;
    }

    public void setJacocoClasspath(FileCollection jacocoClasspath) {
        this.jacocoClasspath = jacocoClasspath;
    }

    @Input
    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @TaskAction
    public void generateReport() throws IOException {
        File coverageFile = this.getCoverageFile();
        File coverageDir = this.coverageDirectory.get();
        ArrayList coverageFiles = Lists.newArrayList();
        if (coverageFile != null) {
            coverageFiles.add(coverageFile);
        }
        if (coverageDir != null) {
            Files.fileTreeTraverser().breadthFirstTraversal((Object)coverageDir).filter(File::isFile).copyInto((Collection)coverageFiles);
        }
        if (coverageFiles.isEmpty()) {
            if (coverageDir == null) {
                throw new IOException("No input file or directory specified.");
            }
            throw new IOException(String.format("No coverage data to process in directory '%1$s'", coverageDir));
        }
        JacocoReportTask.generateReport(coverageFiles, this.getReportDir(), this.classDir.get(), this.sourceDir.get(), this.getTabWidth(), this.getReportName(), this.getLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void generateReport(List<File> coverageFiles, File reportDir, File classDir, Collection<File> sourceDir, int tabWidth, String reportName, Logger logger) throws IOException {
        ExecFileLoader loader = new ExecFileLoader();
        for (File coverageFile : coverageFiles) {
            loader.load(coverageFile);
        }
        SessionInfoStore sessionInfoStore = loader.getSessionInfoStore();
        ExecutionDataStore executionDataStore = loader.getExecutionDataStore();
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding("UTF-8");
        htmlFormatter.setLocale(Locale.US);
        htmlFormatter.setFooterText("Generated by the Android Gradle plugin " + Version.ANDROID_GRADLE_PLUGIN_VERSION);
        FileMultiReportOutput output = new FileMultiReportOutput(reportDir);
        IReportVisitor htmlReport = htmlFormatter.createVisitor((IMultiReportOutput)output);
        XMLFormatter xmlFormatter = new XMLFormatter();
        xmlFormatter.setOutputEncoding("UTF-8");
        OutputStream xmlReportOutput = output.createFile("report.xml");
        try {
            IReportVisitor xmlReport = xmlFormatter.createVisitor(xmlReportOutput);
            MultiReportVisitor visitor = new MultiReportVisitor((List)ImmutableList.of((Object)htmlReport, (Object)xmlReport));
            visitor.visitInfo(sessionInfoStore.getInfos(), executionDataStore.getContents());
            CoverageBuilder builder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)builder);
            JacocoReportTask.analyzeAll(analyzer, classDir);
            MultiSourceFileLocator locator = new MultiSourceFileLocator(0);
            for (File file : sourceDir) {
                locator.add((ISourceFileLocator)new DirectorySourceFileLocator(file, "UTF-8", tabWidth));
            }
            IBundleCoverage bundle = builder.getBundle(reportName);
            visitor.visitBundle(bundle, (ISourceFileLocator)locator);
            visitor.visitEnd();
        }
        finally {
            try {
                xmlReportOutput.close();
            }
            catch (IOException e) {
                logger.error("Could not close xml report file", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void analyzeAll(Analyzer analyzer, File file) throws IOException {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                File[] files = file.listFiles();
                if (files == null) break block6;
                for (File f : files) {
                    JacocoReportTask.analyzeAll(analyzer, f);
                }
                break block6;
            }
            String name = file.getName();
            if (!name.endsWith(".class") || name.equals("R.class") || name.startsWith("R$") || name.equals("Manifest.class") || name.startsWith("Manifest$") || name.equals("BuildConfig.class")) {
                return;
            }
            FileInputStream in = new FileInputStream(file);
            try {
                analyzer.analyzeClass((InputStream)in, file.getAbsolutePath());
            }
            finally {
                Closeables.closeQuietly((InputStream)in);
            }
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<JacocoReportTask> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("create", "CoverageReport");
        }

        @Override
        public Class<JacocoReportTask> getType() {
            return JacocoReportTask.class;
        }

        @Override
        public void execute(JacocoReportTask task) {
            task.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
            task.setReportName(this.scope.getVariantConfiguration().getFullName());
            Project project = this.scope.getGlobalScope().getProject();
            Preconditions.checkNotNull((Object)this.scope.getTestedVariantData());
            VariantScope testedScope = this.scope.getTestedVariantData().getScope();
            task.jacocoClasspath = (FileCollection)project.getConfigurations().getAt("androidJacocoAnt");
            task.coverageDirectory = TaskInputHelper.memoize(() -> ((TestVariantData)this.scope.getVariantData()).connectedTestTask.getCoverageDir());
            task.classDir = TaskInputHelper.memoize(() -> testedScope.getVariantData().javacTask.getDestinationDir());
            task.sourceDir = TaskInputHelper.bypassFileSupplier(() -> testedScope.getVariantData().getJavaSourceFoldersForCoverage());
            task.setReportDir(testedScope.getCoverageReportDir());
        }
    }
}

