/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.externalBuild;

import com.android.build.gradle.internal.scope.TransformGlobalScope;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.utils.FileCache;
import java.io.File;
import java.util.Set;
import org.gradle.api.Project;

public class ExternalBuildGlobalScope
implements TransformGlobalScope {
    private final Project project;
    private final Set<OptionalCompilationStep> optionalCompilationSteps;
    private final ProjectOptions projectOptions;
    private final FileCache buildCache;

    public ExternalBuildGlobalScope(Project project, ProjectOptions projectOptions, FileCache buildCache) {
        this.project = project;
        this.projectOptions = projectOptions;
        this.buildCache = buildCache;
        this.optionalCompilationSteps = projectOptions.getOptionalCompilationSteps();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    @Override
    public boolean isActive(OptionalCompilationStep step) {
        return this.optionalCompilationSteps.contains(step);
    }

    @Override
    public ProjectOptions getProjectOptions() {
        return this.projectOptions;
    }

    @Override
    public FileCache getBuildCache() {
        return this.buildCache;
    }
}

