/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.external.gson.NativeLibraryValue;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.ide.NativeAndroidProjectImpl;
import com.android.build.gradle.internal.ide.NativeArtifactImpl;
import com.android.build.gradle.internal.ide.NativeFileImpl;
import com.android.build.gradle.internal.ide.NativeFolderImpl;
import com.android.build.gradle.internal.ide.NativeSettingsImpl;
import com.android.build.gradle.internal.ide.NativeToolchainImpl;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.ndk.internal.NativeCompilerArgsUtil;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.builder.Version;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class NativeModelBuilder
implements ToolingModelBuilder {
    private final VariantManager variantManager;

    public NativeModelBuilder(VariantManager variantManager) {
        this.variantManager = variantManager;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(NativeAndroidProject.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        return NativeAndroidProjectBuilder.build(project, this.variantManager);
    }

    private static class NativeAndroidProjectBuilder {
        private int settingIndex = 0;
        private final Set<File> buildFiles = Sets.newHashSet();
        private final Map<String, String> extensions = Maps.newHashMap();
        private final List<NativeArtifact> artifacts = Lists.newArrayList();
        private final List<NativeToolchain> toolChains = Lists.newArrayList();
        private final List<NativeBuildConfigValue> configValues = Lists.newArrayList();
        private final Map<List<String>, NativeSettings> settingsMap = Maps.newHashMap();

        private NativeAndroidProjectBuilder() {
        }

        private static NativeAndroidProject build(Project project, VariantManager variantManager) {
            NativeAndroidProjectBuilder info = new NativeAndroidProjectBuilder();
            HashSet buildSystems = Sets.newHashSet();
            for (VariantScope scope : variantManager.getVariantScopes()) {
                ExternalNativeJsonGenerator generator = scope.getExternalNativeJsonGenerator();
                if (generator != null) {
                    buildSystems.add(generator.getNativeBuildSystem().getName());
                }
                for (NativeBuildConfigValue configValue : scope.getExternalNativeBuildConfigValues()) {
                    if (configValue.buildFiles != null) {
                        info.buildFiles.addAll(configValue.buildFiles);
                    }
                    if (configValue.toolchains != null) {
                        for (String toolchainName : configValue.toolchains.keySet()) {
                            info.toolChains.add(new NativeToolchainImpl(toolchainName, configValue.toolchains.get((Object)toolchainName).cCompilerExecutable, configValue.toolchains.get((Object)toolchainName).cppCompilerExecutable));
                        }
                    }
                    if (configValue.libraries != null) {
                        for (String name : configValue.libraries.keySet()) {
                            NativeLibraryValue library = configValue.libraries.get(name);
                            info.artifacts.add(info.createNativeArtifact(name, library));
                        }
                    }
                    if (configValue.cFileExtensions != null) {
                        for (String ext : configValue.cFileExtensions) {
                            info.extensions.put(ext, "c");
                        }
                    }
                    if (configValue.cppFileExtensions != null) {
                        for (String ext : configValue.cppFileExtensions) {
                            info.extensions.put(ext, "c++");
                        }
                    }
                    info.configValues.add(configValue);
                }
            }
            if (info.buildFiles.isEmpty()) {
                return null;
            }
            return new NativeAndroidProjectImpl(Version.ANDROID_GRADLE_PLUGIN_VERSION, project.getName(), info.buildFiles, info.artifacts, info.toolChains, (Collection<NativeSettings>)ImmutableList.copyOf(info.settingsMap.values()), info.extensions, buildSystems, Version.BUILDER_MODEL_API_VERSION);
        }

        private NativeArtifact createNativeArtifact(String name, NativeLibraryValue library) {
            ArrayList<NativeFolder> folders = new ArrayList();
            if (library.folders != null) {
                folders = library.folders.stream().map(src -> {
                    Preconditions.checkNotNull((Object)src.src);
                    return new NativeFolderImpl(src.src, (Map<String, String>)ImmutableMap.of((Object)"c", (Object)this.getSettingsName(NativeAndroidProjectBuilder.convertFlagFormat(src.cFlags != null ? src.cFlags : "")), (Object)"c++", (Object)this.getSettingsName(NativeAndroidProjectBuilder.convertFlagFormat(src.cppFlags != null ? src.cppFlags : ""))), src.workingDirectory);
                }).collect(Collectors.toList());
            }
            ArrayList<NativeFile> files = new ArrayList();
            if (library.files != null) {
                files = library.files.stream().map(src -> {
                    Preconditions.checkNotNull((Object)src.src);
                    return new NativeFileImpl(src.src, this.getSettingsName(NativeAndroidProjectBuilder.convertFlagFormat(src.flags != null ? src.flags : "")), src.workingDirectory);
                }).collect(Collectors.toList());
            }
            Preconditions.checkNotNull((Object)library.toolchain);
            Preconditions.checkNotNull((Object)library.output);
            ImmutableList exportedHeaders = new ArrayList();
            if (library.exportedHeaders != null) {
                exportedHeaders = ImmutableList.copyOf(library.exportedHeaders);
            }
            Preconditions.checkState((!Strings.isNullOrEmpty((String)library.groupName) ? 1 : 0) != 0, (Object)"groupName missing");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)library.abi) ? 1 : 0) != 0, (Object)"abi missing");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)library.artifactName) ? 1 : 0) != 0, (Object)"artifactName missing");
            return new NativeArtifactImpl(name, library.toolchain, library.groupName, "", folders, files, (Collection<File>)exportedHeaders, library.output, (Collection<File>)(library.runtimeFiles == null ? ImmutableList.of() : ImmutableList.copyOf(library.runtimeFiles)), library.abi, library.artifactName);
        }

        private static List<String> convertFlagFormat(String flags) {
            return NativeCompilerArgsUtil.transform(StringHelper.tokenizeString((String)flags));
        }

        private String getSettingsName(List<String> flags) {
            ImmutableList flagsCopy = ImmutableList.copyOf(flags);
            NativeSettings setting = this.settingsMap.get(flags);
            if (setting == null) {
                setting = new NativeSettingsImpl("setting" + this.settingIndex, (List<String>)flagsCopy);
                this.settingsMap.put((List<String>)flagsCopy, setting);
                ++this.settingIndex;
            }
            return setting.getName();
        }
    }
}

