/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.gradle.internal.pipeline.QualifiedContentImpl;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.Set;

class ImmutableDirectoryInput
extends QualifiedContentImpl
implements DirectoryInput {
    private final Map<File, Status> changedFiles;

    ImmutableDirectoryInput(String name, File file, Set<QualifiedContent.ContentType> contentTypes, Set<? super QualifiedContent.Scope> scopes) {
        super(name, file, contentTypes, scopes);
        this.changedFiles = ImmutableMap.of();
    }

    protected ImmutableDirectoryInput(String name, File file, Set<QualifiedContent.ContentType> contentTypes, Set<? super QualifiedContent.Scope> scopes, Map<File, Status> changedFiles) {
        super(name, file, contentTypes, scopes);
        this.changedFiles = ImmutableMap.copyOf(changedFiles);
    }

    public Map<File, Status> getChangedFiles() {
        return this.changedFiles;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("file", (Object)this.getFile()).add("contentTypes", (Object)Joiner.on((char)',').join(this.getContentTypes())).add("scopes", (Object)Joiner.on((char)',').join(this.getScopes())).add("changedFiles", this.changedFiles).toString();
    }
}

