/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class MergeFileTask
extends DefaultAndroidTask {
    private Set<File> mInputFiles;
    private File mOutputFile;

    @TaskAction
    public void mergeFiles() throws IOException {
        Set<File> files = this.getInputFiles();
        File output = this.getOutputFile();
        if (files.size() == 1) {
            Files.copy((File)files.iterator().next(), (File)output);
            return;
        }
        output.delete();
        if (files.isEmpty()) {
            return;
        }
        for (File file : files) {
            String content = Files.toString((File)file, (Charset)Charsets.UTF_8);
            Files.append((CharSequence)content, (File)output, (Charset)Charsets.UTF_8);
            Files.append((CharSequence)"\n", (File)output, (Charset)Charsets.UTF_8);
        }
    }

    @InputFiles
    public Set<File> getInputFiles() {
        return this.mInputFiles;
    }

    public void setInputFiles(Set<File> inputFiles) {
        this.mInputFiles = inputFiles;
    }

    @OutputFile
    public File getOutputFile() {
        return this.mOutputFile;
    }

    public void setOutputFile(File outputFile) {
        this.mOutputFile = outputFile;
    }
}

