/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.build.gradle.internal.transforms.PreDexTransform;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.DexerTool;
import com.android.builder.utils.FileCache;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

class DexArchiveBuilderCacheHandler {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexArchiveBuilderTransform.class);
    private static final int CACHE_KEY_VERSION = 1;
    private final FileCache userLevelCache;
    private final DexOptions dexOptions;

    DexArchiveBuilderCacheHandler(FileCache userLevelCache, DexOptions dexOptions) {
        this.userLevelCache = userLevelCache;
        this.dexOptions = dexOptions;
    }

    File getCachedVersionIfPresent(JarInput input) throws IOException {
        FileCache cache = PreDexTransform.getBuildCache(input.getFile(), DexArchiveBuilderCacheHandler.isExternalLib((QualifiedContent)input), this.userLevelCache);
        if (cache == null) {
            return null;
        }
        FileCache.Inputs buildCacheInputs = DexArchiveBuilderCacheHandler.getBuildCacheInputs(input.getFile(), this.dexOptions, DexerTool.DX);
        return cache.cacheEntryExists(buildCacheInputs) ? cache.getFileInCache(buildCacheInputs) : null;
    }

    void populateCache(Multimap<QualifiedContent, File> cacheableItems) throws IOException, ExecutionException {
        for (QualifiedContent input : cacheableItems.keys()) {
            FileCache.Inputs buildCacheInputs;
            FileCache.QueryResult result;
            FileCache cache = PreDexTransform.getBuildCache(input.getFile(), DexArchiveBuilderCacheHandler.isExternalLib(input), this.userLevelCache);
            if (cache == null || !(result = cache.createFileInCacheIfAbsent(buildCacheInputs = DexArchiveBuilderCacheHandler.getBuildCacheInputs(input.getFile(), this.dexOptions, DexerTool.DX), in -> {
                Collection dexArchives = cacheableItems.get((Object)input);
                logger.verbose("Merging %1$s into %2$s", Joiner.on((char)',').join((Iterable)dexArchives), in.getAbsolutePath());
                DexArchiveBuilderCacheHandler.mergeJars(in, cacheableItems.get((Object)input));
            })).getQueryEvent().equals((Object)FileCache.QueryEvent.CORRUPTED)) continue;
            Verify.verifyNotNull((Object)result.getCauseOfCorruption());
            logger.info("The build cache at '%1$s' contained an invalid cache entry.\nCause: %2$s\nWe have recreated the cache entry.\n%3$s", cache.getCacheDirectory().getAbsolutePath(), Throwables.getStackTraceAsString((Throwable)result.getCauseOfCorruption()), "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html.");
        }
    }

    private static void mergeJars(File out, Iterable<File> dexArchives) throws IOException {
        try (JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(out)));){
            HashSet<String> usedNames = new HashSet<String>();
            for (File dexArchive : dexArchives) {
                if (!dexArchive.exists()) continue;
                JarFile jarFile = new JarFile(dexArchive);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        while (!usedNames.add(entryName)) {
                            entryName = "_" + entryName;
                        }
                        jarOutputStream.putNextEntry(new JarEntry(entryName));
                        try (BufferedInputStream inputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));){
                            ByteStreams.copy((InputStream)inputStream, (OutputStream)jarOutputStream);
                        }
                        jarOutputStream.closeEntry();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
        }
    }

    private static boolean isExternalLib(QualifiedContent content) {
        return content.getFile().isFile() && content.getScopes().equals(Collections.singleton(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) && content.getContentTypes().equals(Collections.singleton(QualifiedContent.DefaultContentType.CLASSES)) && !content.getName().startsWith("android.local.jars:");
    }

    public static FileCache.Inputs getBuildCacheInputs(File inputFile, DexOptions dexOptions, DexerTool dexerTool) throws IOException {
        FileCache.Inputs.Builder buildCacheInputs = new FileCache.Inputs.Builder(FileCache.Command.PREDEX_LIBRARY_TO_DEX_ARCHIVE);
        if (inputFile.getPath().contains("exploded-aar")) {
            buildCacheInputs.putString(FileCacheInputParams.EXPLODED_AAR_FILE_PATH.name(), inputFile.getPath().substring(inputFile.getPath().lastIndexOf("exploded-aar")));
        } else if (inputFile.getName().equals("instant-run.jar")) {
            buildCacheInputs.putString(FileCacheInputParams.INSTANT_RUN_JAR_FILE_NAME.name(), inputFile.getName());
        } else {
            buildCacheInputs.putFilePath(FileCacheInputParams.FILE_PATH.name(), inputFile);
        }
        buildCacheInputs.putFileHash(FileCacheInputParams.FILE_HASH.name(), inputFile).putString(FileCacheInputParams.DX_VERSION.name(), "1.14").putBoolean(FileCacheInputParams.JUMBO_MODE.name(), DexArchiveBuilderCacheHandler.isJumboModeEnabledForDx()).putBoolean(FileCacheInputParams.OPTIMIZE.name(), !dexOptions.getAdditionalParameters().contains("--no-optimize")).putString(FileCacheInputParams.DEXER_TOOL.name(), dexerTool.name()).putLong(FileCacheInputParams.CACHE_KEY_VERSION.name(), 1L);
        return buildCacheInputs.build();
    }

    public static String getFileHash(File file) throws IOException {
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = file.isDirectory() ? hashFunction.hashString((CharSequence)file.getPath(), Charsets.UTF_16LE) : Files.hash((File)file, (HashFunction)hashFunction);
        return hashCode.toString();
    }

    static boolean isJumboModeEnabledForDx() {
        return true;
    }

    private static enum FileCacheInputParams {
        FILE_PATH,
        EXPLODED_AAR_FILE_PATH,
        INSTANT_RUN_JAR_FILE_NAME,
        FILE_HASH,
        DX_VERSION,
        JUMBO_MODE,
        OPTIMIZE,
        DEXER_TOOL,
        CACHE_KEY_VERSION;

    }
}

