/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassWriter;

public class InstantRunSlicer
extends Transform {
    @VisibleForTesting
    static final String PACKAGE_FOR_GUARD_CLASS = "com/android/tools/fd/dummy";
    public static final int NUMBER_OF_SLICES_FOR_PROJECT_CLASSES = 10;
    private final ILogger logger;
    private final InstantRunVariantScope variantScope;

    public InstantRunSlicer(Logger logger, InstantRunVariantScope variantScope) {
        this.logger = new LoggerWrapper(logger);
        this.variantScope = variantScope;
    }

    public String getName() {
        return "instantRunSlicer";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS});
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws IOException, TransformException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        boolean isIncremental = transformInvocation.isIncremental();
        Collection inputs = transformInvocation.getInputs();
        if (outputProvider == null) {
            this.logger.error(null, "null TransformOutputProvider for InstantRunSlicer", new Object[0]);
            return;
        }
        Slices slices = new Slices();
        if (isIncremental) {
            this.processCodeChanges(inputs, outputProvider, slices);
        } else {
            InstantRunSlicer.slice(inputs, outputProvider, slices);
        }
    }

    private static void slice(Collection<TransformInput> inputs, TransformOutputProvider outputProvider, Slices slices) throws IOException, TransformException, InterruptedException {
        for (TransformInput input : inputs) {
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                File inputDir = directoryInput.getFile();
                for (File file : Files.fileTreeTraverser().breadthFirstTraversal((Object)directoryInput.getFile())) {
                    if (file.isDirectory()) continue;
                    String packagePath = FileUtils.relativePossiblyNonExistingPath((File)file.getParentFile(), (File)inputDir);
                    slices.addElement(packagePath, file);
                }
            }
        }
        slices.writeTo(outputProvider);
    }

    private void processCodeChanges(Collection<TransformInput> inputs, TransformOutputProvider outputProvider, Slices slices) throws TransformException, InterruptedException, IOException {
        for (TransformInput input : inputs) {
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                block6: for (Map.Entry changedFile : directoryInput.getChangedFiles().entrySet()) {
                    File fileToProcess = (File)changedFile.getKey();
                    Status status = (Status)changedFile.getValue();
                    File sliceOutputLocation = InstantRunSlicer.getOutputStreamForFile(outputProvider, directoryInput, fileToProcess, slices);
                    if (fileToProcess.isFile()) {
                        if (!sliceOutputLocation.exists() && !sliceOutputLocation.mkdirs()) {
                            throw new IOException("Cannot create folder " + sliceOutputLocation);
                        }
                        Files.write((CharSequence)String.valueOf(this.variantScope.getInstantRunBuildContext().getBuildId()), (File)new File(sliceOutputLocation, "buildId.txt"), (Charset)Charsets.UTF_8);
                        this.logger.verbose("Writing buildId in %s because of %s", new Object[]{sliceOutputLocation.getAbsolutePath(), changedFile.toString()});
                    }
                    String relativePath = FileUtils.relativePossiblyNonExistingPath((File)fileToProcess, (File)directoryInput.getFile());
                    File outputFile = new File(sliceOutputLocation, relativePath);
                    switch (status) {
                        case ADDED: 
                        case CHANGED: {
                            if (!fileToProcess.isFile()) continue block6;
                            Files.createParentDirs((File)outputFile);
                            Files.copy((File)fileToProcess, (File)outputFile);
                            this.logger.verbose("Copied %s to %s", new Object[]{fileToProcess, outputFile});
                            continue block6;
                        }
                        case REMOVED: {
                            if (!outputFile.exists()) continue block6;
                            if (outputFile.isDirectory()) {
                                FileUtils.deleteDirectoryContents((File)outputFile);
                            }
                            if (!outputFile.delete()) {
                                throw new TransformException(String.format("Cannot delete file %1$s", outputFile.getAbsolutePath()));
                            }
                            this.logger.verbose("Deleted %s", new Object[]{outputFile});
                            continue block6;
                        }
                    }
                    throw new TransformException("Unhandled status " + status);
                }
            }
        }
    }

    private static File getOutputStreamForFile(TransformOutputProvider transformOutputProvider, DirectoryInput input, File file, Slices slices) {
        String relativePackagePath = FileUtils.relativePossiblyNonExistingPath((File)file.getParentFile(), (File)input.getFile());
        Slice slice = slices.getSliceFor(new Slice.SlicedElement(relativePackagePath, file));
        return transformOutputProvider.getContentLocation(slice.name, TransformManager.CONTENT_CLASS, (Set)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS}), Format.DIRECTORY);
    }

    private static void createGuardClass(String name, File outputDir) throws IOException {
        ClassWriter cw = new ClassWriter(0);
        File packageDir = new File(outputDir, PACKAGE_FOR_GUARD_CLASS);
        File outputFile = new File(packageDir, name + ".class");
        Files.createParentDirs((File)outputFile);
        String appInfoOwner = "com/android/tools/fd/dummy/" + name;
        cw.visit(50, 33, appInfoOwner, null, "java/lang/Object", null);
        cw.visitEnd();
        Files.write((byte[])cw.toByteArray(), (File)outputFile);
    }

    private static class Slice {
        private final String name;
        private final int hashBucket;
        private final List<SlicedElement> slicedElements;

        private Slice(String name, int hashBucket) {
            this.name = name;
            this.hashBucket = hashBucket;
            this.slicedElements = new ArrayList<SlicedElement>();
        }

        private void add(SlicedElement slicedElement) {
            if (this.hashBucket != slicedElement.getHashBucket()) {
                throw new RuntimeException("Wrong bucket for " + slicedElement);
            }
            this.slicedElements.add(slicedElement);
        }

        private void writeTo(TransformOutputProvider outputProvider) throws IOException {
            File sliceOutputLocation = outputProvider.getContentLocation(this.name, TransformManager.CONTENT_CLASS, (Set)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS}), Format.DIRECTORY);
            FileUtils.cleanOutputDir((File)sliceOutputLocation);
            InstantRunSlicer.createGuardClass(this.name, sliceOutputLocation);
            for (SlicedElement slicedElement : this.slicedElements) {
                File outputFile = new File(sliceOutputLocation, new File(slicedElement.packagePath, slicedElement.slicedFile.getName()).getPath());
                Files.createParentDirs((File)outputFile);
                Files.copy((File)slicedElement.slicedFile, (File)outputFile);
            }
        }

        private static class SlicedElement {
            private final String packagePath;
            private final File slicedFile;

            private SlicedElement(String packagePath, File slicedFile) {
                this.packagePath = packagePath;
                this.slicedFile = slicedFile;
            }

            public int getHashBucket() {
                String hashTarget = Strings.isNullOrEmpty((String)this.packagePath) ? this.slicedFile.getName() : this.packagePath;
                return Math.abs(hashTarget.hashCode() % 10);
            }

            public String toString() {
                return this.packagePath + this.slicedFile.getName();
            }
        }
    }

    private static class Slices {
        private final List<Slice> slices = new ArrayList<Slice>();

        private Slices() {
            for (int i = 0; i < 10; ++i) {
                Slice newSlice = new Slice("slice_" + i, i);
                this.slices.add(newSlice);
            }
        }

        private void addElement(String packagePath, File file) {
            Slice.SlicedElement slicedElement = new Slice.SlicedElement(packagePath, file);
            Slice slice = this.getSliceFor(slicedElement);
            slice.add(slicedElement);
        }

        private void writeTo(TransformOutputProvider outputProvider) throws IOException {
            for (Slice slice : this.slices) {
                slice.writeTo(outputProvider);
            }
        }

        private Slice getSliceFor(Slice.SlicedElement slicedElement) {
            return this.slices.get(slicedElement.getHashBucket());
        }
    }
}

