/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.Option;

public enum OptionalBooleanOption implements Option<Boolean>
{
    SIGNING_V1_ENABLED("android.injected.signing.v1-enabled"),
    SIGNING_V2_ENABLED("android.injected.signing.v2-enabled"),
    IDE_TEST_ONLY("android.injected.testOnly"),
    SERIAL_AAPT2("android.injected.aapt2.serial");

    private final String propertyName;

    private OptionalBooleanOption(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Boolean getDefaultValue() {
        return null;
    }

    @Override
    public Boolean parse(Object value) {
        if (value instanceof CharSequence) {
            return Boolean.parseBoolean(value.toString());
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        throw new IllegalArgumentException("Cannot parse project property " + this.getPropertyName() + "='" + value + "' of type '" + value.getClass() + "' as boolean.");
    }
}

