/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import android.databinding.tool.store.LayoutFileParser;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.ResourceException;
import com.android.build.gradle.tasks.WorkerExecutorAdapter;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.Aapt2OutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.GeneratedResourceSet;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedResourceWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NoOpResourcePreprocessor;
import com.android.ide.common.res2.QueueableResourceCompiler;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.res2.ResourceSet;
import com.android.ide.common.res2.SingleFileProcessor;
import com.android.ide.common.vectordrawable.ResourcesNotSupportedException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class MergeResources
extends IncrementalTask {
    private File outputDir;
    private File generatedPngsOutputDir;
    private File publicFile;
    private boolean processResources;
    private boolean crunchPng;
    private boolean validateEnabled;
    private File blameLogFolder;
    private FileCache fileCache;
    private Supplier<Collection<File>> sourceFolderInputs;
    private Supplier<List<ResourceSet>> resSetSupplier;
    private List<ResourceSet> processedInputs;
    private ArtifactCollection libraries;
    private FileCollection renderscriptResOutputDir;
    private FileCollection generatedResOutputDir;
    private FileCollection microApkResDirectory;
    private FileCollection extraGeneratedResFolders;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();
    private boolean disableVectorDrawables;
    private Collection<String> generatedDensities;
    private int minSdk;
    private VariantScope variantScope;
    private AaptGeneration aaptGeneration;
    private SingleFileProcessor dataBindingExpressionRemover;
    private File dataBindingLayoutOutputFolder;
    private File mergedNotCompiledResourcesOutputDirectory;
    private boolean pseudoLocalesEnabled;
    private final WorkerExecutorFacade<MergedResourceWriter.FileGenerationParameters> workerExecutorFacade;

    private static Aapt makeAapt(AaptGeneration aaptGeneration, AndroidBuilder builder, FileCache fileCache, boolean crunchPng, VariantScope scope, File intermediateDir, MergingLog blameLog) throws IOException {
        ParsingProcessOutputHandler parsingProcessOutputHandler;
        if (blameLog != null) {
            MessageReceiver[] messageReceiverArray = new MessageReceiver[1];
            messageReceiverArray[0] = new MergingLogRewriter(arg_0 -> ((MergingLog)blameLog).find(arg_0), (MessageReceiver)builder.getErrorReporter());
            parsingProcessOutputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)(aaptGeneration == AaptGeneration.AAPT_V1 ? new AaptOutputParser() : new Aapt2OutputParser()), builder.getLogger()), messageReceiverArray);
        } else {
            parsingProcessOutputHandler = new LoggedProcessOutputHandler((ILogger)new AaptGradleFactory.FilteringLogger(builder.getLogger()));
        }
        return AaptGradleFactory.make(aaptGeneration, builder, (ProcessOutputHandler)parsingProcessOutputHandler, fileCache, crunchPng, intermediateDir, scope.getGlobalScope().getExtension().getAaptOptions().getCruncherProcesses());
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Inject
    public MergeResources(WorkerExecutor workerExecutor) {
        this.workerExecutorFacade = new WorkerExecutorAdapter<MergedResourceWriter.FileGenerationParameters>(workerExecutor, FileGenerationWorkAction.class);
    }

    @Override
    protected void doFullTaskAction() throws IOException, ExecutionException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            for (ResourceSet resourceSet : resourceSets) {
                resourceSet.loadFromFiles(this.getILogger());
                merger.addDataSet(resourceSet);
            }
            MergingLog mergingLog = this.getBlameLogFolder() != null ? new MergingLog(this.getBlameLogFolder()) : null;
            Object resourceCompiler = this.processResources ? MergeResources.makeAapt(this.aaptGeneration, this.getBuilder(), this.fileCache, this.crunchPng, this.variantScope, this.getAaptTempDir(), mergingLog) : QueueableResourceCompiler.NONE;
            MergedResourceWriter writer = new MergedResourceWriter(this.workerExecutorFacade, destinationDir, this.getPublicFile(), mergingLog, preprocessor, resourceCompiler, this.getIncrementalFolder(), this.dataBindingExpressionRemover, this.dataBindingLayoutOutputFolder, this.mergedNotCompiledResourcesOutputDirectory, this.pseudoLocalesEnabled, this.getCrunchPng());
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            System.out.println(e.getMessage());
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException, ExecutionException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            for (Object resourceSet : merger.getDataSets()) {
                resourceSet.setPreprocessor(preprocessor);
            }
            List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry entry : changedInputs.entrySet()) {
                File changedFile = (File)entry.getKey();
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, (FileStatus)entry.getValue(), this.getILogger())) continue;
                this.getLogger().info(String.format("Failed to process %s event! Full task run", entry.getValue()));
                this.doFullTaskAction();
                return;
            }
            MergingLog mergingLog = this.getBlameLogFolder() != null ? new MergingLog(this.getBlameLogFolder()) : null;
            Object resourceCompiler = this.processResources ? MergeResources.makeAapt(this.aaptGeneration, this.getBuilder(), this.fileCache, this.crunchPng, this.variantScope, this.getAaptTempDir(), mergingLog) : QueueableResourceCompiler.NONE;
            MergedResourceWriter writer = new MergedResourceWriter(this.workerExecutorFacade, this.getOutputDir(), this.getPublicFile(), mergingLog, preprocessor, resourceCompiler, this.getIncrementalFolder(), this.dataBindingExpressionRemover, this.dataBindingLayoutOutputFolder, this.mergedNotCompiledResourcesOutputDirectory, this.pseudoLocalesEnabled, this.getCrunchPng());
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.cleanup();
        }
    }

    private ResourcePreprocessor getPreprocessor() {
        if (this.isDisableVectorDrawables()) {
            return NoOpResourcePreprocessor.INSTANCE;
        }
        Collection densities = this.getGeneratedDensities().stream().map(Density::getEnum).collect(Collectors.toList());
        return new MergeResourcesVectorDrawableRenderer(this.getMinSdk(), this.getGeneratedPngsOutputDir(), densities, LoggerWrapper.supplierFor(MergeResources.class));
    }

    private List<ResourceSet> getConfiguredResourceSets(ResourcePreprocessor preprocessor) {
        if (this.processedInputs == null) {
            this.processedInputs = this.computeResourceSetList();
            ArrayList generatedSets = Lists.newArrayListWithCapacity((int)this.processedInputs.size());
            for (ResourceSet resourceSet : this.processedInputs) {
                resourceSet.setPreprocessor(preprocessor);
                GeneratedResourceSet generatedSet = new GeneratedResourceSet(resourceSet);
                resourceSet.setGeneratedSet((ResourceSet)generatedSet);
                generatedSets.add(generatedSet);
            }
            for (int i = 0; i < generatedSets.size(); ++i) {
                this.processedInputs.add(2 * i, (ResourceSet)generatedSets.get(i));
            }
        }
        return this.processedInputs;
    }

    private void cleanup() {
        this.fileValidity.clear();
        this.processedInputs = null;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getRenderscriptResOutputDir() {
        return this.renderscriptResOutputDir;
    }

    @VisibleForTesting
    void setRenderscriptResOutputDir(FileCollection renderscriptResOutputDir) {
        this.renderscriptResOutputDir = renderscriptResOutputDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getGeneratedResOutputDir() {
        return this.generatedResOutputDir;
    }

    @VisibleForTesting
    void setGeneratedResOutputDir(FileCollection generatedResOutputDir) {
        this.generatedResOutputDir = generatedResOutputDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getMicroApkResDirectory() {
        return this.microApkResDirectory;
    }

    @VisibleForTesting
    void setMicroApkResDirectory(FileCollection microApkResDirectory) {
        this.microApkResDirectory = microApkResDirectory;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getExtraGeneratedResFolders() {
        return this.extraGeneratedResFolders;
    }

    @VisibleForTesting
    void setExtraGeneratedResFolders(FileCollection extraGeneratedResFolders) {
        this.extraGeneratedResFolders = extraGeneratedResFolders;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getLibraries() {
        if (this.libraries != null) {
            return this.libraries.getArtifactFiles();
        }
        return null;
    }

    @VisibleForTesting
    void setLibraries(ArtifactCollection libraries) {
        this.libraries = libraries;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Collection<File> getSourceFolderInputs() {
        return this.sourceFolderInputs.get();
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    @Input
    public boolean getProcessResources() {
        return this.processResources;
    }

    @Optional
    @OutputFile
    public File getPublicFile() {
        return this.publicFile;
    }

    public void setPublicFile(File publicFile) {
        this.publicFile = publicFile;
    }

    @Input
    public boolean isValidateEnabled() {
        return this.validateEnabled;
    }

    public void setValidateEnabled(boolean validateEnabled) {
        this.validateEnabled = validateEnabled;
    }

    @OutputDirectory
    @Optional
    public File getBlameLogFolder() {
        return this.blameLogFolder;
    }

    public void setBlameLogFolder(File blameLogFolder) {
        this.blameLogFolder = blameLogFolder;
    }

    @OutputDirectory
    public File getGeneratedPngsOutputDir() {
        return this.generatedPngsOutputDir;
    }

    public void setGeneratedPngsOutputDir(File generatedPngsOutputDir) {
        this.generatedPngsOutputDir = generatedPngsOutputDir;
    }

    @Input
    public Collection<String> getGeneratedDensities() {
        return this.generatedDensities;
    }

    @Input
    public int getMinSdk() {
        return this.minSdk;
    }

    public void setMinSdk(int minSdk) {
        this.minSdk = minSdk;
    }

    public void setGeneratedDensities(Collection<String> generatedDensities) {
        this.generatedDensities = generatedDensities;
    }

    @Input
    public boolean isDisableVectorDrawables() {
        return this.disableVectorDrawables;
    }

    public void setDisableVectorDrawables(boolean disableVectorDrawables) {
        this.disableVectorDrawables = disableVectorDrawables;
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @OutputDirectory
    @Optional
    public File getDataBindingLayoutOutputFolder() {
        return this.dataBindingLayoutOutputFolder;
    }

    @OutputDirectory
    @Optional
    public File getMergedNotCompiledResourcesOutputDirectory() {
        return this.mergedNotCompiledResourcesOutputDirectory;
    }

    @Input
    public boolean isPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    @VisibleForTesting
    void setResSetSupplier(Supplier<List<ResourceSet>> resSetSupplier) {
        this.resSetSupplier = resSetSupplier;
    }

    @VisibleForTesting
    List<ResourceSet> computeResourceSetList() {
        List<ResourceSet> sourceFolderSets = this.resSetSupplier.get();
        int size = sourceFolderSets.size() + 4;
        if (this.libraries != null) {
            size += this.libraries.getArtifacts().size();
        }
        ArrayList resourceSetList = Lists.newArrayListWithExpectedSize((int)size);
        if (this.libraries != null) {
            Set libArtifacts = this.libraries.getArtifacts();
            for (ResolvedArtifactResult artifact : libArtifacts) {
                ResourceSet resourceSet = new ResourceSet(MergeManifests.getArtifactName(artifact), null, null, this.validateEnabled);
                resourceSet.setFromDependency(true);
                resourceSet.addSource(artifact.getFile());
                resourceSetList.add(0, resourceSet);
            }
        }
        resourceSetList.addAll(sourceFolderSets);
        ArrayList generatedResFolders = Lists.newArrayList();
        generatedResFolders.addAll(this.renderscriptResOutputDir.getFiles());
        generatedResFolders.addAll(this.generatedResOutputDir.getFiles());
        FileCollection extraFolders = this.getExtraGeneratedResFolders();
        if (extraFolders != null) {
            generatedResFolders.addAll(extraFolders.getFiles());
        }
        if (this.microApkResDirectory != null) {
            generatedResFolders.addAll(this.microApkResDirectory.getFiles());
        }
        ResourceSet mainResourceSet = sourceFolderSets.get(0);
        assert (mainResourceSet.getConfigName().equals("main"));
        mainResourceSet.addSources((Collection)generatedResFolders);
        return resourceSetList;
    }

    private File getAaptTempDir() {
        return FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp"));
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeResources> {
        private final VariantScope scope;
        private final String taskNamePrefix;
        private final File outputLocation;
        private final File mergedNotCompiledOutputDirectory;
        private final boolean includeDependencies;
        private final boolean processResources;

        public ConfigAction(VariantScope scope, String taskNamePrefix, File outputLocation, File mergedNotCompiledOutputDirectory, boolean includeDependencies, boolean processResources) {
            this.scope = scope;
            this.taskNamePrefix = taskNamePrefix;
            this.outputLocation = outputLocation;
            this.mergedNotCompiledOutputDirectory = mergedNotCompiledOutputDirectory;
            this.includeDependencies = includeDependencies;
            this.processResources = processResources;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(this.taskNamePrefix, "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        @Override
        public void execute(MergeResources mergeResourcesTask) {
            BaseVariantData variantData = this.scope.getVariantData();
            Project project = this.scope.getGlobalScope().getProject();
            mergeResourcesTask.setMinSdk(variantData.getVariantConfiguration().getMinSdkVersion().getApiLevel());
            mergeResourcesTask.aaptGeneration = AaptGeneration.fromProjectOptions(this.scope.getGlobalScope().getProjectOptions());
            mergeResourcesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeResourcesTask.fileCache = this.scope.getGlobalScope().getBuildCache();
            mergeResourcesTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            mergeResourcesTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
            mergeResourcesTask.variantScope = this.scope;
            if (this.includeDependencies) {
                mergeResourcesTask.setBlameLogFolder(this.scope.getResourceBlameLogDir());
            }
            mergeResourcesTask.processResources = this.processResources;
            mergeResourcesTask.crunchPng = this.scope.isCrunchPngs();
            VectorDrawablesOptions vectorDrawablesOptions = variantData.getVariantConfiguration().getMergedFlavor().getVectorDrawables();
            Set generatedDensities = vectorDrawablesOptions.getGeneratedDensities();
            mergeResourcesTask.setGeneratedDensities((Collection)MoreObjects.firstNonNull((Object)generatedDensities, Collections.emptySet()));
            mergeResourcesTask.setDisableVectorDrawables(vectorDrawablesOptions.getUseSupportLibrary() != null && vectorDrawablesOptions.getUseSupportLibrary() != false || mergeResourcesTask.getGeneratedDensities().isEmpty());
            boolean validateEnabled = !this.scope.getGlobalScope().getProjectOptions().get(BooleanOption.DISABLE_RESOURCE_VALIDATION);
            mergeResourcesTask.setValidateEnabled(validateEnabled);
            if (this.includeDependencies) {
                mergeResourcesTask.libraries = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_RES);
            }
            mergeResourcesTask.resSetSupplier = () -> variantData.getVariantConfiguration().getResourceSets(validateEnabled);
            mergeResourcesTask.sourceFolderInputs = TaskInputHelper.bypassFileSupplier(() -> variantData.getVariantConfiguration().getSourceFiles(SourceProvider::getResDirectories));
            mergeResourcesTask.extraGeneratedResFolders = variantData.getExtraGeneratedResFolders();
            mergeResourcesTask.renderscriptResOutputDir = (FileCollection)project.files(new Object[]{this.scope.getRenderscriptResOutputDir()});
            mergeResourcesTask.generatedResOutputDir = (FileCollection)project.files(new Object[]{this.scope.getGeneratedResOutputDir()});
            if (this.scope.getMicroApkTask() != null && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
                mergeResourcesTask.microApkResDirectory = (FileCollection)project.files(new Object[]{this.scope.getMicroApkResDirectory()});
            }
            mergeResourcesTask.setOutputDir(this.outputLocation);
            mergeResourcesTask.setGeneratedPngsOutputDir(this.scope.getGeneratedPngsOutputDir());
            variantData.mergeResourcesTask = mergeResourcesTask;
            if (this.scope.getGlobalScope().getExtension().getDataBinding().isEnabled()) {
                mergeResourcesTask.dataBindingExpressionRemover = LayoutFileParser::stripSingleLayoutFile;
                mergeResourcesTask.dataBindingLayoutOutputFolder = this.scope.getLayoutInputFolderForDataBinding();
            }
            mergeResourcesTask.mergedNotCompiledResourcesOutputDirectory = this.mergedNotCompiledOutputDirectory;
            mergeResourcesTask.pseudoLocalesEnabled = ((CoreBuildType)this.scope.getVariantData().getVariantConfiguration().getBuildType()).isPseudoLocalesEnabled();
        }
    }

    private static class MergeResourcesVectorDrawableRenderer
    extends VectorDrawableRenderer {
        public MergeResourcesVectorDrawableRenderer(int minSdk, File outputDir, Collection<Density> densities, Supplier<ILogger> loggerSupplier) {
            super(minSdk, outputDir, densities, loggerSupplier);
        }

        public void generateFile(File toBeGenerated, File original) throws IOException {
            try {
                super.generateFile(toBeGenerated, original);
            }
            catch (ResourcesNotSupportedException e) {
                throw new GradleException(String.format("Can't process attribute %1$s=\"%2$s\": references to other resources are not supported by build-time PNG generation. See http://developer.android.com/tools/help/vector-asset-studio.html for details.", e.getName(), e.getValue()));
            }
        }
    }

    public static class FileGenerationWorkAction
    implements Runnable {
        private final MergedResourceWriter.FileGenerationWorkAction workAction;

        @Inject
        public FileGenerationWorkAction(MergedResourceWriter.FileGenerationParameters workItem) {
            this.workAction = new MergedResourceWriter.FileGenerationWorkAction(workItem);
        }

        @Override
        public void run() {
            this.workAction.run();
        }
    }
}

